/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.Operator;
import openmods.calc.SymbolMap;
import openmods.utils.Stack;

public abstract class UnaryOperator<E>
extends Operator<E> {
    private UnaryOperator(String id) {
        super(id);
    }

    @Override
    public boolean isLessThan(Operator<E> other) {
        return false;
    }

    public String toString() {
        return "UnaryOperator [" + this.id + "]";
    }

    public static abstract class StackBased<E>
    extends UnaryOperator<E> {
        public StackBased(String id) {
            super(id);
        }

        public abstract void executeOnStack(Frame<E> var1);

        @Override
        public final void execute(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 1);
            this.executeOnStack(executionFrame);
            executionFrame.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Scoped<E>
    extends UnaryOperator<E> {
        public Scoped(String id) {
            super(id);
        }

        public abstract E execute(SymbolMap<E> var1, E var2);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E value = stack.pop();
            E result = this.execute(frame.symbols(), value);
            stack.push(result);
        }
    }

    public static abstract class Direct<E>
    extends UnaryOperator<E> {
        public Direct(String id) {
            super(id);
        }

        public abstract E execute(E var1);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E value = stack.pop();
            E result = this.execute(value);
            stack.push(result);
        }
    }
}

