/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import openmods.calc.types.multi.MetaObject;
import openmods.reflection.TypeVariableHolder;

public class MetaObjectInfo {
    public static final Map<String, SlotAccess> slots;

    private static MetaObject.SlotAdapter<MetaObject.Slot> createAdapterInstance(Class<?> slotCls, MetaObject.SlotField annotation) {
        Class<? extends MetaObject.SlotAdapter<? extends MetaObject.Slot>> adapterCls = annotation.adapter();
        Class slotAdapterTarget = TypeToken.of(adapterCls).resolveType(SlotAdapterVars.T).getRawType();
        Preconditions.checkState((slotAdapterTarget == slotCls ? 1 : 0) != 0, (String)"Invalid slot adapter type: expected %s, got %s", (Object[])new Object[]{slotCls, slotAdapterTarget});
        try {
            return adapterCls.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        ImmutableMap.Builder slotsBuilder = ImmutableMap.builder();
        HashMap builderMethods = Maps.newHashMap();
        for (Method method : MetaObject.Builder.class.getDeclaredMethods()) {
            if (!method.getName().equals("set")) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Preconditions.checkState((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid builder method: %s", (Object[])new Object[]{method});
            Class<?> slotCls = parameterTypes[0];
            Preconditions.checkState((boolean)MetaObject.Slot.class.isAssignableFrom(slotCls), (String)"Invalid builder method: %s", (Object[])new Object[]{method});
            builderMethods.put(slotCls, method);
        }
        for (AccessibleObject accessibleObject : MetaObject.class.getDeclaredFields()) {
            MetaObject.SlotField annotation = ((Field)accessibleObject).getAnnotation(MetaObject.SlotField.class);
            if (annotation == null) continue;
            String fieldName = ((Field)accessibleObject).getName();
            if (!fieldName.startsWith("slot")) {
                throw new AssertionError((Object)("Invalid slot name: " + fieldName));
            }
            String slotName = fieldName.substring("slot".length());
            String lcSlotName = slotName.toLowerCase(Locale.ROOT);
            Class<?> slotCls = ((Field)accessibleObject).getType();
            MetaObject.SlotAdapter<MetaObject.Slot> adapter = MetaObjectInfo.createAdapterInstance(slotCls, annotation);
            Method builderMethod = (Method)builderMethods.get(slotCls);
            Preconditions.checkState((builderMethod != null ? 1 : 0) != 0, (String)"Missing builder method for %s", (Object[])new Object[]{lcSlotName});
            slotsBuilder.put((Object)lcSlotName, (Object)new SlotAccess((Field)accessibleObject, builderMethod, lcSlotName, adapter));
        }
        slots = slotsBuilder.build();
    }

    public static class SlotAccess {
        public final String name;
        public final Predicate<MetaObject> isPresent;
        public final MetaObject.SlotAdapter<MetaObject.Slot> adapter;
        private final Field field;
        private final Method builderMethod;

        public SlotAccess(final Field field, Method builderMethod, String name, MetaObject.SlotAdapter<MetaObject.Slot> adapter) {
            this.field = field;
            this.name = name;
            this.isPresent = new Predicate<MetaObject>(){

                public boolean apply(MetaObject input) {
                    try {
                        return field.get(input) != null;
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
            this.adapter = adapter;
            this.builderMethod = builderMethod;
        }

        public MetaObject.Slot get(MetaObject mo) {
            try {
                return (MetaObject.Slot)this.field.get(mo);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void set(MetaObject.Builder builder, MetaObject.Slot slot) {
            try {
                this.builderMethod.invoke((Object)builder, slot);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @TypeVariableHolder(value=MetaObject.SlotAdapter.class)
    public static class SlotAdapterVars {
        public static TypeVariable<?> T;
    }
}

