/*
 * Decompiled with CFR 0.152.
 */
package openmods.stencil;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeSet;
import net.minecraftforge.client.MinecraftForgeClient;
import openmods.Log;
import openmods.stencil.FramebufferHooks;
import openmods.stencil.StencilBitAllocation;

public class StencilPoolManager {
    private static final StencilPool DUMMY = new StencilPool(){

        @Override
        public StencilBitAllocation acquire() {
            return null;
        }

        @Override
        public void release(StencilBitAllocation bit) {
            throw new IllegalStateException();
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public String getType() {
            return "disabled";
        }
    };
    private static StencilPool pool;

    public static StencilPool pool() {
        if (pool == null) {
            pool = StencilPoolManager.selectPool();
        }
        return pool;
    }

    private static StencilPool selectPool() {
        boolean forgeHasActualBits;
        boolean forgeHasDeclaredBits = MinecraftForgeClient.getStencilBits() > 0;
        boolean bl = forgeHasActualBits = !StencilPoolManager.isForgePoolEmpty();
        if (forgeHasDeclaredBits) {
            if (forgeHasActualBits) {
                return new ForgePool(StencilPoolManager.getForgeStencilFlag());
            }
            return new InternalPool(true);
        }
        if (FramebufferHooks.STENCIL_BUFFER_INJECTED) {
            return new InternalPool(false);
        }
        return DUMMY;
    }

    private static boolean isForgePoolEmpty() {
        try {
            Field f = MinecraftForgeClient.class.getDeclaredField("stencilBits");
            f.setAccessible(true);
            BitSet pool = (BitSet)f.get(null);
            return pool.isEmpty();
        }
        catch (Exception e) {
            Log.warn(e, "Failed to get field!", new Object[0]);
            return false;
        }
    }

    private static boolean getForgeStencilFlag() {
        return Boolean.parseBoolean(System.getProperty("forge.forceDisplayStencil", "false"));
    }

    private static class InternalPool
    implements StencilPool {
        private final TreeSet<StencilBitAllocation> bits = Sets.newTreeSet();
        private final boolean isForgeHacked;

        public InternalPool(boolean isForgeHacked) {
            this.isForgeHacked = isForgeHacked;
            for (int i = 0; i < 8; ++i) {
                this.bits.add(new StencilBitAllocation(i));
            }
        }

        @Override
        public synchronized void release(StencilBitAllocation allocation) {
            this.bits.add(allocation);
        }

        @Override
        public synchronized StencilBitAllocation acquire() {
            Iterator<StencilBitAllocation> it = this.bits.descendingIterator();
            if (it.hasNext()) {
                StencilBitAllocation result = it.next();
                it.remove();
                return result;
            }
            return null;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public String getType() {
            return this.isForgeHacked ? "internal (hacked forge)" : "internal";
        }
    }

    private static class ForgePool
    implements StencilPool {
        private final boolean isForced;

        public ForgePool(boolean isForced) {
            this.isForced = isForced;
        }

        @Override
        public StencilBitAllocation acquire() {
            int bit = MinecraftForgeClient.reserveStencilBit();
            return bit != -1 ? new StencilBitAllocation(bit) : null;
        }

        @Override
        public void release(StencilBitAllocation allocation) {
            MinecraftForgeClient.releaseStencilBit((int)allocation.bit);
        }

        @Override
        public int getSize() {
            return MinecraftForgeClient.getStencilBits();
        }

        @Override
        public String getType() {
            return this.isForced ? "forge (forced)" : "forge";
        }
    }

    public static interface StencilPool {
        public StencilBitAllocation acquire();

        public void release(StencilBitAllocation var1);

        public int getSize();

        public String getType();
    }
}

