/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.redstoneflux;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import covers1624.powerconverters.tile.redstoneflux.TileEntityRedstoneFluxConsumer;
import covers1624.powerconverters.util.BlockPosition;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRedstoneFluxProducer
extends TileEntityEnergyProducer<IEnergyProvider>
implements IEnergyProvider {
    public TileEntityRedstoneFluxProducer() {
        super(PowerSystems.powerSystemRedstoneFlux, 0, IEnergyProvider.class);
    }

    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    public int extractEnergy(ForgeDirection arg0, int arg1, boolean arg2) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection arg0) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)(bridge.getEnergyStored() / (double)this.getPowerSystem().getScaleAmmount());
    }

    public int getMaxEnergyStored(ForgeDirection arg0) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)(bridge.getEnergyStoredMax() / (double)this.getPowerSystem().getScaleAmmount());
    }

    @Override
    public double produceEnergy(double energy) {
        if (ConfigurationHandler.dissableRFProducer) {
            return energy;
        }
        double toUseRF = energy / (double)this.getPowerSystem().getScaleAmmount();
        if (toUseRF > 0.0) {
            List<BlockPosition> pos = new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e).getAdjacent(true);
            for (BlockPosition p : pos) {
                IEnergyHandler handler;
                double RF;
                TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
                if (!(te instanceof IEnergyHandler) || te instanceof TileEntityRedstoneFluxConsumer || te instanceof TileEntityEnergyBridge || !((energy -= (RF = (double)(handler = (IEnergyHandler)te).receiveEnergy(p.orientation.getOpposite(), (int)toUseRF, false)) * (double)this.getPowerSystem().getScaleAmmount()) <= 0.0)) continue;
                break;
            }
        }
        return energy;
    }
}

