/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.api.core.Position;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsGravityFeed
extends APPipe<PipeTransportItems> {
    private int ticksSincePull = 0;

    public PipeItemsGravityFeed(Item item) {
        super(new PipeTransportItems(), item);
    }

    private boolean shouldTick() {
        return this.ticksSincePull >= APConfiguration.gravityFeedPipeTicksPerPull;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSincePull;
        if (this.shouldTick()) {
            World w = this.getWorld();
            TileEntity tile = w.func_147438_o(this.container.field_145851_c, this.container.field_145848_d + 1, this.container.field_145849_e);
            this.ticksSincePull = 0;
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                ItemStack extracted = this.removeItem(inventory, true, ForgeDirection.DOWN);
                if (extracted == null || extracted.field_77994_a == 0) {
                    return;
                }
                Position entityPos = new Position((double)this.container.field_145851_c + 0.5, (double)((float)(this.container.field_145848_d + 1) + 0.25f), (double)this.container.field_145849_e + 0.5, ForgeDirection.DOWN);
                entityPos.moveForwards(0.5);
                TravelingItem entity = TravelingItem.make((double)entityPos.x, (double)entityPos.y, (double)entityPos.z, (ItemStack)extracted);
                ((PipeTransportItems)this.transport).injectItem(entity, ForgeDirection.DOWN);
            }
        }
    }

    public ItemStack removeItem(IInventory inventory, boolean doRemove, ForgeDirection from) {
        IInventory inv = InvUtils.getInventory((IInventory)inventory);
        int first = 0;
        int last = inv.func_70302_i_() - 1;
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] accessibleSlots = sidedInv.func_94128_d(from.ordinal());
            ItemStack result = this.removeItemSided(sidedInv, doRemove, from, accessibleSlots);
            return result;
        }
        ItemStack result = this.removeItemNormal(inv, doRemove, from, first, last);
        return result;
    }

    public ItemStack removeItemNormal(IInventory inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, 1);
            }
            return slot;
        }
        return null;
    }

    public ItemStack removeItemSided(ISidedInventory inventory, boolean doRemove, ForgeDirection from, int[] slots) {
        for (int i : slots) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_102008_b(i, slot, from.ordinal())) continue;
            if (doRemove) {
                return inventory.func_70298_a(i, 1);
            }
            return slot;
        }
        return null;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            return 33;
        }
        return 32;
    }

    public boolean doDrop() {
        Utils.preDestroyBlock((World)this.getWorld(), (int)this.container.field_145851_c, (int)this.container.field_145848_d, (int)this.container.field_145849_e);
        return true;
    }
}

