/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import hardcorequesting.DeathType;
import hardcorequesting.QuestingData;
import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class DeathStats {
    private static Map<String, DeathStats> clientDeaths;
    private static DeathStats[] clientDeathList;
    private static DeathStats clientBest;
    private static DeathStats clientTotal;
    private String name;
    protected int[] deaths = new int[DeathType.values().length];
    private int totalDeaths = -1;
    private static final DeathComparator deathComparator;
    private static final DeathComparator[] deathTypeComparator;

    public static DeathStats getBest() {
        return clientBest;
    }

    public static DeathStats getTotal() {
        return clientTotal;
    }

    public DeathStats(String name) {
        this.name = name;
    }

    public String getName() {
        return Translator.translate(this.name);
    }

    public String getDescription(int id) {
        return DeathType.values()[id].getName() + ": " + this.deaths[id];
    }

    public void increaseDeath(int id) {
        if (this.deaths[id] < DataBitHelper.DEATHS.getMaximum()) {
            int n = id;
            this.deaths[n] = this.deaths[n] + 1;
            this.refreshSync();
        }
    }

    public static void handlePacket(EntityPlayer player, DataReader dr) {
        String name = dr.readString(DataBitHelper.NAME_LENGTH);
        DeathStats deathStats = clientDeaths.get(name);
        if (deathStats == null) {
            deathStats = new DeathStats(name);
            clientDeaths.put(name, deathStats);
        }
        deathStats.load(dr);
        DeathStats.updateClientDeathList();
    }

    public int getTotalDeaths() {
        if (this.totalDeaths == -1) {
            this.totalDeaths = 0;
            for (int death : this.deaths) {
                this.totalDeaths += death;
            }
        }
        return this.totalDeaths;
    }

    public int getDeaths(int id) {
        return this.deaths[id];
    }

    public void load(DataReader dr) {
        for (int i = 0; i < this.deaths.length; ++i) {
            this.deaths[i] = dr.readData(DataBitHelper.DEATHS);
        }
    }

    public void save(DataWriter dw) {
        for (int death : this.deaths) {
            dw.writeData(death, DataBitHelper.DEATHS);
        }
    }

    public static void load(QuestingData questingData, DataReader dr, boolean light) {
        if (light) {
            clientDeaths = new HashMap<String, DeathStats>();
            int count = dr.readData(DataBitHelper.PLAYERS);
            for (int i = 0; i < count; ++i) {
                String name = dr.readString(DataBitHelper.NAME_LENGTH);
                DeathStats stats = new DeathStats(name);
                stats.load(dr);
                clientDeaths.put(name, stats);
            }
            DeathStats.updateClientDeathList();
        } else {
            questingData.getDeathStat().load(dr);
        }
    }

    public static void save(QuestingData questingData, DataWriter dw, boolean light) {
        if (light) {
            dw.writeData(QuestingData.getData().size(), DataBitHelper.PLAYERS);
            for (QuestingData q : QuestingData.getData().values()) {
                dw.writeString(q.getName(), DataBitHelper.NAME_LENGTH);
                q.getDeathStat().save(dw);
            }
        } else {
            questingData.getDeathStat().save(dw);
        }
    }

    public void refreshSync() {
        DataWriter dw = PacketHandler.getWriter(PacketId.DEATH_STATS_UPDATE);
        dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
        this.save(dw);
        PacketHandler.sendToAllPlayersWithOpenBook(dw);
    }

    private static void updateClientDeathList() {
        clientDeathList = new DeathStats[clientDeaths.size()];
        int id = 0;
        for (DeathStats deathStats : clientDeaths.values()) {
            deathStats.totalDeaths = -1;
            DeathStats.clientDeathList[id++] = deathStats;
        }
        clientBest = new DeathStatsBest();
        clientTotal = new DeathStatsTotal();
        Arrays.sort(clientDeathList, deathComparator);
    }

    public static DeathStats getDeathStats(String name) {
        return clientDeaths.get(name);
    }

    public static DeathStats[] getDeathStats() {
        return clientDeathList;
    }

    static {
        deathComparator = new DeathComparator(-1);
        deathTypeComparator = new DeathComparator[DeathType.values().length];
        for (int i = 0; i < deathTypeComparator.length; ++i) {
            DeathStats.deathTypeComparator[i] = new DeathComparator(i);
        }
    }

    private static class DeathStatsTotal
    extends DeathStats {
        private int[] count = new int[DeathType.values().length];

        private DeathStatsTotal() {
            super("hqm.deathStat.everyone");
            for (int i = 0; i < this.count.length; ++i) {
                for (DeathStats deathStats : clientDeathList) {
                    int n = i;
                    this.deaths[n] = this.deaths[n] + deathStats.getDeaths(i);
                    if (deathStats.getDeaths(i) <= 0) continue;
                    int n2 = i;
                    this.count[n2] = this.count[n2] + 1;
                }
            }
        }

        @Override
        public String getDescription(int id) {
            return super.getDescription(id) + "\n\n" + (this.count[id] == 0 ? (Object)((Object)GuiColor.RED) + Translator.translate("hqm.deathStat.noOneDied") : GuiColor.GREEN.toString() + this.count[id] + " " + Translator.translate("hqm.deathStat.player" + (this.count[id] == 1 ? "" : "s")) + " " + Translator.translate("hqm.deathStat.diedThisWay"));
        }
    }

    private static class DeathStatsBest
    extends DeathStats {
        private static final String[] colourPrefixes = new String[]{GuiColor.YELLOW.toString(), GuiColor.LIGHT_GRAY.toString(), GuiColor.ORANGE.toString()};
        private static final String[] placePrefixes = new String[]{"first", "second", "third"};
        private String[] messages = new String[DeathType.values().length];

        private DeathStatsBest() {
            super("hqm.deathStat.worstPlayers");
            block0: for (int i = 0; i < this.messages.length; ++i) {
                Arrays.sort(clientDeathList, deathTypeComparator[i]);
                this.deaths[i] = clientDeathList[0].getDeaths(i);
                if (clientDeathList[0].getDeaths(i) == 0) {
                    this.messages[i] = (Object)((Object)GuiColor.RED) + Translator.translate("hqm.deathStat.noOneDied");
                    continue;
                }
                this.messages[i] = "";
                int currentValue = 0;
                int standing = 0;
                for (int j = 0; j < clientDeathList.length; ++j) {
                    int value = clientDeathList[j].getDeaths(i);
                    if (value < currentValue) {
                        standing = j;
                        if (value == 0 || standing >= 3) continue block0;
                    }
                    currentValue = value;
                    if (j != 0) {
                        int n = i;
                        this.messages[n] = this.messages[n] + "\n";
                    }
                    int n = i;
                    this.messages[n] = this.messages[n] + colourPrefixes[standing] + Translator.translate("hqm.deathStat." + placePrefixes[standing]);
                    int n2 = i;
                    this.messages[n2] = this.messages[n2] + (Object)((Object)GuiColor.WHITE) + " " + clientDeathList[j].getName() + ": " + clientDeathList[j].getDeaths(i);
                }
            }
        }

        @Override
        public String getDescription(int id) {
            return DeathType.values()[id].getName() + "\n\n" + this.messages[id];
        }
    }

    private static class DeathComparator
    implements Comparator<DeathStats> {
        private int id;

        private DeathComparator(int id) {
            this.id = id;
        }

        @Override
        public int compare(DeathStats o1, DeathStats o2) {
            if (this.id == -1) {
                return Integer.valueOf(o2.getTotalDeaths()).compareTo(o1.getTotalDeaths());
            }
            return Integer.valueOf(o2.getDeaths(this.id)).compareTo(o1.getDeaths(this.id));
        }
    }
}

