/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.common.FMLCommonHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.TeamStats;
import hardcorequesting.Translator;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.reputation.Reputation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class Team {
    private RewardSetting rewardSetting = RewardSetting.access$000();
    private LifeSetting lifeSetting = LifeSetting.SHARE;
    private int clientTeamLives = -1;
    public static ErrorMessage latestError;
    private int id = -1;
    private List<PlayerEntry> players = new ArrayList<PlayerEntry>();
    private List<Team> invites;
    private String name;
    private List<Integer> reputation;
    private List<QuestData> questData;
    public static boolean reloadedInvites;

    public void resetProgress(Quest quest) {
        this.questData.set(quest.getId(), Quest.getQuest(quest.getId()).createData(this.getPlayerCount()));
    }

    public float getProgress() {
        int completed = 0;
        int total = 0;
        for (QuestData data : this.questData) {
            if (data == null) continue;
            ++total;
            if (!data.completed) continue;
            ++completed;
        }
        return (float)completed / (float)total;
    }

    public void receiveAndSyncReputation(Quest quest, List<Quest.ReputationReward> reputationList) {
        for (Quest.ReputationReward reputationReward : reputationList) {
            this.setReputation(reputationReward.getReputation(), this.getReputation(reputationReward.getReputation()) + reputationReward.getValue());
        }
        DataWriter dw = this.getRefreshDataWriter(RefreshType.REPUTATION_RECEIVED);
        dw.writeData((int)quest.getId(), DataBitHelper.QUESTS);
        dw.writeData(reputationList.size(), DataBitHelper.REPUTATION);
        for (Quest.ReputationReward reputationReward : reputationList) {
            dw.writeData(reputationReward.getReputation().getId(), DataBitHelper.REPUTATION);
            dw.writeData(this.getReputation(reputationReward.getReputation()), DataBitHelper.REPUTATION_VALUE);
        }
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.shouldRefreshData() || !entry.isInTeam()) continue;
            PacketHandler.sendToPlayer(entry.getName(), dw);
        }
    }

    private void readReceivedReputationData(DataReader dr) {
        QuestData data;
        int questId = dr.readData(DataBitHelper.QUESTS);
        Quest quest = Quest.getQuest(questId);
        if (quest != null && (data = this.getQuestData(questId)) != null) {
            data.claimed = true;
            int count = dr.readData(DataBitHelper.REPUTATION);
            for (int i = 0; i < count; ++i) {
                int id = dr.readData(DataBitHelper.REPUTATION);
                int val = dr.readData(DataBitHelper.REPUTATION_VALUE);
                this.setReputation(id, (Integer)val);
            }
        }
    }

    public RewardSetting getRewardSetting() {
        return this.rewardSetting;
    }

    public LifeSetting getLifeSetting() {
        return this.lifeSetting;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSharingLives() {
        return this.lifeSetting == LifeSetting.SHARE;
    }

    public int getSharedLives() {
        if (this.clientTeamLives != -1) {
            return this.clientTeamLives;
        }
        int lives = 0;
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.inTeam) continue;
            lives += QuestingData.getQuestingData(entry.getName()).getRawLives();
        }
        return lives;
    }

    public int getPlayerCount() {
        int count = 0;
        for (PlayerEntry player : this.players) {
            if (!player.inTeam) continue;
            ++count;
        }
        return count;
    }

    public void removePlayer(String playerName) {
        int id = 0;
        for (PlayerEntry player : this.players) {
            if (!player.inTeam) continue;
            if (player.getName().equals(playerName)) {
                QuestData data;
                QuestData leaveData;
                int i;
                Team leaveTeam = new Team(playerName);
                leaveTeam.getPlayers().get(0).setBookOpen(player.bookOpen);
                for (i = 0; i < this.questData.size(); ++i) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null) continue;
                    boolean[] old = data.reward;
                    data.reward = new boolean[old.length - 1];
                    for (int j = 0; j < data.reward.length; ++j) {
                        data.reward[j] = j < id ? old[j] : old[j + 1];
                    }
                    leaveData.reward[0] = old[id];
                }
                this.players.remove(id);
                for (i = 0; i < this.questData.size(); ++i) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null || Quest.getQuest(i) == null) continue;
                    Quest.getQuest(i).copyProgress(leaveData, data);
                }
                for (i = 0; i < Reputation.size(); ++i) {
                    Reputation reputation = Reputation.getReputation(i);
                    if (reputation == null) continue;
                    leaveTeam.setReputation(reputation, this.getReputation(reputation));
                }
                QuestingData.getQuestingData(playerName).setTeam(leaveTeam);
                break;
            }
            ++id;
        }
    }

    public void refreshTeamData(UpdateType type) {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, type);
        }
    }

    private void refreshTeamData(PlayerEntry entry, UpdateType type) {
        Team team = this;
        boolean valid = false;
        switch (type) {
            case ALL: {
                if (entry.shouldRefreshData()) {
                    valid = true;
                    break;
                }
            }
            case ONLY_INVITES: {
                team = QuestingData.getQuestingData(entry.getName()).getTeam();
                valid = !entry.isInTeam() && team.getEntry(entry.getName()).shouldRefreshData();
                break;
            }
            case ONLY_MEMBERS: {
                valid = entry.shouldRefreshData();
                break;
            }
            case ONLY_OWNER: {
                boolean bl = valid = entry.shouldRefreshData() && entry.isOwner();
            }
        }
        if (valid) {
            DataWriter dw = this.getRefreshDataWriter(RefreshType.FULL);
            team.writeTeamData(dw, true);
            PacketHandler.sendToPlayer(entry.getName(), dw);
        }
    }

    private DataWriter getRefreshDataWriter(RefreshType type) {
        DataWriter dw = PacketHandler.getWriter(PacketId.REFRESH_TEAM);
        dw.writeEnum(type);
        return dw;
    }

    public void refreshTeamLives() {
        if (!this.isSingle() && this.isSharingLives()) {
            for (PlayerEntry entry : this.getPlayers()) {
                if (!entry.shouldRefreshData()) continue;
                DataWriter dw = this.getRefreshDataWriter(RefreshType.LIVES);
                dw.writeData(this.getSharedLives(), DataBitHelper.TEAM_LIVES);
                PacketHandler.sendToPlayer(entry.getName(), dw);
            }
        }
    }

    public void refreshData() {
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.shouldRefreshData()) continue;
            QuestingData.getQuestingData(entry.getName()).refreshClientData(entry.getName());
        }
    }

    public void clearProgress() {
        this.questData.clear();
        this.createQuestData();
        int playerCount = this.getPlayerCount();
        for (int i = 0; i < Quest.size(); ++i) {
            if (Quest.getQuest(i) == null || this.questData.get(i) == null) continue;
            Quest.getQuest(i).preRead(playerCount, this.questData.get(i));
        }
        this.refreshData();
    }

    public void onPacket(DataReader dr) {
        RefreshType type = dr.readEnum(RefreshType.class);
        switch (type) {
            case FULL: {
                this.readTeamData(QuestingData.FILE_VERSION, dr, true);
                break;
            }
            case LIVES: {
                this.clientTeamLives = dr.readData(DataBitHelper.TEAM_LIVES);
                break;
            }
            case REPUTATION_RECEIVED: {
                this.readReceivedReputationData(dr);
            }
        }
    }

    public void deleteTeam() {
        for (int i = this.players.size() - 1; i >= 0; --i) {
            PlayerEntry player = this.players.get(i);
            if (player.isInTeam()) {
                this.removePlayer(player.getName());
            } else {
                this.players.remove(i);
            }
            QuestingData.getQuestingData(player.getName()).getTeam().refreshTeamData(player, UpdateType.ONLY_MEMBERS);
        }
        List<Team> teams = QuestingData.getTeams();
        teams.remove(this.id);
        for (int i = this.id; i < teams.size(); ++i) {
            Team team = teams.get(i);
            --team.id;
        }
        for (String username : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
            Team team = QuestingData.getQuestingData(username).getTeam();
            PlayerEntry entry = team.getEntry(username);
            if (entry == null) continue;
            team.refreshTeamData(entry, UpdateType.ONLY_MEMBERS);
        }
    }

    public List<Team> getInvites() {
        return this.invites;
    }

    public List<PlayerEntry> getPlayers() {
        return this.players;
    }

    private DataWriter getWriter(TeamAction action) {
        DataWriter dw = PacketHandler.getWriter(PacketId.TEAM);
        dw.writeData(action.ordinal(), DataBitHelper.TEAM_ACTION_ID);
        return dw;
    }

    public void create(String name) {
        DataWriter dw = this.getWriter(TeamAction.CREATE);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void invite(String name) {
        DataWriter dw = this.getWriter(TeamAction.INVITE);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void accept() {
        DataWriter dw = this.getWriter(TeamAction.ACCEPT);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        PacketHandler.sendToServer(dw);
    }

    public void decline() {
        DataWriter dw = this.getWriter(TeamAction.DECLINE);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        PacketHandler.sendToServer(dw);
    }

    public void kick(String name) {
        DataWriter dw = this.getWriter(TeamAction.KICK);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void leave() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.LEAVE));
    }

    public void disband() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.DISBAND));
    }

    public void nextLifeSetting() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.NEXT_LIFE_SETTING));
    }

    public void nextRewardSetting() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.NEXT_REWARD_SETTING));
    }

    public static void handlePacket(EntityPlayer player, DataReader dr, boolean onServer) {
        if (onServer) {
            Team.handleServerPacket(player, dr);
        } else {
            Team.handleClientPacket(player, dr);
        }
    }

    private static void handleClientPacket(EntityPlayer player, DataReader dr) {
        latestError = ErrorMessage.values()[dr.readData(DataBitHelper.TEAM_ERROR)];
    }

    private static void handleServerPacket(EntityPlayer player, DataReader dr) {
        TeamAction action = TeamAction.values()[dr.readData(DataBitHelper.TEAM_ACTION_ID)];
        String playerName = QuestingData.getUserName(player);
        Team team = QuestingData.getQuestingData(player).getTeam();
        block0 : switch (action) {
            case CREATE: {
                String teamName;
                if (!team.isSingle() || (teamName = dr.readString(DataBitHelper.NAME_LENGTH)).length() == 0) break;
                for (Team t : QuestingData.getTeams()) {
                    if (!t.getName().equals(teamName)) continue;
                    ErrorMessage.USED_NAME.sendToClient(player);
                    return;
                }
                QuestingData.addTeam(team);
                team.name = teamName;
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                Team.declineAll(playerName);
                TeamStats.refreshTeam(team);
                break;
            }
            case INVITE: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                PlayerEntry entry = new PlayerEntry(dr.readString(DataBitHelper.NAME_LENGTH), false, false);
                if (!QuestingData.hasData(entry.getName())) {
                    ErrorMessage.INVALID_PLAYER.sendToClient(player);
                    break;
                }
                if (!QuestingData.getQuestingData(entry.getName()).getTeam().isSingle()) {
                    ErrorMessage.IN_PARTY.sendToClient(player);
                    break;
                }
                if (team.players.contains(entry)) break;
                team.players.add(entry);
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                QuestingData.getQuestingData(entry.getName()).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case ACCEPT: {
                int acceptId;
                if (!team.isSingle() || (acceptId = dr.readData(DataBitHelper.TEAMS)) < 0 || acceptId >= QuestingData.getTeams().size()) break;
                Team inviteTeam = QuestingData.getTeams().get(acceptId);
                int id = 0;
                for (PlayerEntry entry : inviteTeam.getPlayers()) {
                    QuestData questData;
                    QuestData joinData;
                    int i;
                    if (entry.inTeam) {
                        ++id;
                        continue;
                    }
                    if (!entry.name.equals(playerName)) continue;
                    entry.setBookOpen(team.getPlayers().get(0).bookOpen);
                    entry.inTeam = true;
                    QuestingData.getQuestingData(entry.name).setTeam(inviteTeam);
                    team.setId(inviteTeam.getId());
                    for (i = 0; i < inviteTeam.questData.size(); ++i) {
                        joinData = team.questData.get(i);
                        questData = inviteTeam.questData.get(i);
                        if (questData == null) continue;
                        boolean[] old = questData.reward;
                        questData.reward = new boolean[old.length + 1];
                        for (int j = 0; j < questData.reward.length; ++j) {
                            questData.reward[j] = j == id ? joinData.reward[0] : (j < id ? old[j] : old[j - 1]);
                        }
                    }
                    for (i = 0; i < inviteTeam.questData.size(); ++i) {
                        joinData = team.questData.get(i);
                        questData = inviteTeam.questData.get(i);
                        if (questData == null || Quest.getQuest(i) == null) continue;
                        Quest.getQuest(i).mergeProgress(playerName, questData, joinData);
                    }
                    for (i = 0; i < Reputation.size(); ++i) {
                        Reputation reputation = Reputation.getReputation(i);
                        if (reputation == null) continue;
                        int joinValue = team.getReputation(reputation);
                        int teamValue = inviteTeam.getReputation(reputation);
                        int targetValue = Math.abs(joinValue) > Math.abs(teamValue) ? joinValue : teamValue;
                        team.setReputation(reputation, targetValue);
                    }
                    inviteTeam.refreshData();
                    inviteTeam.refreshTeamData(UpdateType.ALL);
                    Team.declineAll(playerName);
                    TeamStats.refreshTeam(team);
                    break block0;
                }
                break;
            }
            case DECLINE: {
                int declineId;
                if (!team.isSingle() || (declineId = dr.readData(DataBitHelper.TEAMS)) < 0 || declineId >= QuestingData.getTeams().size()) break;
                Team inviteTeam = QuestingData.getTeams().get(declineId);
                inviteTeam.getPlayers().remove(new PlayerEntry(playerName, false, false));
                inviteTeam.refreshTeamData(UpdateType.ONLY_OWNER);
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case KICK: {
                String playerToRemove;
                PlayerEntry entryToRemove;
                if (team.isSingle() || !team.isOwner(playerName) || (entryToRemove = team.getEntry(playerToRemove = dr.readString(DataBitHelper.NAME_LENGTH))).isOwner()) break;
                if (entryToRemove.inTeam) {
                    team.removePlayer(playerToRemove);
                    team.refreshTeamData(UpdateType.ALL);
                    TeamStats.refreshTeam(team);
                } else {
                    team.getPlayers().remove(entryToRemove);
                    team.refreshTeamData(UpdateType.ONLY_OWNER);
                }
                QuestingData.getQuestingData(playerToRemove).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case LEAVE: {
                if (team.isSingle() || team.isOwner(playerName)) break;
                team.removePlayer(playerName);
                team.refreshTeamData(UpdateType.ALL);
                QuestingData.getQuestingData(playerName).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                TeamStats.refreshTeam(team);
                break;
            }
            case DISBAND: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.deleteTeam();
                TeamStats.refreshTeam(team);
                break;
            }
            case NEXT_LIFE_SETTING: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.lifeSetting = LifeSetting.values()[(team.lifeSetting.ordinal() + 1) % LifeSetting.values().length];
                team.refreshTeamData(UpdateType.ALL);
                break;
            }
            case NEXT_REWARD_SETTING: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.rewardSetting = RewardSetting.values()[(team.rewardSetting.ordinal() + 1) % RewardSetting.values().length];
                if (team.rewardSetting == RewardSetting.ALL) {
                    team.rewardSetting = RewardSetting.getDefault();
                }
                team.refreshTeamData(UpdateType.ALL);
            }
        }
    }

    private boolean isOwner(String playerName) {
        PlayerEntry entry = this.getEntry(playerName);
        return entry != null && entry.isOwner();
    }

    public PlayerEntry getEntry(String playerName) {
        for (PlayerEntry playerEntry : this.getPlayers()) {
            if (!playerEntry.getName().equals(playerName)) continue;
            return playerEntry;
        }
        return null;
    }

    private static void declineAll(String playerName) {
        block0: for (Team team : QuestingData.getTeams()) {
            Iterator<PlayerEntry> iterator = team.getPlayers().iterator();
            while (iterator.hasNext()) {
                PlayerEntry playerEntry = iterator.next();
                if (playerEntry.isInTeam() || !playerEntry.getName().equals(playerName)) continue;
                iterator.remove();
                team.refreshTeamData(UpdateType.ONLY_OWNER);
                continue block0;
            }
        }
    }

    public Team(String player) {
        if (player != null) {
            this.players.add(new PlayerEntry(player, true, true));
        }
        this.createQuestData();
        this.createReputation();
    }

    private void createReputation() {
        this.reputation = new ArrayList<Integer>();
        for (int i = 0; i < Reputation.size(); ++i) {
            this.createReputation(i);
        }
    }

    public int getReputation(Reputation reputation) {
        return this.getReputation(reputation.getId());
    }

    public void setReputation(Reputation reputation, int value) {
        this.setReputation(reputation.getId(), (Integer)value);
    }

    private void createReputation(int id) {
        if (Reputation.getReputation(id) == null) {
            this.reputation.add(null);
        } else {
            this.reputation.add(0);
        }
    }

    private void createMissingReputation(int id) {
        while (id >= this.reputation.size() && id < Reputation.size()) {
            this.createReputation(this.reputation.size());
        }
    }

    public int getReputation(int id) {
        this.createMissingReputation(id);
        if (id >= this.reputation.size()) {
            return 0;
        }
        Integer value = this.reputation.get(id);
        return value == null ? 0 : value;
    }

    public void setReputation(int id, Integer value) {
        this.createMissingReputation(id);
        if (id < this.reputation.size()) {
            this.reputation.set(id, value);
        }
    }

    private void createQuestData() {
        this.questData = new ArrayList<QuestData>();
        for (int i = 0; i < Quest.size(); ++i) {
            this.createQuestData(i);
        }
    }

    private void createQuestData(int id) {
        if (id > this.questData.size()) {
            this.createQuestData(id - 1);
        }
        if (Quest.getQuest(id) != null) {
            this.questData.add(id, Quest.getQuest(id).createData(1));
        } else {
            this.questData.add(id, null);
        }
    }

    public QuestData getQuestData(int id) {
        if (id >= this.questData.size()) {
            this.createQuestData(id);
        }
        return this.questData.get(id);
    }

    public void loadData(FileVersion version, DataReader dr, boolean light) {
        block8: {
            int playerCount;
            block7: {
                int i;
                this.readTeamData(version, dr, light);
                playerCount = this.getPlayerCount();
                if (!light) break block7;
                for (i = 0; i < this.questData.size(); ++i) {
                    if (this.questData.get(i) == null) continue;
                    Quest.getQuest(i).preRead(playerCount, this.questData.get(i));
                    Quest.getQuest(i).read(dr, this.questData.get(i), version, true);
                }
                for (i = 0; i < Reputation.size(); ++i) {
                    if (Reputation.getReputation(i) == null) continue;
                    this.setReputation(i, (Integer)dr.readData(DataBitHelper.REPUTATION_VALUE));
                }
                break block8;
            }
            for (int i = 0; i < Quest.size(); ++i) {
                Quest quest = Quest.getQuest(i);
                QuestData data = this.questData.get(i);
                if (quest == null || data == null) continue;
                quest.preRead(playerCount, data);
            }
            int count = dr.readData(DataBitHelper.QUESTS);
            for (int i = 0; i < count; ++i) {
                int id = dr.readData(DataBitHelper.QUESTS);
                Quest quest = Quest.getQuest(id);
                int bits = -1;
                if (version.contains(FileVersion.REMOVED_QUESTS)) {
                    bits = dr.readData(DataBitHelper.INT);
                }
                if (quest != null && this.questData.get(id) != null) {
                    quest.read(dr, this.questData.get(id), version, false);
                    continue;
                }
                if (!version.contains(FileVersion.REMOVED_QUESTS)) continue;
                dr.readData(bits);
            }
            this.createReputation();
            if (!version.contains(FileVersion.REPUTATION)) break block8;
            int reputationCount = dr.readData(DataBitHelper.REPUTATION);
            for (int i = 0; i < reputationCount; ++i) {
                int id = dr.readData(DataBitHelper.REPUTATION);
                int value = dr.readData(DataBitHelper.REPUTATION_VALUE);
                if (Reputation.getReputation(id) == null) continue;
                this.setReputation(id, (Integer)value);
            }
        }
    }

    private void readTeamData(FileVersion version, DataReader dr, boolean light) {
        if (light) {
            int count;
            this.setId(dr.readBoolean() ? -1 : 0);
            reloadedInvites = true;
            this.invites = null;
            if (this.isSingle() && (count = dr.readData(DataBitHelper.TEAMS)) != 0) {
                this.invites = new ArrayList<Team>();
                for (int i = 0; i < count; ++i) {
                    Team team = new Team(null);
                    team.loadTeamData(version, dr, true);
                    this.invites.add(team);
                }
            }
        }
        if (version.contains(FileVersion.TEAMS) && !this.isSingle()) {
            this.loadTeamData(version, dr, light);
        }
        if (light && !this.isSingle() && this.isSharingLives()) {
            this.clientTeamLives = dr.readData(DataBitHelper.TEAM_LIVES);
        }
    }

    private void loadTeamData(FileVersion version, DataReader dr, boolean light) {
        this.name = dr.readString(DataBitHelper.NAME_LENGTH);
        this.id = dr.readData(DataBitHelper.TEAMS);
        if (version.contains(FileVersion.TEAM_SETTINGS)) {
            this.lifeSetting = LifeSetting.values()[dr.readData(DataBitHelper.TEAM_LIVES_SETTING)];
            this.rewardSetting = RewardSetting.values()[dr.readData(DataBitHelper.TEAM_REWARD_SETTING)];
            if (this.rewardSetting == RewardSetting.ALL) {
                this.rewardSetting = RewardSetting.getDefault();
            }
        }
        this.players.clear();
        int count = dr.readData(DataBitHelper.PLAYERS);
        for (int i = 0; i < count; ++i) {
            boolean inTeam;
            String name = dr.readString(DataBitHelper.NAME_LENGTH);
            if (name == null) {
                name = "Unknown";
            }
            boolean owner = (inTeam = dr.readBoolean()) && dr.readBoolean();
            this.players.add(new PlayerEntry(name, inTeam, owner));
        }
    }

    public boolean isSingle() {
        return this.id == -1;
    }

    public void saveData(DataWriter dw, boolean light) {
        this.writeTeamData(dw, light);
        if (light) {
            int i;
            for (i = 0; i < this.questData.size(); ++i) {
                if (this.questData.get(i) == null || Quest.getQuest(i) == null) continue;
                Quest.getQuest(i).save(dw, this.questData.get(i), true);
            }
            for (i = 0; i < Reputation.size(); ++i) {
                if (Reputation.getReputation(i) == null) continue;
                dw.writeData(this.getReputation(i), DataBitHelper.REPUTATION_VALUE);
            }
        } else {
            int i;
            int count = 0;
            for (Quest quest : Quest.getQuests()) {
                if (quest == null) continue;
                ++count;
            }
            dw.writeData(count, DataBitHelper.QUESTS);
            for (int i2 = 0; i2 < this.questData.size(); ++i2) {
                if (this.questData.get(i2) == null || Quest.getQuest(i2) == null) continue;
                dw.writeData(i2, DataBitHelper.QUESTS);
                dw.createBuffer(DataBitHelper.INT);
                Quest.getQuest(i2).save(dw, this.questData.get(i2), false);
                dw.flushBuffer();
            }
            int reputationCount = 0;
            for (i = 0; i < Reputation.size(); ++i) {
                if (Reputation.getReputation(i) == null) continue;
                ++reputationCount;
            }
            dw.writeData(reputationCount, DataBitHelper.REPUTATION);
            for (i = 0; i < Reputation.size(); ++i) {
                if (Reputation.getReputation(i) == null) continue;
                dw.writeData(i, DataBitHelper.REPUTATION);
                dw.writeData(this.getReputation(i), DataBitHelper.REPUTATION_VALUE);
            }
        }
    }

    private void writeTeamData(DataWriter dw, boolean light) {
        if (light) {
            dw.writeBoolean(this.isSingle());
            if (this.isSingle()) {
                String name = this.players.get(0).name;
                ArrayList<Team> invitingTeams = new ArrayList<Team>();
                block0: for (Team team : QuestingData.getTeams()) {
                    for (PlayerEntry player : team.players) {
                        if (player.inTeam || !player.name.equals(name)) continue;
                        invitingTeams.add(team);
                        continue block0;
                    }
                }
                dw.writeData(invitingTeams.size(), DataBitHelper.TEAMS);
                for (Team invitingTeam : invitingTeams) {
                    invitingTeam.saveTeamData(dw, true);
                }
            }
        }
        if (!this.isSingle()) {
            this.saveTeamData(dw, light);
        }
        if (light && !this.isSingle() && this.isSharingLives()) {
            dw.writeData(this.getSharedLives(), DataBitHelper.TEAM_LIVES);
        }
    }

    private void saveTeamData(DataWriter dw, boolean light) {
        dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        dw.writeData(this.lifeSetting.ordinal(), DataBitHelper.TEAM_LIVES_SETTING);
        dw.writeData(this.rewardSetting.ordinal(), DataBitHelper.TEAM_REWARD_SETTING);
        dw.writeData(this.players.size(), DataBitHelper.PLAYERS);
        for (PlayerEntry player : this.players) {
            dw.writeString(player.name, DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(player.inTeam);
            if (!player.inTeam) continue;
            dw.writeBoolean(player.owner);
        }
    }

    public void postRead(QuestingData data, FileVersion version) {
        for (int i = 0; i < this.questData.size(); ++i) {
            if (Quest.getQuest(i) == null || this.questData.get(i) == null) continue;
            Quest.getQuest(i).postRead(data, this.questData.get(i), version);
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public static class PlayerEntry {
        private String name;
        private boolean inTeam;
        private boolean owner;
        private boolean bookOpen;

        public PlayerEntry(String name, boolean inTeam, boolean owner) {
            this.name = name;
            this.inTeam = inTeam;
            this.owner = owner;
            this.bookOpen = false;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInTeam() {
            return this.inTeam;
        }

        public boolean isOwner() {
            return this.owner;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerEntry entry = (PlayerEntry)o;
            return this.name != null ? this.name.equals(entry.name) : entry.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public boolean shouldRefreshData() {
            return this.bookOpen || PacketHandler.getOverriddenBy(this.name) != null;
        }

        public boolean isBookOpen() {
            return this.bookOpen;
        }

        public void setBookOpen(boolean bookOpen) {
            this.bookOpen = bookOpen;
        }
    }

    public static enum ErrorMessage {
        INVALID_PLAYER("hqm.team.invalidPlayer.title", "hqm.team.invalidPlayer.desc"),
        IN_PARTY("hqm.team.playerInParty.title", "hqm.team.playerInParty.desc"),
        USED_NAME("hqm.team.usedTeamName.title", "hqm.team.usedTeamName.desc");

        private String header;
        private String message;

        private ErrorMessage(String header, String message) {
            this.message = message;
            this.header = header;
        }

        public String getMessage() {
            return Translator.translate(this.message);
        }

        public String getHeader() {
            return Translator.translate(this.header);
        }

        public void sendToClient(EntityPlayer player) {
            DataWriter dw = PacketHandler.getWriter(PacketId.TEAM);
            dw.writeData(this.ordinal(), DataBitHelper.TEAM_ERROR);
            PacketHandler.sendToPlayer(QuestingData.getUserName(player), dw);
        }
    }

    private static enum TeamAction {
        CREATE,
        INVITE,
        ACCEPT,
        DECLINE,
        KICK,
        LEAVE,
        DISBAND,
        NEXT_LIFE_SETTING,
        NEXT_REWARD_SETTING;

    }

    public static enum RefreshType {
        FULL,
        LIVES,
        REPUTATION_RECEIVED;

    }

    public static enum UpdateType {
        ALL,
        ONLY_MEMBERS,
        ONLY_INVITES,
        ONLY_OWNER;

    }

    public static enum RewardSetting {
        ALL("hqm.team.allReward.title", "hqm.team.allReward.desc"),
        ANY("hqm.team.anyReward.title", "hqm.team.anyReward.desc"),
        RANDOM("hqm.team.randomReward.title", "hqm.team.randomReward.desc");

        private String title;
        private String description;
        public static boolean isAllModeEnabled;

        private static RewardSetting getDefault() {
            return isAllModeEnabled ? ALL : ANY;
        }

        private RewardSetting(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return Translator.translate(this.title);
        }

        public String getDescription() {
            return Translator.translate(this.description);
        }
    }

    public static enum LifeSetting {
        SHARE("hqm.team.sharedLives.title", "hqm.team.sharedLives.desc"),
        INDIVIDUAL("hqm.team.individualLives.title", "hqm.team.individualLives.desc");

        private String title;
        private String description;

        private LifeSetting(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return Translator.translate(this.title);
        }

        public String getDescription() {
            return Translator.translate(this.description);
        }
    }
}

