/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.ServerTickHandler;
import mcp.mobius.betterbarrels.Utils;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.LocalizedChat;
import mcp.mobius.betterbarrels.common.blocks.BarrelCoreUpgrades;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.StorageLocal;
import mcp.mobius.betterbarrels.common.blocks.logic.LogicHopper;
import mcp.mobius.betterbarrels.common.items.ItemBarrelHammer;
import mcp.mobius.betterbarrels.common.items.ItemTuningFork;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeSide;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeStructural;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeSide;
import mcp.mobius.betterbarrels.network.BarrelPacketHandler;
import mcp.mobius.betterbarrels.network.Message0x00FulleTileEntityNBT;
import mcp.mobius.betterbarrels.network.Message0x01ContentUpdate;
import mcp.mobius.betterbarrels.network.Message0x02GhostUpdate;
import mcp.mobius.betterbarrels.network.Message0x03SideupgradeUpdate;
import mcp.mobius.betterbarrels.network.Message0x04Structuralupdate;
import mcp.mobius.betterbarrels.network.Message0x05CoreUpdate;
import mcp.mobius.betterbarrels.network.Message0x06FullStorage;
import mcp.mobius.betterbarrels.network.Message0x08LinkUpdate;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBarrel
extends TileEntity
implements ISidedInventory,
IDeepStorageUnit {
    private static int version = 5;
    private long clickTime = -20L;
    IBarrelStorage storage = new StorageLocal();
    public ForgeDirection orientation = ForgeDirection.UNKNOWN;
    public ForgeDirection rotation = ForgeDirection.UNKNOWN;
    public int[] sideUpgrades = new int[]{0, 0, 0, 0, 0, 0};
    public int[] sideMetadata = new int[]{0, 0, 0, 0, 0, 0};
    public boolean isTicking = false;
    public boolean isLinked = false;
    public byte nTicks = 0;
    public int id = -1;
    public long timeSinceLastUpd = System.currentTimeMillis();
    public boolean overlaying = false;
    private Message0x01ContentUpdate lastContentMessage;
    private Message0x02GhostUpdate lastGhostMessage;
    public BarrelCoreUpgrades coreUpgrades = new BarrelCoreUpgrades(this);
    static final int[] sideSwitch = new int[]{1, 0, 3, 2, 5, 4};
    protected AxisAlignedBB aabbBlockBelow = null;

    public void setLinked(boolean linked) {
        this.isLinked = linked;
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x08LinkUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
    }

    public boolean getLinked() {
        return this.isLinked;
    }

    public IBarrelStorage getStorage() {
        IBarrelStorage ret = this.coreUpgrades.hasEnder && !this.field_145850_b.field_72995_K ? BSpaceStorageHandler.instance().getStorage(this.id) : this.storage;
        if (ret == null) {
            BetterBarrels.log.error(String.format("This is the most unusual case. Storage appears to be null for [%d %d %d %d] with id [%d]", this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.id));
            if (this.storage == null) {
                this.storage = new StorageLocal();
                BetterBarrels.log.error("Local storage was null. Created a new one.");
            }
            if (this.coreUpgrades.hasEnder && !this.field_145850_b.field_72995_K) {
                this.id = BSpaceStorageHandler.instance().getNextBarrelID();
                BetterBarrels.log.error(String.format("Barrel is BSpaced. Generating new ID for it and registering the storage with the main handler.", new Object[0]));
                BSpaceStorageHandler.instance().registerEnderBarrel(this.id, this.storage);
            }
            ret = this.coreUpgrades.hasEnder && !this.field_145850_b.field_72995_K ? BSpaceStorageHandler.instance().getStorage(this.id) : this.storage;
        }
        if (ret == null) {
            throw new RuntimeException(String.format("Attempts to salvage [%d %d %d %d] with id [%d] have failed ! Please contact your closest modder to bitch at him.", this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.id));
        }
        return ret;
    }

    public void setStorage(IBarrelStorage storage) {
        this.storage = storage;
    }

    public void setVoid(boolean delete) {
        this.coreUpgrades.hasVoid = delete;
        this.storage.setVoid(delete);
    }

    public void setCreative(boolean infinite) {
        this.coreUpgrades.hasCreative = infinite;
        this.storage.setCreative(infinite);
    }

    public boolean canUpdate() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.isTicking;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.nTicks = (byte)(this.nTicks + 1);
        if (this.nTicks % 8 == 0) {
            if (LogicHopper.INSTANCE.run(this)) {
                this.func_70296_d();
            }
            this.nTicks = 0;
        }
    }

    void startTicking() {
        this.isTicking = true;
        if (!this.field_145850_b.field_147482_g.contains(this)) {
            this.field_145850_b.addTileEntity((TileEntity)this);
        }
    }

    void stopTicking() {
        this.isTicking = false;
        if (this.field_145850_b.field_147482_g.contains(this)) {
            this.field_145850_b.field_147482_g.remove(this);
        }
    }

    public int getRedstonePower(int side) {
        if (!this.coreUpgrades.hasRedstone) {
            return 0;
        }
        side = sideSwitch[side];
        IBarrelStorage store = this.getStorage();
        int currentAmount = store.getAmount();
        int maxStorable = store.getMaxStoredCount();
        if (this.coreUpgrades.hasVoid && store.hasItem()) {
            maxStorable -= store.getItem().func_77976_d();
        }
        if (this.sideUpgrades[side] == 4 && this.sideMetadata[side] == 0 && currentAmount == maxStorable) {
            return 15;
        }
        if (this.sideUpgrades[side] == 4 && this.sideMetadata[side] == 1 && currentAmount == 0) {
            return 15;
        }
        if (this.sideUpgrades[side] == 4 && this.sideMetadata[side] == 2) {
            if (currentAmount == 0) {
                return 0;
            }
            if (currentAmount == maxStorable) {
                return 15;
            }
            return MathHelper.func_76141_d((float)((float)currentAmount / (float)maxStorable * 14.0f)) + 1;
        }
        return 0;
    }

    public void leftClick(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack droppedStack = null;
        droppedStack = BetterBarrels.reverseBehaviourClickLeft && !player.func_70093_af() || !BetterBarrels.reverseBehaviourClickLeft && player.func_70093_af() ? this.getStorage().getStack(1) : this.getStorage().getStack();
        if (droppedStack != null && droppedStack.field_77994_a > 0) {
            Utils.dropItemInWorld(this, player, droppedStack, 0.02);
        }
        this.func_70296_d();
    }

    public void rightClick(EntityPlayer player, int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = player.func_70694_bm();
        if (!player.func_70093_af()) {
            if (stack != null && stack.func_77973_b() instanceof ItemBarrelHammer) {
                this.configSide(stack, player, ForgeDirection.getOrientation((int)side));
            } else {
                this.manualStackAdd(player);
            }
        } else if (stack == null) {
            this.switchLocked();
        } else if (stack.func_77973_b() instanceof ItemUpgradeSide) {
            this.applySideUpgrade(stack, player, ForgeDirection.getOrientation((int)side));
        } else if (stack.func_77973_b() instanceof ItemUpgradeCore) {
            this.coreUpgrades.applyUpgrade(stack, player);
        } else if (stack.func_77973_b() instanceof ItemUpgradeStructural) {
            this.coreUpgrades.applyStructural(stack, player);
        } else if (stack.func_77973_b() instanceof ItemBarrelHammer) {
            this.removeUpgrade(stack, player, ForgeDirection.getOrientation((int)side));
        } else if (stack.func_77973_b() instanceof ItemTuningFork) {
            if (stack.func_77960_j() == 0) {
                this.tuneFork(stack, player, ForgeDirection.getOrientation((int)side));
            } else {
                this.tuneBarrel(stack, player, ForgeDirection.getOrientation((int)side));
            }
        } else {
            this.manualStackAdd(player);
        }
    }

    private void tuneFork(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        if (!this.coreUpgrades.hasEnder) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_NOREACT, new Object[0]);
            return;
        }
        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_FORK_RESONATING, new Object[0]);
        stack.func_77964_b(1);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("tuneID", this.id);
        stack.func_77978_p().func_74768_a("structural", this.coreUpgrades.levelStructural);
        stack.func_77978_p().func_74768_a("storage", this.coreUpgrades.nStorageUpg);
        stack.func_77978_p().func_74757_a("void", this.coreUpgrades.hasVoid);
        stack.func_77978_p().func_74757_a("creative", this.coreUpgrades.hasCreative);
    }

    private void tuneBarrel(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        if (!this.coreUpgrades.hasEnder) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_NOREACT, new Object[0]);
            return;
        }
        if (this.getStorage().hasItem()) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_CONTENT, new Object[0]);
            return;
        }
        int structural = stack.func_77978_p().func_74762_e("structural");
        int storage = stack.func_77978_p().func_74762_e("storage");
        int barrelID = stack.func_77978_p().func_74762_e("tuneID");
        boolean hasVoid = stack.func_77978_p().func_74767_n("void");
        boolean hasCreative = stack.func_77978_p().func_74767_n("creative");
        if (this.coreUpgrades.levelStructural != structural || this.coreUpgrades.nStorageUpg != storage || this.coreUpgrades.hasVoid != hasVoid || this.coreUpgrades.hasCreative != hasCreative) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSAPCE_STRUCTURE, new Object[0]);
            return;
        }
        if (this.id == barrelID) {
            stack.func_77964_b(1);
            return;
        }
        if (BSpaceStorageHandler.instance().getBarrel(barrelID) == null || !BSpaceStorageHandler.instance().getBarrel((int)barrelID).coreUpgrades.hasEnder) {
            BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_FORK_LOST, new Object[0]);
            stack.func_77964_b(0);
            stack.func_77982_d(new NBTTagCompound());
            return;
        }
        BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.BSPACE_RESONATING, new Object[0]);
        stack.func_77964_b(0);
        stack.func_77982_d(new NBTTagCompound());
        BSpaceStorageHandler.instance().linkStorages(barrelID, this.id);
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x02GhostUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x06FullStorage(this), this.field_145850_b.field_73011_w.field_76574_g);
    }

    private void configSide(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        int type = this.sideUpgrades[side.ordinal()];
        boolean sendChange = false;
        if (type == 4) {
            this.sideMetadata[side.ordinal()] = this.sideMetadata[side.ordinal()] + 1;
            if (this.sideMetadata[side.ordinal()] > 2) {
                this.sideMetadata[side.ordinal()] = 0;
            }
            sendChange = true;
        }
        if (type == 3) {
            this.sideMetadata[side.ordinal()] = (this.sideMetadata[side.ordinal()] & 1) == 0 ? this.sideMetadata[side.ordinal()] & 0x3E | 1 : this.sideMetadata[side.ordinal()] & 0x3E | 0;
            sendChange = true;
        }
        if (sendChange) {
            this.func_70296_d();
            BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x03SideupgradeUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    void removeUpgradeFacades(EntityPlayer player) {
        for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
            int sideType = this.sideUpgrades[s.ordinal()];
            if (UpgradeSide.mapReq[sideType] == -1 || this.coreUpgrades.hasUpgrade(UpgradeCore.values()[UpgradeSide.mapReq[sideType]])) continue;
            this.dropSideUpgrade(player, s);
        }
    }

    private void removeUpgrade(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        int type = this.sideUpgrades[side.ordinal()];
        if (type != 0 && type != 1) {
            this.dropSideUpgrade(player, side);
        } else {
            this.coreUpgrades.removeUpgrade(stack, player, side);
        }
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x03SideupgradeUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x04Structuralupdate(this), this.field_145850_b.field_73011_w.field_76574_g);
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x05CoreUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x06FullStorage(this), this.field_145850_b.field_73011_w.field_76574_g);
    }

    private void dropSideUpgrade(EntityPlayer player, ForgeDirection side) {
        int type = this.sideUpgrades[side.ordinal()];
        ItemStack droppedStack = new ItemStack(UpgradeSide.mapItem[type], 1, UpgradeSide.mapMeta[type]);
        Utils.dropItemInWorld(this, player, droppedStack, 0.02);
        this.sideUpgrades[side.ordinal()] = 0;
        this.sideMetadata[side.ordinal()] = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applySideUpgrade(ItemStack stack, EntityPlayer player, ForgeDirection side) {
        int type = UpgradeSide.mapRevMeta[stack.func_77960_j()];
        if (this.sideUpgrades[side.ordinal()] != 0) {
            return;
        }
        if (type == 2) {
            this.sideUpgrades[side.ordinal()] = 2;
            this.sideMetadata[side.ordinal()] = 0;
        } else if (type == 4) {
            if (!this.coreUpgrades.hasRedstone) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.FACADE_REDSTONE, new Object[0]);
                return;
            }
            this.sideUpgrades[side.ordinal()] = 4;
            this.sideMetadata[side.ordinal()] = 0;
        } else if (type == 3) {
            if (!this.coreUpgrades.hasHopper) {
                BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.FACADE_HOPPER, new Object[0]);
                return;
            }
            this.sideUpgrades[side.ordinal()] = 3;
            this.sideMetadata[side.ordinal()] = 2;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        this.func_70296_d();
        BarrelPacketHandler.INSTANCE.sendToDimension(new Message0x03SideupgradeUpdate(this), this.field_145850_b.field_73011_w.field_76574_g);
    }

    private void switchLocked() {
        this.getStorage().switchGhosting();
        this.func_70296_d();
    }

    public void setLocked(boolean locked) {
        this.getStorage().setGhosting(locked);
        this.func_70296_d();
    }

    private void manualStackAdd(EntityPlayer player) {
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        this.getStorage().addStack(heldStack);
        if (this.field_145850_b.func_82737_E() - this.clickTime < 10L) {
            InventoryPlayer playerInv = player.field_71071_by;
            for (int invSlot = 0; invSlot < playerInv.func_70302_i_(); ++invSlot) {
                ItemStack slotStack = playerInv.func_70301_a(invSlot);
                if (this.getStorage().addStack(slotStack) <= 0 || slotStack.field_77994_a != 0) continue;
                playerInv.func_70299_a(invSlot, (ItemStack)null);
            }
        }
        BetterBarrels.proxy.updatePlayerInventory(player);
        this.clickTime = this.field_145850_b.func_82737_E();
        this.func_70296_d();
    }

    public void func_145841_b(NBTTagCompound NBTTag) {
        if (this.id == -1) {
            this.id = BSpaceStorageHandler.instance().getNextBarrelID();
        }
        BSpaceStorageHandler.instance().updateBarrel(this.id, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        super.func_145841_b(NBTTag);
        NBTTag.func_74768_a("version", version);
        NBTTag.func_74768_a("orientation", this.orientation.ordinal());
        NBTTag.func_74768_a("rotation", this.rotation.ordinal());
        NBTTag.func_74783_a("sideUpgrades", this.sideUpgrades);
        this.coreUpgrades.writeToNBT(NBTTag);
        NBTTag.func_74783_a("sideMeta", this.sideMetadata);
        NBTTag.func_74757_a("ticking", this.isTicking);
        NBTTag.func_74757_a("linked", this.isLinked);
        NBTTag.func_74774_a("nticks", this.nTicks);
        NBTTag.func_74782_a("storage", (NBTBase)this.getStorage().writeTagCompound());
        NBTTag.func_74768_a("bspaceid", this.id);
    }

    public void func_145839_a(NBTTagCompound NBTTag) {
        super.func_145839_a(NBTTag);
        int saveVersion = NBTTag.func_74762_e("version");
        if (saveVersion == 2) {
            this.readFromNBT_v2(NBTTag);
            return;
        }
        this.orientation = ForgeDirection.getOrientation((int)NBTTag.func_74762_e("orientation"));
        this.rotation = NBTTag.func_74764_b("rotation") ? ForgeDirection.getOrientation((int)NBTTag.func_74762_e("rotation")) : this.orientation;
        this.sideUpgrades = NBTTag.func_74759_k("sideUpgrades");
        this.sideMetadata = NBTTag.func_74759_k("sideMeta");
        this.coreUpgrades = new BarrelCoreUpgrades(this);
        this.coreUpgrades.readFromNBT(NBTTag, saveVersion);
        this.isTicking = NBTTag.func_74767_n("ticking");
        this.isLinked = NBTTag.func_74764_b("linked") ? NBTTag.func_74767_n("linked") : false;
        this.nTicks = NBTTag.func_74771_c("nticks");
        this.id = NBTTag.func_74762_e("bspaceid");
        if (this.coreUpgrades.hasEnder && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.storage = BSpaceStorageHandler.instance().getStorage(this.id);
        } else {
            this.getStorage().readTagCompound(NBTTag.func_74775_l("storage"));
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.isTicking) {
                this.startTicking();
            }
        }
        block3: for (int side = 0; side < this.sideUpgrades.length; ++side) {
            switch (this.sideUpgrades[side]) {
                case 3: {
                    int amount = this.sideMetadata[side] >> 1;
                    if (amount == 1 || amount == 2 || amount == 4 || amount == 8 || amount == 16) continue block3;
                    this.sideMetadata[side] = 2 | this.sideMetadata[side] & 1;
                }
            }
        }
    }

    private void readFromNBT_v2(NBTTagCompound NBTTag) {
        int blockOrientation = NBTTag.func_74762_e("barrelOrient");
        int upgradeCapacity = NBTTag.func_74762_e("upgradeCapacity");
        int blockOriginalOrient = NBTTag.func_74764_b("barrelOrigOrient") ? NBTTag.func_74762_e("barrelOrigOrient") : blockOrientation;
        StorageLocal storage = new StorageLocal();
        storage.readTagCompound(NBTTag.func_74775_l("storage"));
        this.rotation = this.orientation = this.convertOrientationFlagToForge(blockOriginalOrient).get(0);
        ArrayList<ForgeDirection> stickers = this.convertOrientationFlagToForge(blockOrientation);
        for (ForgeDirection s : stickers) {
            this.sideUpgrades[s.ordinal()] = 2;
        }
        this.sideUpgrades[this.orientation.ordinal()] = 1;
        this.coreUpgrades.levelStructural = upgradeCapacity;
        int freeSlots = this.coreUpgrades.getFreeSlots();
        for (int i = 0; i < freeSlots; ++i) {
            this.coreUpgrades.upgradeList.add(UpgradeCore.STORAGE);
            this.getStorage().addStorageUpgrade();
            ++this.coreUpgrades.nStorageUpg;
        }
        this.getStorage().setStoredItemType(storage.getItem(), storage.getAmount());
        this.getStorage().setGhosting(storage.isGhosting());
        this.id = BSpaceStorageHandler.instance().getNextBarrelID();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private ArrayList<ForgeDirection> convertOrientationFlagToForge(int flags) {
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 4; ++i) {
            if ((1 << i & flags) == 0) continue;
            directions.add(ForgeDirection.getOrientation((int)(i + 2)));
        }
        return directions;
    }

    public Packet func_145844_m() {
        return BarrelPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)new Message0x00FulleTileEntityNBT(this));
    }

    public void func_70296_d() {
        super.func_70296_d();
        ServerTickHandler.INSTANCE.markDirty(this);
    }

    public void markDirtyExec() {
        super.func_70296_d();
        if (this.coreUpgrades.hasRedstone || this.coreUpgrades.hasHopper) {
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendContentSyncPacket(false);
            this.sendGhostSyncPacket(false);
        }
    }

    public boolean sendContentSyncPacket(boolean force) {
        IBarrelStorage tempStore = this.getStorage();
        if (force || this.lastContentMessage == null || this.lastContentMessage.amount != tempStore.getAmount() || !tempStore.sameItem(this.lastContentMessage.stack)) {
            this.lastContentMessage = new Message0x01ContentUpdate(this);
            BarrelPacketHandler.INSTANCE.sendToAllAround(this.lastContentMessage, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 500.0));
            return true;
        }
        return false;
    }

    public boolean sendGhostSyncPacket(boolean force) {
        if (force || this.lastGhostMessage == null || this.lastGhostMessage.locked != this.getStorage().isGhosting()) {
            this.lastGhostMessage = new Message0x02GhostUpdate(this);
            BarrelPacketHandler.INSTANCE.sendToAllAround(this.lastGhostMessage, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 500.0));
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.getStorage().func_70302_i_();
    }

    public ItemStack func_70301_a(int islot) {
        ItemStack stack = this.getStorage().func_70301_a(islot);
        ServerTickHandler.INSTANCE.markDirty(this);
        return stack;
    }

    public ItemStack func_70298_a(int islot, int quantity) {
        ItemStack stack;
        TileEntity ent = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (ent instanceof TileEntityHopper) {
            stack = this.getStorage().decrStackSize_Hopper(islot, quantity);
        } else if (ent == null) {
            List list;
            if (this.aabbBlockBelow == null) {
                this.aabbBlockBelow = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)this.field_145848_d, (double)(this.field_145849_e + 1));
            }
            stack = (list = this.field_145850_b.func_82733_a(EntityMinecartHopper.class, this.aabbBlockBelow, IEntitySelector.field_94557_a)).size() > 0 ? this.getStorage().decrStackSize_Hopper(islot, quantity) : this.getStorage().func_70298_a(islot, quantity);
        } else {
            stack = this.getStorage().func_70298_a(islot, quantity);
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int islot, ItemStack stack) {
        this.getStorage().func_70299_a(islot, stack);
        this.func_70296_d();
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public String func_145825_b() {
        return "mcp.mobius.betterbarrel";
    }

    public int func_70297_j_() {
        return this.getStorage().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.getStorage().func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int side) {
        if (this.sideUpgrades[side] == 3) {
            return new int[]{1};
        }
        return this.getStorage().func_94128_d(side);
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.sideUpgrades[side] == 3) {
            return false;
        }
        return this.getStorage().func_102007_a(slot, itemstack, side);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return this.getStorage().func_102008_b(slot, itemstack, side);
    }

    @Override
    public ItemStack getStoredItemType() {
        return this.getStorage().getStoredItemType();
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.getStorage().setStoredItemCount(amount);
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        this.getStorage().setStoredItemType(type, amount);
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return this.getStorage().getMaxStoredCount();
    }
}

