/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.minetweaker;

import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import fox.spiteful.avaritia.crafting.ExtremeShapedOreRecipe;
import fox.spiteful.avaritia.crafting.Grinder;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.avaritia.ExtremeCrafting")
public class ExtremeCrafting {
    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IRecipe)new ShapelessOreRecipe(ExtremeCrafting.toStack(output), ExtremeCrafting.toObjects(ingredients))));
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] row : ingredients) {
            if (width >= row.length) continue;
            width = row.length;
        }
        Object[] input = new Object[width * height];
        int x = 0;
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] row;
            for (IIngredient ingredient : row = iIngredientArray[i]) {
                input[x++] = ExtremeCrafting.toActualObject(ingredient);
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new ExtremeShapedOreRecipe(ExtremeCrafting.toStack(output), input, width, height)));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(ExtremeCrafting.toStack(target)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return ExtremeCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return ExtremeCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = ExtremeCrafting.toObject(list[x]);
        }
        return ingredients;
    }

    private static Object toActualObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return OreDictionary.getOres((String)ExtremeCrafting.toString((IOreDictEntry)ingredient));
        }
        if (ingredient instanceof IItemStack) {
            return ExtremeCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class RemoveCatalyst
    implements IUndoableAction {
        IIngredient ingredient;

        public RemoveCatalyst(IIngredient rem) {
            this.ingredient = rem;
        }

        public void apply() {
            Grinder.catalyst.getInput().add(this.ingredient);
            for (Object e : Grinder.catalyst.getInput()) {
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Grinder.catalyst.getInput().remove(this.ingredient);
        }

        public String describe() {
            return "Adding something to Infinity Catalyst recipe.";
        }

        public String describeUndo() {
            return "Removing something from Infinity Catalyst recipe.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddCatalyst
    implements IUndoableAction {
        Object ingredient;

        public AddCatalyst(Object add) {
            this.ingredient = add;
        }

        public void apply() {
            Grinder.catalyst.getInput().add(this.ingredient);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Grinder.catalyst.getInput().remove(this.ingredient);
        }

        public String describe() {
            if (this.ingredient instanceof ItemStack) {
                return "Adding " + ((ItemStack)this.ingredient).func_82833_r() + " to Infinity Catalyst recipe.";
            }
            if (this.ingredient instanceof List) {
                return "Adding " + ((ItemStack)((List)this.ingredient).get(0)).func_82833_r() + " to Infinity Catalyst recipe.";
            }
            return "Adding something to Infinity Catalyst recipe.";
        }

        public String describeUndo() {
            if (this.ingredient instanceof ItemStack) {
                return "Removing " + ((ItemStack)this.ingredient).func_82833_r() + " from Infinity Catalyst recipe.";
            }
            if (this.ingredient instanceof List) {
                return "Removing " + ((ItemStack)((List)this.ingredient).get(0)).func_82833_r() + " from Infinity Catalyst recipe.";
            }
            return "Removing something from Infinity Catalyst recipe.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        IRecipe recipe = null;
        ItemStack remove;

        public Remove(ItemStack rem) {
            this.remove = rem;
        }

        public void apply() {
            for (Object obj : ExtremeCraftingManager.getInstance().getRecipeList()) {
                IRecipe craft;
                if (!(obj instanceof IRecipe) || !(craft = (IRecipe)obj).func_77571_b().func_77969_a(this.remove)) continue;
                this.recipe = craft;
                ExtremeCraftingManager.getInstance().getRecipeList().remove(obj);
                break;
            }
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            ExtremeCraftingManager.getInstance().getRecipeList().add(this.recipe);
        }

        public String describe() {
            return "Removing Xtreme Crafting Recipe for " + this.remove.func_82833_r();
        }

        public String describeUndo() {
            return "Un-removing Xtreme Crafting Recipe for " + this.remove.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        IRecipe recipe;

        public Add(IRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            ExtremeCraftingManager.getInstance().getRecipeList().add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ExtremeCraftingManager.getInstance().getRecipeList().remove(this.recipe);
        }

        public String describe() {
            return "Adding Xtreme Crafting Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public String describeUndo() {
            return "Un-adding Xtreme Crafting Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

