/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuLiquid;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class LiquidSetting
extends Setting {
    private Fluid fluid;
    private int amount;
    private static final String NBT_FLUID_ID = "FluidId";
    private static final String NBT_FLUID_AMOUNT = "Amount";

    public LiquidSetting(int id) {
        super(id);
    }

    @Override
    public void clear() {
        super.clear();
        this.fluid = null;
        this.setDefaultAmount();
    }

    @Override
    public List<String> getMouseOver() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.fluid == null) {
            ret.add(Localization.NO_LIQUID_SELECTED.toString());
        } else {
            ret.add(ComponentMenuLiquid.getDisplayName(this.fluid));
        }
        ret.add("");
        ret.add(Localization.CHANGE_LIQUID.toString());
        if (this.fluid != null) {
            ret.add(Localization.EDIT_SETTING.toString());
        }
        return ret;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int val) {
        this.amount = val;
    }

    @Override
    public boolean isValid() {
        return this.fluid != null;
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.fluid.getID(), DataBitHelper.MENU_FLUID_ID);
    }

    @Override
    public void readData(DataReader dr) {
        this.fluid = FluidRegistry.getFluid((int)dr.readData(DataBitHelper.MENU_FLUID_ID));
    }

    @Override
    public void copyFrom(Setting setting) {
        this.fluid = ((LiquidSetting)setting).fluid;
    }

    @Override
    public int getDefaultAmount() {
        return 1000;
    }

    @Override
    public void load(NBTTagCompound settingTag) {
        this.fluid = FluidRegistry.getFluid((int)settingTag.func_74765_d(NBT_FLUID_ID));
        this.amount = settingTag.func_74762_e(NBT_FLUID_AMOUNT);
    }

    @Override
    public void save(NBTTagCompound settingTag) {
        settingTag.func_74777_a(NBT_FLUID_ID, (short)this.fluid.getID());
        settingTag.func_74768_a(NBT_FLUID_AMOUNT, this.amount);
    }

    @Override
    public boolean isContentEqual(Setting otherSetting) {
        return this.fluid.getID() == ((LiquidSetting)otherSetting).fluid.getID();
    }

    @Override
    public void setContent(Object obj) {
        this.fluid = (Fluid)obj;
        this.setDefaultAmount();
    }

    public int getLiquidId() {
        return this.fluid.getID();
    }

    public void setLiquidFromId(int id) {
        this.fluid = FluidRegistry.getFluid((int)id);
    }

    public Fluid getFluid() {
        return this.fluid;
    }
}

