/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;

public class SymbolBiomeControllerTiled
extends SymbolBase {
    public SymbolBiomeControllerTiled(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        BiomeGenBase biome = ModifierUtils.popBiome(controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome(controller);
        }
        Random rand = new Random(controller.getSeed());
        while (biomes.size() < 2) {
            biomes.add(SymbolBiome.getRandomBiome(rand));
        }
        controller.registerInterface(new BiomeController(biomes));
    }

    private class BiomeController
    implements IBiomeController {
        private List<BiomeGenBase> biomes;

        public BiomeController(List<BiomeGenBase> biomes) {
            this.biomes = biomes;
        }

        @Override
        public List<BiomeGenBase> getValidSpawnBiomes() {
            return this.biomes;
        }

        @Override
        public float[] getRainfallField(float[] af, int x, int z, int k, int l) {
            if (af == null || af.length < k * l) {
                af = new float[k * l];
            }
            for (int i1 = 0; i1 < k * l; ++i1) {
                float f = this.getBiomeAtCoords((int)(x + i1 % k), (int)(z + i1 / k)).field_76751_G;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                af[i1] = f;
            }
            return af;
        }

        @Override
        public BiomeGenBase getBiomeAtCoords(int i, int j) {
            int index = (i >> 4) + (j >> 4);
            if ((index %= this.biomes.size()) < 0) {
                index += this.biomes.size();
            }
            return this.biomes.get(index % this.biomes.size());
        }

        @Override
        public BiomeGenBase[] getBiomesForGeneration(BiomeGenBase[] abiomegenbase, int x, int z, int xSize, int zSize) {
            if (abiomegenbase == null || abiomegenbase.length < xSize * zSize) {
                abiomegenbase = new BiomeGenBase[xSize * zSize];
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                abiomegenbase[i] = this.getBiomeAtCoords(x + i % xSize, z + i / xSize);
            }
            return abiomegenbase;
        }

        @Override
        public BiomeGenBase[] getBiomesAtCoords(BiomeGenBase[] abiomegenbase, int x, int z, int xSize, int zSize, boolean flag) {
            if (abiomegenbase == null || abiomegenbase.length < xSize * zSize) {
                abiomegenbase = new BiomeGenBase[xSize * zSize];
            }
            if (flag && xSize == 16 && zSize == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                return this.createBiomeArray(abiomegenbase, x, z, xSize, zSize);
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                abiomegenbase[i] = this.getBiomeAtCoords(x + i % xSize, z + i / xSize);
            }
            return abiomegenbase;
        }

        private BiomeGenBase[] createBiomeArray(BiomeGenBase[] abiomegenbase, int i, int j, int k, int l) {
            if (abiomegenbase == null || abiomegenbase.length < k * l) {
                abiomegenbase = new BiomeGenBase[k * l];
            }
            for (int i1 = 0; i1 < k * l; ++i1) {
                abiomegenbase[i1] = this.getBiomeAtCoords(i + i1 % k, j + i1 / k);
            }
            return abiomegenbase;
        }

        @Override
        public void cleanupCache() {
        }
    }
}

