/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import ic2.api.item.IC2Items;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.crossmod.ic2.IC2Cross;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardEnergySensorLocation;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCard55Reactor
extends ItemCardEnergySensorLocation
implements IRemoteSensor {
    public static final int DISPLAY_ON = 1;
    public static final int DISPLAY_OUTPUTTank = 2;
    public static final int DISPLAY_INPUTTank = 4;
    public static final int DISPLAY_HeatUnits = 8;
    public static final int DISPLAY_CoreTemp = 16;
    public static final UUID CARD_TYPE1 = new UUID(0L, 2L);

    public ItemCard55Reactor() {
        this.func_111206_d("nuclearcontrol:cardReactor");
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE1;
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity check = panel.func_145831_w().func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (this.isReactorPart(check) || panel.func_145831_w().func_147439_a(target.field_71574_a, target.field_71572_b, target.field_71573_c) == Block.func_149634_a((Item)IC2Items.getItem((String)"reactorvessel").func_77973_b())) {
            IReactor reactor = ItemCard55Reactor.getReactor(panel.func_145831_w(), target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (reactor != null) {
                IC2Cross.ReactorInfo info = IC2NuclearControl.instance.crossIc2.getReactorInfo((TileEntity)reactor);
                if (info == null) {
                    return CardState.INVALID_CARD;
                }
                card.setBoolean("Online", info.isOnline);
                card.setInt("outputTank", info.outTank);
                card.setInt("inputTank", info.inTank);
                card.setInt("HeatUnits", info.emitHeat);
                card.setInt("CoreTempurature", info.coreTemp);
                return CardState.OK;
            }
            return CardState.INVALID_CARD;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity check = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (this.isReactorPart(check) || world.func_147439_a(target.field_71574_a, target.field_71572_b, target.field_71573_c) == Block.func_149634_a((Item)IC2Items.getItem((String)"reactorvessel").func_77973_b())) {
            IReactor reactor = ItemCard55Reactor.getReactor(world, target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (reactor != null) {
                IC2Cross.ReactorInfo info = IC2NuclearControl.instance.crossIc2.getReactorInfo((TileEntity)reactor);
                if (info == null) {
                    return CardState.INVALID_CARD;
                }
                card.setBoolean("Online", info.isOnline);
                card.setInt("outputTank", info.outTank);
                card.setInt("inputTank", info.inTank);
                card.setInt("HeatUnits", info.emitHeat);
                card.setInt("CoreTempurature", info.coreTemp);
                return CardState.OK;
            }
            return CardState.INVALID_CARD;
        }
        return CardState.NO_TARGET;
    }

    public static IReactor getReactor(World world, int xCoord, int yCoord, int zCoord) {
        for (int xoffset = -1; xoffset < 2; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -1; zoffset < 2; ++zoffset) {
                    TileEntity te = world.func_147438_o(xCoord + xoffset, yCoord + yoffset, zCoord + zoffset);
                    if (te instanceof IReactor) {
                        return (IReactor)te;
                    }
                    if (!(te instanceof IReactorChamber)) continue;
                    return ((IReactorChamber)te).getReactor();
                }
            }
        }
        return null;
    }

    private boolean isReactorPart(TileEntity par1) {
        return IC2NuclearControl.instance.crossIc2.isMultiReactorPart(par1);
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        double tOut = card.getInt("outputTank").intValue();
        double tIn = card.getInt("inputTank").intValue();
        double heatUnits = card.getInt("HeatUnits").intValue();
        double coreTemp = card.getInt("CoreTempurature").intValue();
        if ((displaySettings & 8) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanel55.Output", heatUnits, showLabels);
            result.add(line);
        }
        if ((displaySettings & 0x10) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanel55.Temp", coreTemp, showLabels);
            result.add(line);
        }
        if ((displaySettings & 4) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanel55.tarkin", tIn, showLabels);
            result.add(line);
        }
        if ((displaySettings & 2) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanel55.tankout", tOut, showLabels);
            result.add(line);
        }
        int txtColor = 0;
        if ((displaySettings & 1) > 0) {
            String text;
            boolean reactorPowered = card.getBoolean("Online");
            if (reactorPowered) {
                txtColor = 65280;
                text = LangHelper.translate("msg.nc.InfoPanelOn");
            } else {
                txtColor = 0xFF0000;
                text = LangHelper.translate("msg.nc.InfoPanelOff");
            }
            if (result.size() > 0) {
                PanelString firstLine = (PanelString)result.get(0);
                firstLine.textRight = text;
                firstLine.colorRight = txtColor;
            } else {
                line = new PanelString();
                line.textLeft = text;
                line.colorLeft = txtColor;
                result.add(line);
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelOnOff"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanel55.BufferOut"), 2, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanel55.BufferIn"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanel55.Out"), 8, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelRF.TempPROPER"), 16, CARD_TYPE));
        return result;
    }
}

