/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import vswe.production.gui.GuiTable;
import vswe.production.nei.Overlay;
import vswe.production.page.unit.UnitCrafting;
import vswe.production.tileentity.TileEntityTable;

public class OverlayWrapper
implements IOverlayHandler,
IStackPositioner {
    private GuiTable cachedInterface;
    private Overlay[] overlays = new Overlay[4];

    OverlayWrapper() {
        for (int i = 0; i < this.overlays.length; ++i) {
            int x = i % 2 * 256 / 2;
            int y = i / 2 * 174 / 2;
            this.overlays[i] = new Overlay(x - 20, y - 1);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onOpen(GuiOpenEvent event) {
        GuiContainer first;
        GuiScreen gui = event.gui;
        if (gui instanceof GuiRecipe && (first = ((GuiRecipe)gui).getFirstScreen()) instanceof GuiTable) {
            this.cachedInterface = (GuiTable)first;
        }
    }

    public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> items) {
        int id = this.getIndex(this.cachedInterface, items);
        if (id != -1) {
            int offsetX = this.overlays[id].getOffsetX();
            int offsetY = this.overlays[id].getOffsetY();
            for (PositionedStack stack : items) {
                stack.relx += offsetX;
                stack.rely += offsetY;
            }
        }
        return items;
    }

    private int getIndex(GuiContainer gui, List<PositionedStack> items) {
        if (gui instanceof GuiTable) {
            TileEntityTable table = ((GuiTable)gui).getTable();
            ArrayList<UnitCrafting> craftingList = new ArrayList<UnitCrafting>();
            for (UnitCrafting crafting : table.getMainPage().getCraftingList()) {
                if (!crafting.isEnabled() || crafting.isWorking()) continue;
                craftingList.add(crafting);
            }
            if (!items.isEmpty()) {
                int offset = 18;
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (PositionedStack stack : items) {
                    minX = Math.min(minX, stack.relx);
                    minY = Math.min(minY, stack.rely);
                    maxX = Math.max(maxX, stack.relx);
                    maxY = Math.max(maxY, stack.rely);
                }
                int width = (maxX - minX) / offset + 1;
                int height = (maxY - minY) / offset + 1;
                PositionedStack[][] recipe = new PositionedStack[width][height];
                for (PositionedStack stack : items) {
                    int x = (stack.relx - minX) / offset;
                    int y = (stack.rely - minY) / offset;
                    recipe[x][y] = stack;
                }
                for (UnitCrafting crafting : craftingList) {
                    for (int startX = 0; startX <= 3 - width; ++startX) {
                        for (int startY = 0; startY <= 3 - height; ++startY) {
                            boolean isMatch = true;
                            boolean isEmpty = true;
                            for (int offsetX = 0; offsetX < 3; ++offsetX) {
                                for (int offsetY = 0; offsetY < 3; ++offsetY) {
                                    int slotId = offsetX + offsetY * 3;
                                    int recipeX = offsetX - startX;
                                    ItemStack itemStack = table.func_70301_a(crafting.getGridId() + slotId);
                                    int recipeY = offsetY - startY;
                                    if (recipeX >= 0 && recipeX < width && recipeY >= 0 && recipeY < height) {
                                        if (itemStack == null) continue;
                                        PositionedStack positionedStack = recipe[recipeX][recipeY];
                                        if (positionedStack == null || !positionedStack.contains(itemStack)) {
                                            isMatch = false;
                                            break;
                                        }
                                        isEmpty = false;
                                        continue;
                                    }
                                    if (itemStack == null) continue;
                                    isMatch = false;
                                    break;
                                }
                                if (!isMatch) break;
                            }
                            if (!isMatch || isEmpty) continue;
                            return crafting.getId();
                        }
                    }
                }
            }
            for (UnitCrafting crafting : craftingList) {
                boolean isEmpty = true;
                for (int i = 0; i < 9; ++i) {
                    if (table.func_70301_a(crafting.getGridId() + i) == null) continue;
                    isEmpty = false;
                    break;
                }
                if (!isEmpty) continue;
                return crafting.getId();
            }
            if (!craftingList.isEmpty()) {
                return ((UnitCrafting)craftingList.get(0)).getId();
            }
        } else {
            System.err.println("Interface is not a GuiTable");
        }
        return -1;
    }

    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        int id = this.getIndex(gui, recipe.getIngredientStacks(recipeIndex));
        if (id != -1) {
            this.overlays[id].overlayRecipe(gui, recipe, recipeIndex, shift);
        }
    }
}

