/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.EnumMap;
import mcp.mobius.waila.network.IWailaMessage;
import mcp.mobius.waila.network.Message0x00ServerPing;
import mcp.mobius.waila.network.Message0x01TERequest;
import mcp.mobius.waila.network.Message0x02TENBTData;
import mcp.mobius.waila.network.Message0x03EntRequest;
import mcp.mobius.waila.network.Message0x04EntNBTData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;

public enum WailaPacketHandler {
    INSTANCE;

    public EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("Waila", new ChannelHandler[]{new WailaCodec()});

    private WailaPacketHandler() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addClientHandlers();
            this.addServerHandlers();
        } else {
            this.addServerHandlers();
        }
    }

    private void addClientHandlers() {
        FMLEmbeddedChannel channel = this.channels.get(Side.CLIENT);
        String codec = channel.findChannelHandlerNameForType(WailaCodec.class);
        channel.pipeline().addAfter(codec, "ServerPing", (ChannelHandler)new Message0x00ServerPing());
        channel.pipeline().addAfter("ServerPing", "TENBTData", (ChannelHandler)new Message0x02TENBTData());
        channel.pipeline().addAfter("TENBTData", "EntNBTData", (ChannelHandler)new Message0x04EntNBTData());
    }

    private void addServerHandlers() {
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        String codec = channel.findChannelHandlerNameForType(WailaCodec.class);
        channel.pipeline().addAfter(codec, "TERequest", (ChannelHandler)new Message0x01TERequest());
        channel.pipeline().addAfter("TERequest", "EntRequest", (ChannelHandler)new Message0x03EntRequest());
    }

    public void sendTo(IWailaMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(IWailaMessage message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void writeNBT(ByteBuf target, NBTTagCompound tag) throws IOException {
        if (tag == null) {
            target.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            target.writeShort((int)((short)abyte.length));
            target.writeBytes(abyte);
        }
    }

    public NBTTagCompound readNBT(ByteBuf dat) throws IOException {
        short short1 = dat.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        dat.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public void writeString(ByteBuf buffer, String data) throws IOException {
        byte[] abyte = data.getBytes(Charsets.UTF_8);
        buffer.writeShort(abyte.length);
        buffer.writeBytes(abyte);
    }

    public String readString(ByteBuf buffer) throws IOException {
        short j = buffer.readShort();
        String s = new String(buffer.readBytes((int)j).array(), Charsets.UTF_8);
        return s;
    }

    public static EntityPlayerMP getPlayer(ChannelHandlerContext ctx) {
        return ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
    }

    private class WailaCodec
    extends FMLIndexedMessageToMessageCodec<IWailaMessage> {
        public WailaCodec() {
            this.addDiscriminator(0, Message0x00ServerPing.class);
            this.addDiscriminator(1, Message0x01TERequest.class);
            this.addDiscriminator(2, Message0x02TENBTData.class);
            this.addDiscriminator(3, Message0x03EntRequest.class);
            this.addDiscriminator(4, Message0x04EntNBTData.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, IWailaMessage msg, ByteBuf target) throws Exception {
            msg.encodeInto(ctx, msg, target);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IWailaMessage msg) {
            msg.decodeInto(ctx, dat, msg);
        }
    }
}

