/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import blusunrize.immersiveengineering.common.util.compat.ModCompatability;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChargingStation
extends TileEntityIEBase
implements IEnergyReceiver,
IInventory {
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(1024, Config.getInt("charger_consumption")));
    public int facing = 2;
    public ItemStack inventory;
    private boolean charging = false;
    public int comparatorOutput = 0;

    public void func_145845_h() {
        if (this.inventory != null && (this.inventory.func_77973_b() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(this.inventory))) {
            int max;
            if (this.field_145850_b.field_72995_K && this.charging) {
                float charge = 0.0f;
                if (this.inventory.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.func_77973_b();
                    int max2 = container.getMaxEnergyStored(this.inventory);
                    if (max2 > 0) {
                        charge = (float)container.getEnergyStored(this.inventory) / (float)max2;
                    }
                } else {
                    double max3 = IC2Helper.getMaxItemCharge(this.inventory);
                    if (max3 > 0.0) {
                        charge = (float)(IC2Helper.getCurrentItemCharge(this.inventory) / max3);
                    }
                }
                max = 3;
                for (int i = 0; i < max; ++i) {
                    long time = this.field_145850_b.func_82737_E();
                    if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                    int shift = i - 1;
                    double x = (double)this.field_145851_c + 0.5 + (this.facing == 4 ? -0.46875 : (this.facing == 5 ? 0.46875 : (this.facing == 2 ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    double y = (double)this.field_145848_d + 0.25;
                    double z = (double)this.field_145849_e + 0.5 + (this.facing == 2 ? -0.46875 : (this.facing == 3 ? 0.46875 : (this.facing == 5 ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_145850_b, x, y, z, 0.25, 0.25, 0.25, 0.5f, 1.0f - charge, charge, 0.0f);
                }
            } else if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    return;
                }
                if (this.inventory.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.func_77973_b();
                    max = container.getMaxEnergyStored(this.inventory);
                    int space = max - container.getEnergyStored(this.inventory);
                    if (max > 0 && space > 0) {
                        int energyDecNew;
                        int energyDec = 10 * container.getEnergyStored(this.inventory) / max;
                        int insert = Math.min(space, Config.getInt("charger_consumption"));
                        int accepted = Math.min(container.receiveEnergy(this.inventory, insert, true), this.energyStorage.extractEnergy(insert, true));
                        if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                            container.receiveEnergy(this.inventory, accepted, false);
                        }
                        if (energyDec != (energyDecNew = 10 * container.getEnergyStored(this.inventory) / max)) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                } else {
                    double max4 = IC2Helper.getMaxItemCharge(this.inventory);
                    double space = max4 - IC2Helper.getCurrentItemCharge(this.inventory);
                    if (max4 > 0.0 && space > 0.0) {
                        int energyDecNew;
                        int energyDec = (int)(10.0 * IC2Helper.getCurrentItemCharge(this.inventory) / max4);
                        double insert = Math.min(space, ModCompatability.convertRFtoEU(Config.getInt("charger_consumption"), 5));
                        double accepted = IC2Helper.chargeItem(this.inventory, insert, true);
                        int rfAccepted = this.energyStorage.extractEnergy(ModCompatability.convertEUtoRF(accepted), false);
                        if (rfAccepted > 0) {
                            IC2Helper.chargeItem(this.inventory, ModCompatability.convertRFtoEU(rfAccepted, 5), false);
                        }
                        if (energyDec != (energyDecNew = (int)(10.0 * IC2Helper.getCurrentItemCharge(this.inventory) / max4))) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 32L == (long)((this.field_145851_c ^ this.field_145849_e) & 0x1F)) {
            int i;
            float charge = 0.0f;
            if (this.inventory != null && (this.inventory.func_77973_b() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(this.inventory))) {
                if (this.inventory.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem container = (IEnergyContainerItem)this.inventory.func_77973_b();
                    charge = (float)container.getEnergyStored(this.inventory) / (float)container.getMaxEnergyStored(this.inventory);
                } else {
                    charge = (float)(IC2Helper.getCurrentItemCharge(this.inventory) / IC2Helper.getMaxItemCharge(this.inventory));
                }
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.facing = nbt.func_74762_e("facing");
        this.inventory = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inventory"));
        this.charging = nbt.func_74767_n("charging");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("charging", this.charging);
        if (this.inventory != null) {
            nbt.func_74782_a("inventory", (NBTBase)this.inventory.func_77955_b(new NBTTagCompound()));
        }
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN || from != null && from.getOpposite().ordinal() == this.facing;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
    }

    public String func_145825_b() {
        return "IEChargingStation";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IEnergyContainerItem;
    }
}

