/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.tileentity.TileEntity;

public class CuttingEdgeHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        ChemthrowerHandler.registerEffect("rubbersap", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.sticky, 100, 1));
        ChemthrowerHandler.registerEffect("maplesap", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.sticky, 100, 0));
        try {
            Class<?> c_TileEvaporator = Class.forName("ttftcuts.cuttingedge.treetap.TileEvaporator");
            if (c_TileEvaporator != null) {
                ExternalHeaterHandler.registerHeatableAdapter(c_TileEvaporator, new EvaporatorAdapter());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void postInit() {
    }

    public static class EvaporatorAdapter
    extends ExternalHeaterHandler.HeatableAdapter {
        Method m_canEvaporate;
        Field f_burnTime;
        Field f_burning;
        Field f_cookTime;

        public EvaporatorAdapter() {
            try {
                Class<?> c_TileEvaporator = Class.forName("ttftcuts.cuttingedge.treetap.TileEvaporator");
                this.m_canEvaporate = c_TileEvaporator.getDeclaredMethod("canEvaporate", new Class[0]);
                this.m_canEvaporate.setAccessible(true);
                this.f_burnTime = c_TileEvaporator.getDeclaredField("burnTime");
                this.f_burning = c_TileEvaporator.getDeclaredField("burning");
                this.f_cookTime = c_TileEvaporator.getDeclaredField("cookTime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean canEvaporate(TileEntity tileEntity) throws Exception {
            if (this.m_canEvaporate != null) {
                return (Boolean)this.m_canEvaporate.invoke((Object)tileEntity, new Object[0]);
            }
            return false;
        }

        public int doHeatTick(TileEntity tileEntity, int energyAvailable, boolean redstone) {
            if (this.f_burnTime == null) {
                return 0;
            }
            int energyConsumed = 0;
            try {
                int burnTime = this.f_burnTime.getInt(tileEntity);
                boolean canEvaporate = this.canEvaporate(tileEntity);
                if (canEvaporate || redstone) {
                    int energyToUse;
                    int heatEnergyRatio;
                    int heatAttempt;
                    int energyToUse2;
                    int heat;
                    boolean active;
                    boolean bl = active = burnTime == 0;
                    if (burnTime < 200 && (heat = (energyToUse2 = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, ExternalHeaterHandler.defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                        burnTime += heat;
                        energyConsumed += heat * heatEnergyRatio;
                        if (!active) {
                            this.f_burning.setBoolean(tileEntity, true);
                            tileEntity.func_145831_w().func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                        }
                    }
                    int cookTime = this.f_cookTime.getInt(tileEntity);
                    if (canEvaporate && burnTime >= 200 && cookTime < 199 && energyAvailable - energyConsumed > (energyToUse = ExternalHeaterHandler.defaultFurnaceSpeedupCost)) {
                        energyConsumed += energyToUse;
                        this.f_cookTime.setInt(tileEntity, ++cookTime);
                    }
                    this.f_burnTime.setInt(tileEntity, burnTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return energyConsumed;
        }
    }
}

