/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import magicbees.main.Config;
import magicbees.main.utils.VersionInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class TickHandlerVersion {
    private static int TICK_POLL_INTERVAL = 250;
    private int ticksToPoll;
    private VersionInfo versionInfo;
    private final ChatStyle newVersion = new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true));
    private final ChatStyle description = new ChatStyle().func_150238_a(EnumChatFormatting.GRAY);
    private final ChatStyle alert = new ChatStyle().func_150238_a(EnumChatFormatting.RED);

    private TickHandlerVersion() {
        this.ticksToPoll = TICK_POLL_INTERVAL;
    }

    private void setVersionInfo(VersionInfo vInfo) {
        this.versionInfo = vInfo;
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.ticksToPoll > 0) {
            --this.ticksToPoll;
            return;
        }
        this.ticksToPoll = TICK_POLL_INTERVAL;
        if (this.versionInfo.versionCheckComplete) {
            this.unsubscribeFromBus();
            if (this.updateNotificationsEnabledOrCriticalUpdate()) {
                this.sendNotificationToPlayer(evt.player);
            }
        }
    }

    private void sendNotificationToPlayer(EntityPlayer player) {
        if (this.versionInfo.isCriticalUpdate()) {
            player.func_145747_a(new ChatComponentTranslation("magicbees.versioning.critical", new Object[]{this.versionInfo.getLatestVersion()}).func_150255_a(this.alert));
        } else {
            player.func_145747_a(new ChatComponentTranslation("magicbees.versioning.newVersion", new Object[]{this.versionInfo.getLatestVersion()}).func_150255_a(this.newVersion));
        }
        ChatStyle thisDescription = this.description.func_150232_l();
        thisDescription.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/mc-mods/65764-magic-bees/files"));
        thisDescription.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.versionInfo.getVersionDescription())));
        player.func_145747_a(new ChatComponentTranslation("magicbees.versioning.clickDownload", new Object[0]).func_150255_a(thisDescription));
    }

    private boolean updateNotificationsEnabledOrCriticalUpdate() {
        return (!Config.disableUpdateNotification || this.versionInfo.isCriticalUpdate()) && this.versionInfo.isNewVersionAvailable();
    }

    private void subscribeToBus() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void unsubscribeFromBus() {
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    public static void go(VersionInfo vInfo) {
        LazyHolder.instance.setVersionInfo(vInfo);
        LazyHolder.instance.subscribeToBus();
    }

    private static class LazyHolder {
        private static final TickHandlerVersion instance = new TickHandlerVersion();

        private LazyHolder() {
        }
    }
}

