/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import neresources.api.distributions.DistributionCustom;
import neresources.api.utils.DropItem;
import neresources.api.utils.PlantDrop;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MessageHelper {
    public static final int NBT_MULTIPLIER = 100000;

    public static NBTTagList getItemStackList(ItemStack ... stacks) {
        NBTTagList result = new NBTTagList();
        for (ItemStack stack : stacks) {
            result.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        return result;
    }

    public static NBTTagList getDropItemList(DropItem ... dropItems) {
        NBTTagList result = new NBTTagList();
        for (DropItem dropItem : dropItems) {
            result.func_74742_a((NBTBase)dropItem.writeToNBT());
        }
        return result;
    }

    public static NBTTagList getPlantDropList(PlantDrop ... plantDrops) {
        NBTTagList result = new NBTTagList();
        for (PlantDrop plantDrop : plantDrops) {
            result.func_74742_a((NBTBase)plantDrop.writeToNBT());
        }
        return result;
    }

    public static ItemStack[] getItemStacks(NBTTagCompound tagCompound, String key) {
        return MessageHelper.getItemStacks(tagCompound.func_150295_c(key, 10));
    }

    public static ItemStack[] getItemStacks(NBTTagList list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                if (item == null) continue;
                result.add(item);
            }
        }
        return result.toArray(new ItemStack[result.size()]);
    }

    public static DropItem[] getDropItems(NBTTagCompound tagCompound, String key) {
        return MessageHelper.getDropItems(tagCompound.func_150295_c(key, 10));
    }

    public static DropItem[] getDropItems(NBTTagList list) {
        ArrayList<DropItem> dropItems = new ArrayList<DropItem>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                DropItem item = DropItem.readFromNBT(list.func_150305_b(i));
                if (item == null) continue;
                dropItems.add(item);
            }
        }
        return dropItems.toArray(new DropItem[dropItems.size()]);
    }

    public static PlantDrop[] getPlantDrops(NBTTagCompound tagCompound, String key) {
        return MessageHelper.getPlantDrops(tagCompound.func_150295_c(key, 10));
    }

    public static PlantDrop[] getPlantDrops(NBTTagList list) {
        ArrayList<PlantDrop> plantDrops = new ArrayList<PlantDrop>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                PlantDrop item = PlantDrop.readFromNBT(list.func_150305_b(i));
                if (item == null) continue;
                plantDrops.add(item);
            }
        }
        return plantDrops.toArray(new PlantDrop[plantDrops.size()]);
    }

    public static int[] getIntArray(float[] distribution) {
        int[] array = new int[distribution.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (int)(distribution[i] * 100000.0f);
        }
        return array;
    }

    public static DistributionCustom getDistribution(NBTTagCompound tagCompound) {
        if (!tagCompound.func_74764_b("distribution")) {
            return null;
        }
        int[] array = tagCompound.func_74759_k("distribution");
        float[] distribution = new float[256];
        for (int i = 0; i < array.length && i < distribution.length; ++i) {
            distribution[i] = (float)array[i] / 100000.0f;
        }
        if (tagCompound.func_74764_b("bestHeight")) {
            return new DistributionCustom(distribution, tagCompound.func_74762_e("bestHeight"));
        }
        return new DistributionCustom(distribution);
    }

    public static String getClass(Object clazz) {
        if (clazz instanceof String) {
            return (String)clazz;
        }
        if (clazz instanceof Class) {
            return ((Class)clazz).getName();
        }
        return "";
    }

    public static NBTTagList mapToNBTTagList(Map<ItemStack, Float> map) {
        NBTTagList result = new NBTTagList();
        for (Map.Entry<ItemStack, Float> entry : map.entrySet()) {
            result.func_74742_a((NBTBase)MessageHelper.entryToNBTTagCompound(entry));
        }
        return result;
    }

    private static NBTTagCompound entryToNBTTagCompound(Map.Entry<ItemStack, Float> entry) {
        NBTTagCompound result = new NBTTagCompound();
        entry.getKey().func_77955_b(result);
        result.func_74776_a("chance", entry.getValue().floatValue());
        return result;
    }

    public static Map<ItemStack, Float> nbtTagListToMap(NBTTagList list) {
        LinkedHashMap<ItemStack, Float> result = new LinkedHashMap<ItemStack, Float>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)entry);
            float chance = entry.func_74760_g("chance");
            if (stack == null || chance < 0.0f) continue;
            result.put(stack, Float.valueOf(chance));
        }
        return result;
    }
}

