/*
 * Decompiled with CFR 0.152.
 */
package neresources.utils;

import java.util.Arrays;
import net.minecraft.util.WeightedRandomChestContent;

public class WeightedRandomChestContentHelper {
    public static WeightedRandomChestContent[] sort(WeightedRandomChestContent[] contents) {
        if (contents.length <= 1) {
            return contents;
        }
        int split = contents.length / 2;
        WeightedRandomChestContent[] left = WeightedRandomChestContentHelper.subArray(contents, 0, split);
        WeightedRandomChestContent[] right = WeightedRandomChestContentHelper.subArray(contents, split, contents.length);
        left = WeightedRandomChestContentHelper.sort(left);
        right = WeightedRandomChestContentHelper.sort(right);
        return WeightedRandomChestContentHelper.merge(left, right);
    }

    private static float getAverageChance(WeightedRandomChestContent chestContent) {
        return (float)(chestContent.field_76296_e + chestContent.field_76295_d) / 2.0f * (float)chestContent.field_76292_a;
    }

    private static WeightedRandomChestContent[] merge(WeightedRandomChestContent[] left, WeightedRandomChestContent[] right) {
        int length = left.length + right.length;
        WeightedRandomChestContent[] merged = new WeightedRandomChestContent[length];
        int i = 0;
        int li = 0;
        int ri = 0;
        while (i < length) {
            if (li < left.length && ri < right.length) {
                if (WeightedRandomChestContentHelper.getAverageChance(left[li]) >= WeightedRandomChestContentHelper.getAverageChance(right[ri])) {
                    merged[i] = left[li];
                    ++i;
                    ++li;
                    continue;
                }
                merged[i] = right[ri];
                ++i;
                ++ri;
                continue;
            }
            if (li >= left.length) {
                while (ri < right.length) {
                    merged[i] = right[ri];
                    ++i;
                    ++ri;
                }
            }
            if (ri < right.length) continue;
            while (li < left.length) {
                merged[i] = left[li];
                ++i;
                ++li;
            }
        }
        return merged;
    }

    private static WeightedRandomChestContent[] subArray(WeightedRandomChestContent[] array, int begin, int end) {
        return Arrays.copyOfRange(array, begin, end);
    }
}

