/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine;

import binnie.core.Mods;
import binnie.core.circuits.BinnieCircuit;
import binnie.core.genetics.BeeModifierLogic;
import binnie.core.genetics.EnumBeeBooleanModifier;
import binnie.core.genetics.EnumBeeModifier;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.ComponentExtraBeeGUI;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.core.ExtraBeeTexture;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AlvearyStimulator {
    public static int slotCircuit = 0;

    public static enum CircuitType implements IBeeModifier
    {
        LowVoltage(3, 10),
        HighVoltage(5, 20),
        Plant(10, 10),
        Death(6, 10),
        Life(11, 10),
        Nether(7, 15),
        Mutation(4, 15),
        Inhibitor(1, 10),
        Territory(2, 10);

        public int recipe;
        public int power;
        BeeModifierLogic logic = new BeeModifierLogic();

        private CircuitType(int recipe, int power) {
            this.recipe = recipe;
            this.power = power;
        }

        public void createCircuit(ICircuitLayout layout) {
            StimulatorCircuit circuit = new StimulatorCircuit(this, layout);
            for (EnumBeeModifier modifier : EnumBeeModifier.values()) {
                float mod = this.logic.getModifier(modifier, 1.0f);
                if (mod == 1.0f) continue;
                if (mod > 1.0f) {
                    int increase = (int)((mod - 1.0f) * 100.0f);
                    circuit.addTooltipString("Increases " + modifier.getName() + " by " + increase + "%");
                    continue;
                }
                int decrease = (int)((1.0f - mod) * 100.0f);
                circuit.addTooltipString("Decreases " + modifier.getName() + " by " + decrease + "%");
            }
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.Territory, currentModifier);
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.Mutation, currentModifier);
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.Lifespan, currentModifier);
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.Production, currentModifier);
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.Flowering, currentModifier);
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return this.logic.getModifier(EnumBeeModifier.GeneticDecay, currentModifier);
        }

        public boolean isSealed() {
            return this.logic.getModifier(EnumBeeBooleanModifier.Sealed);
        }

        public boolean isSelfLighted() {
            return this.logic.getModifier(EnumBeeBooleanModifier.SelfLighted);
        }

        public boolean isSunlightSimulated() {
            return this.logic.getModifier(EnumBeeBooleanModifier.SunlightStimulated);
        }

        public boolean isHellish() {
            return this.logic.getModifier(EnumBeeBooleanModifier.Hellish);
        }

        static {
            CircuitType.LowVoltage.logic.setModifier(EnumBeeModifier.Production, 1.5f, 5.0f);
            CircuitType.HighVoltage.logic.setModifier(EnumBeeModifier.Production, 2.5f, 10.0f);
            CircuitType.Plant.logic.setModifier(EnumBeeModifier.Flowering, 1.5f, 5.0f);
            CircuitType.Death.logic.setModifier(EnumBeeModifier.Lifespan, 0.8f, 0.2f);
            CircuitType.Life.logic.setModifier(EnumBeeModifier.Lifespan, 1.5f, 5.0f);
            CircuitType.Nether.logic.setModifier(EnumBeeBooleanModifier.Hellish);
            CircuitType.Mutation.logic.setModifier(EnumBeeModifier.Mutation, 1.5f, 5.0f);
            CircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.Territory, 0.4f, 0.1f);
            CircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.Production, 0.9f, 0.5f);
            CircuitType.Territory.logic.setModifier(EnumBeeModifier.Territory, 1.5f, 5.0f);
            for (CircuitType type : CircuitType.values()) {
                type.logic.setModifier(EnumBeeModifier.GeneticDecay, 1.5f, 10.0f);
            }
        }
    }

    public static class StimulatorCircuit
    extends BinnieCircuit
    implements IBeeModifier {
        CircuitType type;

        public StimulatorCircuit(CircuitType type, ICircuitLayout layout) {
            super("stimulator." + type.toString().toLowerCase(), 4, layout, Mods.Forestry.item("thermionicTubes"), type.recipe);
            this.type = type;
        }

        public int getPowerUsage() {
            return this.type.power;
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getTerritoryModifier(genome, currentModifier);
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.type.getMutationModifier(genome, mate, currentModifier);
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return this.type.getLifespanModifier(genome, mate, currentModifier);
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getProductionModifier(genome, currentModifier);
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return this.type.getFloweringModifier(genome, currentModifier);
        }

        public boolean isSealed() {
            return this.type.isSealed();
        }

        public boolean isSelfLighted() {
            return this.type.isSelfLighted();
        }

        public boolean isSunlightSimulated() {
            return this.type.isSunlightSimulated();
        }

        public boolean isHellish() {
            return this.type.isHellish();
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return this.type.getGeneticDecay(genome, currentModifier);
        }
    }

    public static class ComponentStimulatorModifier
    extends ComponentBeeModifier
    implements IBeeModifier,
    IBeeListener {
        float powerUsage = 0.0f;
        boolean powered = false;
        StimulatorCircuit[] modifiers = new StimulatorCircuit[0];

        public ComponentStimulatorModifier(Machine machine) {
            super(machine);
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            this.modifiers = this.getCircuits();
            this.powerUsage = 0.0f;
            for (StimulatorCircuit beeMod : this.modifiers) {
                this.powerUsage += (float)beeMod.getPowerUsage();
            }
            this.powered = this.getUtil().hasEnergyMJ(this.powerUsage);
        }

        public ICircuitBoard getHiveFrame() {
            if (!this.getUtil().isSlotEmpty(slotCircuit)) {
                return ChipsetManager.circuitRegistry.getCircuitboard(this.getUtil().getStack(slotCircuit));
            }
            return null;
        }

        public StimulatorCircuit[] getCircuits() {
            ICircuitBoard board = this.getHiveFrame();
            if (board == null) {
                return new StimulatorCircuit[0];
            }
            ICircuit[] circuits = board.getCircuits();
            ArrayList<StimulatorCircuit> mod = new ArrayList<StimulatorCircuit>();
            for (ICircuit circuit : circuits) {
                if (!(circuit instanceof StimulatorCircuit)) continue;
                mod.add((StimulatorCircuit)circuit);
            }
            return mod.toArray(new StimulatorCircuit[0]);
        }

        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getTerritoryModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getMutationModifier(genome, mate, mod);
            }
            return mod;
        }

        @Override
        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getLifespanModifier(genome, mate, mod);
            }
            return mod;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getProductionModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getFloweringModifier(genome, mod);
            }
            return mod;
        }

        @Override
        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            float mod = 1.0f;
            if (!this.powered) {
                return mod;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                mod *= beeMod.getGeneticDecay(genome, mod);
            }
            return mod;
        }

        @Override
        public boolean isSealed() {
            if (!this.powered) {
                return false;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                if (!beeMod.isSealed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSelfLighted() {
            if (!this.powered) {
                return false;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                if (!beeMod.isSelfLighted()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSunlightSimulated() {
            if (!this.powered) {
                return false;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                if (!beeMod.isSunlightSimulated()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isHellish() {
            if (!this.powered) {
                return false;
            }
            for (StimulatorCircuit beeMod : this.modifiers) {
                if (!beeMod.isHellish()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void wearOutEquipment(int amount) {
            this.getUtil().useEnergyMJ(this.powerUsage);
        }
    }

    public static class SlotValidatorCircuit
    extends SlotValidator {
        public SlotValidatorCircuit() {
            super(SlotValidator.IconCircuit);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return itemStack != null && ChipsetManager.circuitRegistry.isChipset(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Forestry Circuits";
        }
    }

    public static class PackageAlvearyStimulator
    extends AlvearyMachine.AlvearyPackage
    implements IMachineInformation {
        public PackageAlvearyStimulator() {
            super("stimulator", ExtraBeeTexture.AlvearyStimulator.getTexture(), true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentExtraBeeGUI(machine, ExtraBeeGUID.AlvearyStimulator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotCircuit, "circuit");
            inventory.getSlot(slotCircuit).setValidator((Validator)new SlotValidatorCircuit());
            ComponentPowerReceptor power = new ComponentPowerReceptor(machine);
            new ComponentStimulatorModifier(machine);
        }
    }
}

