/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.transfer.TransferRequest;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class Incubator {
    public static final int[] slotQueue = new int[]{0, 1, 2};
    public static final int slotIncubator = 3;
    public static final int[] slotOutput = new int[]{4, 5, 6};
    public static final int tankInput = 0;
    public static final int tankOutput = 1;
    private static List<IIncubatorRecipe> RECIPES = new ArrayList<IIncubatorRecipe>();

    public static void addRecipes() {
        RECIPES.add(new IncubatorRecipe(Binnie.Liquid.getLiquidStack("water", 25), GeneticLiquid.GrowthMedium.get(25), 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.GrowthMedium.get(25), GeneticLiquid.Bacteria.get(5), 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151015_O).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(0), GeneticLiquid.Bacteria.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(2), null, 0.5f, 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151102_aT;
            }
        }.setOutputStack(GeneticsItems.Enzyme.get(1)));
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.BacteriaPoly.get(0), GeneticLiquid.BacteriaPoly.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.BacteriaVector.get(0), GeneticLiquid.BacteriaVector.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaPoly.get(10), 0.1f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151100_aR, 1, 15).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaVector.get(10), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151065_br).func_77969_a(stack);
            }
        });
        if (BinnieCore.isApicultureActive()) {
            RECIPES.add(new IncubatorRecipe(GeneticLiquid.GrowthMedium.get(50), null, 1.0f, 0.05f){

                @Override
                public boolean isItemStack(ItemStack stack) {
                    return Binnie.Genetics.getBeeRoot().isMember(stack) && Binnie.Genetics.getBeeRoot().getType(stack) == EnumBeeType.LARVAE;
                }

                @Override
                public ItemStack getOutputStack(MachineUtil machine) {
                    ItemStack larvae = machine.getStack(3);
                    IBee bee = Binnie.Genetics.getBeeRoot().getMember(larvae);
                    return Binnie.Genetics.getBeeRoot().getMemberStack((IIndividual)bee, EnumBeeType.DRONE.ordinal());
                }
            });
        }
    }

    private static abstract class IncubatorRecipe
    implements IIncubatorRecipe {
        FluidStack input;
        FluidStack output;
        float lossChance;
        ItemStack outputStack;
        float tickChance;

        @Override
        public float getChance() {
            return this.tickChance;
        }

        public IncubatorRecipe(FluidStack input, FluidStack output, float lossChance) {
            this(input, output, lossChance, 1.0f);
        }

        public IncubatorRecipe(FluidStack input, FluidStack output, float lossChance, float chance) {
            this.input = input;
            this.output = output;
            this.lossChance = lossChance;
            this.tickChance = chance;
        }

        @Override
        public boolean isInputLiquid(FluidStack fluid) {
            return fluid != null && this.input.isFluidEqual(fluid);
        }

        @Override
        public boolean isInputLiquidSufficient(FluidStack fluid) {
            return fluid != null && fluid.amount >= 500;
        }

        @Override
        public void doTask(MachineUtil machine) {
            Random rand;
            machine.drainTank(0, this.input.amount);
            if (this.output != null) {
                machine.fillTank(1, this.output);
            }
            this.outputStack = this.getOutputStack(machine);
            if (this.outputStack != null) {
                ItemStack output = this.outputStack.func_77946_l();
                TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(slotOutput).ignoreValidation();
                product.transfer(true);
            }
            if ((rand = machine.getRandom()).nextFloat() < this.lossChance) {
                machine.decreaseStack(3, 1);
            }
        }

        public IncubatorRecipe setOutputStack(ItemStack stack) {
            this.outputStack = stack;
            return this;
        }

        protected ItemStack getOutputStack(MachineUtil util) {
            return this.outputStack;
        }

        @Override
        public boolean roomForOutput(MachineUtil machine) {
            ItemStack outputStack;
            if (this.output != null && !machine.isTankEmpty(1)) {
                if (!machine.getFluid(1).isFluidEqual(this.output)) {
                    return false;
                }
                if (!machine.spaceInTank(1, this.output.amount)) {
                    return false;
                }
            }
            if ((outputStack = this.getOutputStack(machine)) != null) {
                ItemStack output = outputStack.func_77946_l();
                TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(slotOutput).ignoreValidation();
                ItemStack leftover = product.transfer(false);
                return leftover == null;
            }
            return true;
        }
    }

    private class IncubatorCrafting {
        ItemStack input;
        FluidStack fluid;

        private IncubatorCrafting() {
        }
    }

    public static class ComponentIncubatorLogic
    extends ComponentProcessIndefinate
    implements IProcess {
        IIncubatorRecipe recipe = null;
        private Random rand = new Random();
        private boolean roomForOutput = true;

        public ComponentIncubatorLogic(Machine machine) {
            super(machine, 2.0f);
        }

        @Override
        public ErrorState canWork() {
            if (this.recipe == null) {
                return new ErrorState("No Recipe", "There is no valid recipe");
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (this.recipe != null) {
                if (!this.recipe.isInputLiquidSufficient(this.getUtil().getFluid(0))) {
                    return new ErrorState.InsufficientLiquid("Not enough incubation liquid", 0);
                }
                if (!this.roomForOutput) {
                    return new ErrorState.TankSpace("No room for output", 1);
                }
            }
            return super.canProgress();
        }

        @Override
        protected void onTickTask() {
            if (this.rand.nextInt(20) == 0 && this.recipe != null && this.rand.nextFloat() < this.recipe.getChance()) {
                this.recipe.doTask(this.getUtil());
            }
        }

        @Override
        public boolean inProgress() {
            return this.recipe != null;
        }

        private IIncubatorRecipe getRecipe(ItemStack stack, FluidStack liquid) {
            for (IIncubatorRecipe recipe : RECIPES) {
                boolean rightLiquid = recipe.isInputLiquid(liquid);
                boolean rightItem = recipe.isItemStack(stack);
                if (!rightLiquid || !rightItem) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public void onInventoryUpdate() {
            super.onInventoryUpdate();
            if (!this.getUtil().isServer()) {
                return;
            }
            FluidStack liquid = this.getUtil().getFluid(0);
            ItemStack incubator = this.getUtil().getStack(3);
            if (!(this.recipe == null || incubator != null && liquid != null && this.recipe.isInputLiquid(liquid) && this.recipe.isItemStack(incubator))) {
                this.recipe = null;
                ItemStack leftover = new TransferRequest(incubator, this.getInventory()).setTargetSlots(slotOutput).ignoreValidation().transfer(true);
                this.getUtil().setStack(3, leftover);
            }
            if (this.recipe == null) {
                IIncubatorRecipe recipe;
                if (liquid == null) {
                    return;
                }
                if (incubator != null && (recipe = this.getRecipe(incubator, liquid)) != null) {
                    this.recipe = recipe;
                    return;
                }
                IIncubatorRecipe potential = null;
                int potentialSlot = 0;
                block0: for (int slot : slotQueue) {
                    ItemStack stack = this.getUtil().getStack(slot);
                    if (stack == null || potential != null) continue;
                    for (IIncubatorRecipe recipe2 : RECIPES) {
                        boolean rightLiquid = recipe2.isInputLiquid(liquid);
                        boolean rightItem = recipe2.isItemStack(stack);
                        if (!rightLiquid || !rightItem) continue;
                        potential = recipe2;
                        potentialSlot = slot;
                        continue block0;
                    }
                }
                if (potential != null) {
                    TransferRequest removal = new TransferRequest(incubator, this.getInventory()).setTargetSlots(slotOutput).ignoreValidation();
                    if (removal.transfer(false) == null) {
                        this.recipe = potential;
                    }
                    removal.transfer(true);
                    ItemStack stack = this.getUtil().getStack(potentialSlot);
                    this.getUtil().setStack(potentialSlot, null);
                    this.getUtil().setStack(3, stack);
                }
            }
            if (this.recipe != null) {
                this.roomForOutput = this.recipe.roomForOutput(this.getUtil());
            }
        }
    }

    public static class PackageIncubator
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageIncubator() {
            super("incubator", GeneticsTexture.Incubator, 16767313, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Incubator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlotArray(slotQueue, "input");
            for (InventorySlot slot : inventory.getSlots(slotQueue)) {
                slot.forbidExtraction();
            }
            inventory.addSlot(3, "incubator");
            inventory.getSlot(3).forbidInteraction();
            inventory.getSlot(3).setReadOnly();
            inventory.addSlotArray(slotOutput, "output");
            for (InventorySlot slot : inventory.getSlots(slotOutput)) {
                slot.forbidInsertion();
                slot.setReadOnly();
            }
            new ComponentPowerReceptor(machine, 2000);
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(0, "input", 2000).forbidExtraction();
            tanks.addTank(1, "output", 2000).setReadOnly();
            new ComponentIncubatorLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

