/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.sa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import net.creeperhost.sa.FilterObjectInputStream;
import net.creeperhost.sa.Logger;
import net.creeperhost.sa.SerializationAgent;
import net.creeperhost.sa.repack.org.objectweb.asm.ClassReader;
import net.creeperhost.sa.repack.org.objectweb.asm.ClassVisitor;
import net.creeperhost.sa.repack.org.objectweb.asm.ClassWriter;
import net.creeperhost.sa.repack.org.objectweb.asm.MethodVisitor;

public class SerializationAgentTransformer
implements ClassFileTransformer {
    private static final String OBJECT_INPUT_STREAM = ObjectInputStream.class.getName().replace('.', '/');
    private static final String FILTER_OBJECT_INPUT_STREAM = FilterObjectInputStream.class.getName().replace('.', '/');

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        String jCName = className.replace('/', '.');
        if (!SerializationAgent.toTransform.contains(jCName)) {
            return bytes;
        }
        Logger.debug("Transforming " + className);
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(0);
        final boolean[] transformed = new boolean[1];
        cr.accept(new ClassVisitor(589824, cw){

            @Override
            public MethodVisitor visitMethod(int access, final String mName, final String mDesc, String signature, String[] exceptions) {
                return new MethodVisitor(589824, super.visitMethod(access, mName, mDesc, signature, exceptions)){

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        if (opcode == 187 && type.equals(OBJECT_INPUT_STREAM)) {
                            Logger.debug(" Transforming NEW inside " + mName + mDesc);
                            type = FILTER_OBJECT_INPUT_STREAM;
                            transformed[0] = true;
                        }
                        super.visitTypeInsn(opcode, type);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (opcode == 183 && owner.equals(OBJECT_INPUT_STREAM)) {
                            Logger.debug(" Transforming INVOKESPECIAL inside " + mName + mDesc);
                            owner = FILTER_OBJECT_INPUT_STREAM;
                            transformed[0] = true;
                        }
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }
                };
            }
        }, 0);
        if (transformed[0]) {
            bytes = cw.toByteArray();
            if (SerializationAgent.DEBUG) {
                try {
                    Path path = Paths.get("asm/serializationagent/" + className + ".class", new String[0]);
                    if (!Files.exists(path.getParent(), new LinkOption[0])) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    Files.write(path, bytes, new OpenOption[0]);
                }
                catch (IOException ex) {
                    Logger.error("Failed to write file.", ex);
                }
            }
        }
        return bytes;
    }
}

