/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.Log;
import openperipheral.addons.glasses.utils.IPolygonBuilder;
import openperipheral.addons.glasses.utils.IRenderCommand;
import openperipheral.addons.glasses.utils.RenderState;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.GLUtessellator;
import org.lwjgl.util.glu.GLUtessellatorCallback;
import org.lwjgl.util.glu.GLUtessellatorCallbackAdapter;

public abstract class PolygonBuilderBase<P, D>
implements IPolygonBuilder<P> {
    private static final IRenderCommand NULL_COMMAND = new IRenderCommand(){

        @Override
        public void execute(RenderState renderState) {
        }
    };
    private static final IRenderCommand RENDER_END_COMMAND = new IRenderCommand(){

        @Override
        public void execute(RenderState renderState) {
            GL11.glEnd();
        }
    };
    private final GLUtessellator tesselator = GLU.gluNewTess();
    private final List<IRenderCommand> commands = Lists.newArrayList();
    private boolean failed = false;
    private boolean started;
    private GLUtessellatorCallback collector = new GLUtessellatorCallbackAdapter(){

        public void begin(int type) {
            PolygonBuilderBase.this.commands.add(PolygonBuilderBase.createRenderBeginCommand(type));
        }

        public void end() {
            PolygonBuilderBase.this.commands.add(RENDER_END_COMMAND);
        }

        public void vertex(Object vertexData) {
            Object data = vertexData;
            PolygonBuilderBase.this.commands.add(PolygonBuilderBase.this.createVertexCommand(data));
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            ArrayList objects = Lists.newArrayList();
            for (int i = 0; i < data.length; ++i) {
                Object element = data[i];
                if (element == null) continue;
                objects.add(new CombineData<Object>(element, weight[i]));
            }
            outData[0] = PolygonBuilderBase.this.onCombine(coords, objects);
        }

        public void error(int errorCode) {
            Log.debug((String)"Failed to create polygon, cause %d=%s", (Object[])new Object[]{errorCode, GLU.gluErrorString((int)errorCode)});
            PolygonBuilderBase.this.failed = true;
        }
    };

    protected abstract IRenderCommand createVertexCommand(D var1);

    protected abstract D onCombine(double[] var1, List<CombineData<D>> var2);

    public PolygonBuilderBase() {
        this.tesselator.gluBeginPolygon();
        this.tesselator.gluTessProperty(100140, 100131.0);
        this.started = true;
        this.tesselator.gluTessCallback(100100, this.collector);
        this.tesselator.gluTessCallback(100102, this.collector);
        this.tesselator.gluTessCallback(100101, this.collector);
        this.tesselator.gluTessCallback(100105, this.collector);
        this.tesselator.gluTessCallback(100103, this.collector);
    }

    @Override
    public void addPoint(P point) {
        if (!this.failed) {
            double[] coords = this.createCoords(point);
            D data = this.convertToData(point);
            this.tesselator.gluTessVertex(coords, 0, data);
        }
    }

    protected abstract double[] createCoords(P var1);

    protected abstract D convertToData(P var1);

    private static IRenderCommand createCompositeCommand(final List<IRenderCommand> commands) {
        return new IRenderCommand(){

            @Override
            public void execute(RenderState renderState) {
                for (IRenderCommand command : commands) {
                    command.execute(renderState);
                }
            }
        };
    }

    private static IRenderCommand createRenderBeginCommand(final int type) {
        return new IRenderCommand(){

            @Override
            public void execute(RenderState renderState) {
                GL11.glBegin((int)type);
            }
        };
    }

    @Override
    public IRenderCommand build() {
        Preconditions.checkState((boolean)this.started, (Object)"Builder already finished");
        this.tesselator.gluEndPolygon();
        this.started = this.failed;
        return this.failed ? NULL_COMMAND : PolygonBuilderBase.createCompositeCommand(this.commands);
    }

    public static class CombineData<D> {
        public final D object;
        public final float weight;

        public CombineData(D object, float weight) {
            this.object = object;
            this.weight = weight;
        }
    }
}

