/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.utils.TransportUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeExtensionListener {
    private final Map<World, HashSet<PipeExtensionRequest>> requests = new HashMap<World, HashSet<PipeExtensionRequest>>();

    public void requestPipeExtension(ItemStack stack, World world, int x, int y, int z, ForgeDirection o, IStripesActivator h) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.requests.containsKey(world)) {
            this.requests.put(world, new HashSet());
        }
        PipeExtensionRequest r = new PipeExtensionRequest();
        r.stack = stack;
        r.x = x;
        r.y = y;
        r.z = z;
        r.o = o;
        r.h = h;
        this.requests.get(world).add(r);
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.requests.containsKey(event.world)) {
            HashSet<PipeExtensionRequest> rSet = this.requests.get(event.world);
            World w = event.world;
            for (PipeExtensionRequest r : rSet) {
                Position target = new Position(r.x, r.y, r.z);
                target.orientation = r.o;
                boolean retract = r.stack.func_77973_b() == BuildCraftTransport.pipeItemsVoid;
                ArrayList removedPipeStacks = null;
                if (retract) {
                    target.moveBackwards(1.0);
                    if (w.func_147439_a((int)target.x, (int)target.y, (int)target.z) != BuildCraftTransport.genericPipeBlock) {
                        r.h.sendItem(r.stack, r.o.getOpposite());
                        continue;
                    }
                    target.moveBackwards(1.0);
                    if (w.func_147439_a((int)target.x, (int)target.y, (int)target.z) != BuildCraftTransport.genericPipeBlock) {
                        r.h.sendItem(r.stack, r.o.getOpposite());
                        continue;
                    }
                    target.moveForwards(1.0);
                } else {
                    target.moveForwards(1.0);
                    if (!w.func_147437_c((int)target.x, (int)target.y, (int)target.z)) {
                        r.h.sendItem(r.stack, r.o.getOpposite());
                        continue;
                    }
                }
                Block oldBlock = w.func_147439_a(r.x, r.y, r.z);
                int oldMeta = w.func_72805_g(r.x, r.y, r.z);
                NBTTagCompound nbt = new NBTTagCompound();
                w.func_147438_o(r.x, r.y, r.z).func_145841_b(nbt);
                w.func_147468_f(r.x, r.y, r.z);
                boolean failedPlacement = false;
                if (retract) {
                    removedPipeStacks = w.func_147439_a((int)target.x, (int)target.y, (int)target.z).getDrops(w, (int)target.x, (int)target.y, (int)target.z, w.func_72805_g((int)target.x, (int)target.y, (int)target.z), 0);
                    w.func_147468_f((int)target.x, (int)target.y, (int)target.z);
                } else if (!r.stack.func_77973_b().func_77648_a(r.stack, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)w, r.x, r.y, r.z).get(), w, r.x, r.y, r.z, 1, 0.0f, 0.0f, 0.0f)) {
                    failedPlacement = true;
                    target.moveBackwards(1.0);
                }
                nbt.func_74768_a("x", (int)target.x);
                nbt.func_74768_a("y", (int)target.y);
                nbt.func_74768_a("z", (int)target.z);
                TileGenericPipe pipeTile = (TileGenericPipe)TileEntity.func_145827_c((NBTTagCompound)nbt);
                w.func_147465_d((int)target.x, (int)target.y, (int)target.z, oldBlock, oldMeta, 3);
                w.func_147455_a((int)target.x, (int)target.y, (int)target.z, (TileEntity)pipeTile);
                pipeTile.func_145834_a(w);
                pipeTile.func_145829_t();
                pipeTile.func_145845_h();
                PipeTransportItems items = (PipeTransportItems)pipeTile.pipe.transport;
                if (!retract && !failedPlacement) {
                    --r.stack.field_77994_a;
                }
                if (r.stack.field_77994_a > 0) {
                    this.sendItem(items, r.stack, r.o.getOpposite());
                }
                if (removedPipeStacks != null) {
                    for (ItemStack s : removedPipeStacks) {
                        this.sendItem(items, s, r.o.getOpposite());
                    }
                }
                if (retract || failedPlacement) continue;
                TileGenericPipe newPipeTile = (TileGenericPipe)w.func_147438_o(r.x, r.y, r.z);
                newPipeTile.func_145845_h();
                pipeTile.scheduleNeighborChange();
                if (pipeTile.getPipe() == null) continue;
                ((Pipe)pipeTile.getPipe()).scheduleWireUpdate();
            }
            rSet.clear();
        }
    }

    private void sendItem(PipeTransportItems transport, ItemStack itemStack, ForgeDirection direction) {
        TravelingItem newItem = TravelingItem.make((double)transport.container.field_145851_c + 0.5, (float)transport.container.field_145848_d + TransportUtils.getPipeFloorOf(itemStack), (double)transport.container.field_145849_e + 0.5, itemStack);
        transport.injectItem(newItem, direction);
    }

    private class PipeExtensionRequest {
        public ItemStack stack;
        public int x;
        public int y;
        public int z;
        public ForgeDirection o;
        public IStripesActivator h;

        private PipeExtensionRequest() {
        }
    }
}

