/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import erogenousbeef.bigreactors.common.BigReactors;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;

public class BigReactorsTickHandler {
    protected HashMap<Integer, Queue<ChunkCoordIntPair>> chunkRegenMap;
    protected static final long maximumDeltaTimeNanoSecs = 16000000L;

    public void addRegenChunk(int dimensionId, ChunkCoordIntPair chunkCoord) {
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new HashMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionId)) {
            LinkedList<ChunkCoordIntPair> list = new LinkedList<ChunkCoordIntPair>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionId, list);
        } else if (!this.chunkRegenMap.get(dimensionId).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionId).add(chunkCoord);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            if (this.chunkRegenMap == null) {
                return;
            }
            if (event.world.field_72995_K) {
                return;
            }
            int dimensionId = event.world.field_73011_w.field_76574_g;
            if (this.chunkRegenMap.containsKey(dimensionId)) {
                ChunkCoordIntPair nextChunk;
                Queue<ChunkCoordIntPair> chunksToGen = this.chunkRegenMap.get(dimensionId);
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    Random fmlRandom = new Random(event.world.func_72905_C());
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ event.world.func_72905_C());
                    BigReactors.worldGenerator.generateChunk(fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b, event.world);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionId);
                }
            }
        }
    }
}

