/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.entity;

import cofh.api.energy.EnergyStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import net.minecraft.nbt.NBTTagCompound;

public class GenericEnergyStorageTileEntity
extends GenericTileEntity {
    public static final String CMD_GETENERGY = "getEnergy";
    public static final String CLIENTCMD_GETENERGY = "getEnergy";
    protected EnergyStorage storage;
    private static int currentRF = 0;
    private int requestRfDelay = 3;

    public void modifyEnergyStored(int energy) {
        this.storage.modifyEnergyStored(energy);
    }

    public GenericEnergyStorageTileEntity(int maxEnergy, int maxReceive) {
        this.storage = new EnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
    }

    public GenericEnergyStorageTileEntity(int maxEnergy, int maxReceive, int maxExtract) {
        this.storage = new EnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
        this.storage.setMaxExtract(maxExtract);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }

    public static int getCurrentRF() {
        return currentRF;
    }

    public static void setCurrentRF(int currentRF) {
        GenericEnergyStorageTileEntity.currentRF = currentRF;
    }

    public void requestRfFromServer(SimpleNetworkWrapper network) {
        --this.requestRfDelay;
        if (this.requestRfDelay > 0) {
            return;
        }
        this.requestRfDelay = 3;
        network.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getEnergy", "getEnergy", new Argument[0]));
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getEnergy".equals(command)) {
            return this.storage.getEnergyStored();
        }
        return null;
    }

    @Override
    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getEnergy".equals(command)) {
            GenericEnergyStorageTileEntity.setCurrentRF(result);
            return true;
        }
        return false;
    }
}

