/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.RareTreeGen;
import mods.natura.worldgen.WillowGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class OverworldSapling
extends BlockSapling {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"maple", "silverbell", "purpleheart", "tiger", "willow"};

    public OverworldSapling() {
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block blockID = world.func_147439_a(x, y, z);
        return blockID == Blocks.field_150350_a || blockID.func_149688_o().func_76222_j();
    }

    public boolean canThisPlantGrowOnThisBlock(Block id) {
        return id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150425_aM || id == Blocks.field_150424_aL || id == NContent.taintedSoil;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Block soil = world.func_147439_a(x, y - 1, z);
                return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        super.func_149674_a(world, x, y, z, random);
        int md = world.func_72805_g(x, y, z);
        if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
            if ((md & 8) == 0) {
                world.func_72921_c(x, y, z, md | 8, 4);
            } else {
                this.func_149878_d(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 8 % this.icons.length];
    }

    public void func_149879_c(World p_149879_1_, int p_149879_2_, int p_149879_3_, int p_149879_4_, Random p_149879_5_) {
        int l = p_149879_1_.func_72805_g(p_149879_2_, p_149879_3_, p_149879_4_);
        if ((l & 8) == 0) {
            p_149879_1_.func_72921_c(p_149879_2_, p_149879_3_, p_149879_4_, l | 8, 4);
        } else {
            this.func_149878_d(p_149879_1_, p_149879_2_, p_149879_3_, p_149879_4_, p_149879_5_);
        }
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z) % 8;
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
        WorldGenerator obj = null;
        obj = md == 1 ? new RareTreeGen(true, 4, 2, 1, 1) : (md == 2 ? new RareTreeGen(true, 9, 8, 2, 2) : (md == 3 ? new RareTreeGen(true, 6, 4, 3, 3) : (md == 4 ? new WillowGen(true) : new RareTreeGen(true, 4, 2, 0, 0))));
        if (!obj.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, md + 8, 3);
        }
    }

    public int func_149692_a(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.icons.length; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_1_.field_73012_v.nextFloat() < 0.45;
    }

    public void func_149853_b(World p_149853_1_, Random p_149853_2_, int p_149853_3_, int p_149853_4_, int p_149853_5_) {
        this.func_149879_c(p_149853_1_, p_149853_3_, p_149853_4_, p_149853_5_, p_149853_2_);
    }
}

