/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigType;
import latmod.lib.ByteIOStream;
import latmod.lib.LMStringUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.annotations.INumberBoundsContainer;

public class ConfigEntryDouble
extends ConfigEntry
implements INumberBoundsContainer {
    public double defValue;
    private double value;
    private Double minValue;
    private Double maxValue;

    public ConfigEntryDouble(String id, double d) {
        super(id);
        this.defValue = d;
        this.set(d);
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.DOUBLE;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Double.valueOf(min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Double.valueOf(max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue;
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue;
    }

    public void set(double v) {
        this.value = MathHelperLM.clamp(v, this.getMin(), this.getMax());
    }

    public double get() {
        return this.value;
    }

    public void add(double v) {
        this.set(this.get() + v);
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(o.getAsDouble());
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.get());
    }

    @Override
    public void write(ByteIOStream io) {
        io.writeDouble(this.get());
    }

    @Override
    public void read(ByteIOStream io) {
        this.set(io.readDouble());
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        this.write(io);
        io.writeDouble(this.defValue);
        io.writeDouble(this.getMin());
        io.writeDouble(this.getMax());
    }

    @Override
    public void readExtended(ByteIOStream io) {
        this.read(io);
        this.defValue = io.readDouble();
        double min = io.readDouble();
        double max = io.readDouble();
        this.setBounds(min, max);
    }

    @Override
    public String getAsString() {
        return Double.toString(this.get());
    }

    @Override
    public int getAsInt() {
        return (int)this.get();
    }

    @Override
    public double getAsDouble() {
        return this.get();
    }

    @Override
    public String getDefValueString() {
        return Double.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }
}

