/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import latmod.lib.github.GitHubAPI;
import latmod.lib.github.GitHubCommit;
import latmod.lib.github.GitHubRepo;
import latmod.lib.util.FinalIDObject;

public class GitHubBranch
extends FinalIDObject {
    public final GitHubRepo repo;
    private Map<String, GitHubCommit> commits;

    public GitHubBranch(GitHubRepo r, JsonObject o) {
        super(o.get("name").getAsString());
        this.repo = r;
    }

    public Map<String, GitHubCommit> getCommits() {
        if (this.commits == null) {
            LinkedHashMap<String, GitHubCommit> map = new LinkedHashMap<String, GitHubCommit>();
            try {
                JsonArray a = GitHubAPI.getAPI("repos/" + this.repo.getID() + "/commits?sha=" + this.getID()).getAsJsonArray();
                for (JsonElement e : a) {
                    GitHubCommit b = new GitHubCommit(this, e.getAsJsonObject());
                    map.put(b.getID(), b);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.commits = Collections.unmodifiableMap(map);
        }
        return this.commits;
    }

    public String getFilePath(String s) {
        return "https://raw.githubusercontent.com/" + this.repo.getID() + "/" + this.getID() + "/" + s;
    }

    public String getZipDownloadURL() {
        return "https://github.com/" + this.repo.getID() + "/archive/" + this.getID() + ".zip";
    }
}

