/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Map;
import openmods.datastore.IDataVisitor;
import openmods.network.event.EventDirection;
import openmods.network.event.INetworkEventType;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventCustomType;
import openmods.network.event.NetworkEventMeta;

public class NetworkEventRegistry
implements IDataVisitor<String, Integer> {
    private final TIntObjectHashMap<INetworkEventType> idToType = new TIntObjectHashMap();
    private final Map<Class<? extends NetworkEvent>, Integer> clsToId = Maps.newIdentityHashMap();

    int getIdForClass(Class<? extends NetworkEvent> cls) {
        Integer result = this.clsToId.get(cls);
        Preconditions.checkNotNull((Object)result, (String)"Class %s is not registered", (Object[])new Object[]{cls});
        return result;
    }

    INetworkEventType getTypeForId(int id) {
        INetworkEventType result = (INetworkEventType)this.idToType.get(id);
        Preconditions.checkNotNull((Object)result, (String)"Id %s is not registered", (Object[])new Object[]{id});
        return result;
    }

    @Override
    public void begin(int size) {
        this.idToType.clear();
        this.clsToId.clear();
    }

    public static INetworkEventType createPacketType(final Class<? extends NetworkEvent> cls) {
        EventDirection direction;
        boolean isCompressed;
        boolean isChunked;
        NetworkEventMeta meta = cls.getAnnotation(NetworkEventMeta.class);
        NetworkEventCustomType customType = cls.getAnnotation(NetworkEventCustomType.class);
        if (customType != null) {
            Preconditions.checkState((meta == null ? 1 : 0) != 0, (Object)"NetworkEventMeta and NetworkEventCustomType are mutually exclusive");
            try {
                return customType.value().newInstance();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (meta != null) {
            isChunked = meta.chunked();
            isCompressed = meta.compressed();
            direction = meta.direction();
        } else {
            isChunked = false;
            isCompressed = false;
            direction = EventDirection.ANY;
        }
        return new INetworkEventType(){

            @Override
            public boolean isCompressed() {
                return isCompressed;
            }

            @Override
            public boolean isChunked() {
                return isChunked;
            }

            @Override
            public EventDirection getDirection() {
                return direction;
            }

            @Override
            public NetworkEvent createPacket() {
                try {
                    return (NetworkEvent)((Object)cls.newInstance());
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    @Override
    public void entry(String clsKey, Integer eventId) {
        Class<?> candidateCls;
        try {
            candidateCls = Class.forName(clsKey);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Can't find class %s", clsKey), e);
        }
        Preconditions.checkArgument((boolean)NetworkEvent.class.isAssignableFrom(candidateCls));
        Class<?> cls = candidateCls;
        INetworkEventType type = NetworkEventRegistry.createPacketType(cls);
        this.idToType.put(eventId.intValue(), (Object)type);
        this.clsToId.put(cls, eventId);
    }

    @Override
    public void end() {
    }
}

