/*
 * Decompiled with CFR 0.152.
 */
package openmods.stencil;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import openmods.stencil.FramebufferConstants;

public class FramebufferBase {
    private int framebufferObject = -1;
    private int allocatedDepthBuffer = -1;
    private int allocatedStencilBuffer = -1;
    private int allocatedTexture = -1;
    private int usedDepthBuffer = -1;
    private int usedStencilBuffer = -1;
    private int usedTexture = -1;

    protected void useExternalTexture(int texture) {
        Preconditions.checkState((this.allocatedTexture == -1 ? 1 : 0) != 0, (Object)"Trying to change texture, but one is already allocated");
        this.usedTexture = texture;
    }

    protected boolean isTextureUsed(int texture) {
        return this.usedTexture == texture;
    }

    protected void useExternalStencilBuffer(int buffer) {
        Preconditions.checkState((this.allocatedStencilBuffer == -1 ? 1 : 0) != 0, (Object)"Trying to change stencil buffer, but one is already allocated");
        this.usedStencilBuffer = buffer;
    }

    protected boolean isStencilBufferUsed(int buffer) {
        return this.usedStencilBuffer == buffer;
    }

    protected void useExternalDepthBuffer(int buffer) {
        Preconditions.checkState((this.allocatedDepthBuffer == -1 ? 1 : 0) != 0, (Object)"Trying to change depth buffer, but one is already allocated");
        this.usedDepthBuffer = buffer;
    }

    protected boolean isDepthBufferUsed(int buffer) {
        return this.usedDepthBuffer == buffer;
    }

    protected void allocateStencilBuffer(int format, int width, int height) {
        Preconditions.checkState((this.allocatedStencilBuffer == -1 ? 1 : 0) != 0, (Object)"Stencil buffer already allocated");
        this.usedStencilBuffer = this.allocatedStencilBuffer = OpenGlHelper.func_153185_f();
        OpenGlHelper.func_153176_h((int)OpenGlHelper.field_153199_f, (int)this.allocatedStencilBuffer);
        OpenGlHelper.func_153186_a((int)OpenGlHelper.field_153199_f, (int)format, (int)width, (int)height);
    }

    public boolean isAllocated() {
        return this.framebufferObject > -1;
    }

    public void deallocate() {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        this.unbindFramebuffer();
        if (this.allocatedDepthBuffer > -1) {
            OpenGlHelper.func_153184_g((int)this.allocatedDepthBuffer);
            this.allocatedDepthBuffer = -1;
        }
        if (this.allocatedStencilBuffer > -1) {
            OpenGlHelper.func_153184_g((int)this.allocatedStencilBuffer);
            this.allocatedStencilBuffer = -1;
        }
        if (this.allocatedTexture > -1) {
            TextureUtil.func_147942_a((int)this.allocatedTexture);
            this.allocatedTexture = -1;
        }
        if (this.framebufferObject > -1) {
            OpenGlHelper.func_153174_h((int)this.framebufferObject);
            this.framebufferObject = -1;
            this.usedDepthBuffer = -1;
            this.usedStencilBuffer = -1;
            this.usedTexture = -1;
        }
    }

    protected boolean allocate() {
        if (!OpenGlHelper.func_148822_b()) {
            return false;
        }
        Preconditions.checkState((this.usedTexture > -1 ? 1 : 0) != 0, (Object)"Texture not selected");
        Preconditions.checkState((this.framebufferObject == -1 ? 1 : 0) != 0, (Object)"Framebuffer already allocated");
        this.framebufferObject = OpenGlHelper.func_153165_e();
        this.bindFramebuffer();
        OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)this.usedTexture, (int)0);
        if (this.usedDepthBuffer > -1) {
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)this.usedDepthBuffer);
        }
        if (this.usedStencilBuffer > -1) {
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)FramebufferConstants.GL_STENCIL_ATTACHMENT, (int)OpenGlHelper.field_153199_f, (int)this.usedStencilBuffer);
        }
        int fboStatus = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
        this.unbindFramebuffer();
        boolean result = FramebufferConstants.checkFramebufferComplete(fboStatus);
        if (!result) {
            OpenGlHelper.func_153174_h((int)this.framebufferObject);
            this.framebufferObject = -1;
        }
        return result;
    }

    public boolean bindFramebuffer() {
        if (!OpenGlHelper.func_148822_b()) {
            return false;
        }
        Preconditions.checkState((this.framebufferObject > -1 ? 1 : 0) != 0, (Object)"FBO not initialized");
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
        return true;
    }

    public void unbindFramebuffer() {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)0);
    }
}

