/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.cropplant;

import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantTall;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class CropPlantTallGeneric
extends CropPlantTall {
    private final ItemSeeds seed;
    private final ArrayList<ItemStack> fruits;

    public CropPlantTallGeneric(ItemSeeds seed) {
        this.seed = seed;
        this.fruits = OreDictHelper.getFruitsFromOreDict(this.getSeed());
    }

    public abstract int transformMeta(int var1);

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack((Item)this.seed);
    }

    @Override
    public Block getBlock() {
        return this.seed.getPlant(null, 0, 0, 0);
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return new ArrayList<ItemStack>(this.fruits);
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        ArrayList<ItemStack> list = this.fruits;
        if (list != null && list.size() > 0) {
            return list.get(rand.nextInt(list.size())).func_77946_l();
        }
        return null;
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            list.add(this.getRandomFruit(rand));
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return (float)(meta > this.maxMetaBottomBlock() ? 2 : 1) * 0.0625f * 13.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBottomIcon(int growthStage) {
        if (growthStage < this.maxMetaBottomBlock()) {
            return this.getPlantIcon(growthStage);
        }
        return this.getPlantIcon(this.maxMetaBottomBlock());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.getBlock().func_149691_a(0, this.transformMeta(growthStage));
    }
}

