/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.items;

import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import com.InfinityRaider.AgriCraft.api.v2.IRake;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemAgricraft;
import com.InfinityRaider.AgriCraft.renderers.items.RenderItemBase;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.WeightedRandom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemHandRake
extends ItemAgricraft
implements IRake {
    private static final int WOOD_VARIANT_META = 0;
    private static final int IRON_VARIANT_META = 1;
    private static final int[] dropChance = new int[]{10, 25};
    private final IIcon[] icons = new IIcon[2];

    public ItemHandRake() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    protected String getInternalName() {
        return "handRake";
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    private int calculateGrowthStage(int toolMeta, int currentWeedMeta, Random random) {
        if (toolMeta == 1) {
            return 0;
        }
        return Math.max(random.nextInt(currentWeedMeta / 2 + 1) - 1, 0) + currentWeedMeta / 2;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        String base = super.func_77667_c(itemStack);
        if (itemStack.func_77960_j() == 0) {
            return base + ".wood";
        }
        if (itemStack.func_77960_j() == 1) {
            return base + ".iron";
        }
        throw new IllegalArgumentException("Unsupported meta value of " + itemStack.func_77960_j() + " for ItemHandRake.");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.handRake"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_77658_a());
        this.icons[0] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_wood");
        this.icons[1] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_iron");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderItemBase getItemRenderer() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta <= 1) {
            return this.icons[meta];
        }
        return null;
    }

    @Override
    public boolean removeWeeds(ICrop crop, ItemStack rake) {
        World world = crop.getTileEntity().func_145831_w();
        int x = crop.getTileEntity().field_145851_c;
        int y = crop.getTileEntity().field_145848_d;
        int z = crop.getTileEntity().field_145849_e;
        if (crop.hasWeed()) {
            ItemStack drop;
            int weedGrowthStage = world.func_72805_g(x, y, z);
            int newWeedGrowthStage = this.calculateGrowthStage(rake.func_77960_j(), weedGrowthStage, world.field_73012_v);
            crop.updateWeed(newWeedGrowthStage);
            if (ConfigurationHandler.rakingDrops && !crop.hasWeed() && world.field_73012_v.nextInt(100) < dropChance[rake.func_77960_j() % dropChance.length] && (drop = ItemDropRegistry.instance().getDrop(world.field_73012_v)) != null && drop.func_77973_b() != null) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, drop);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    public static final class ItemDropRegistry {
        private static ItemDropRegistry INSTANCE;
        private final WeightedRandom<ItemStack> registry = new WeightedRandom();

        private ItemDropRegistry() {
        }

        public static ItemDropRegistry instance() {
            if (INSTANCE == null) {
                INSTANCE = new ItemDropRegistry();
            }
            return INSTANCE;
        }

        public void registerDrop(ItemStack stack, int weight) {
            this.registry.addEntry(stack, weight);
        }

        public void removeDrop(ItemStack stack) {
            this.registry.removeEntry(stack);
        }

        public ItemStack getDrop(Random rand) {
            return this.registry.getRandomEntry(rand).func_77946_l();
        }

        public int getWeight(ItemStack stack) {
            return this.registry.getWeight(stack);
        }

        static {
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150329_H, 1, 1), 20);
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150329_H, 1, 2), 10);
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150398_cm, 1, 2), 10);
        }
    }
}

