/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.tile.TileEntitySmasher;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.MutablePair;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class FSPIntegration
extends AbstractIntegrationThread {
    FSPIntegration() {
        super("Flaxbeard's Steam Power");
    }

    @Override
    public String call() {
        try {
            this.fixCrucibleRecipes();
            this.fixRockCrusherRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All this steam...";
    }

    private void fixCrucibleRecipes() {
        for (MutablePair liquidRecipe : SteamcraftRegistry.liquidRecipes.values()) {
            CrucibleLiquid crucibleLiquid = (CrucibleLiquid)liquidRecipe.getLeft();
            crucibleLiquid.ingot = this.resourceHandler.getMainItemStack(crucibleLiquid.ingot);
            crucibleLiquid.nugget = this.resourceHandler.getMainItemStack(crucibleLiquid.nugget);
            crucibleLiquid.plate = this.resourceHandler.getMainItemStack(crucibleLiquid.plate);
        }
    }

    private void fixRockCrusherRecipes() {
        Map oreDicts = TileEntitySmasher.REGISTRY.oreDicts;
        for (String oreDictName : oreDicts.keySet()) {
            oreDicts.put(oreDictName, this.resourceHandler.getMainItemStack((ItemStack)oreDicts.get(oreDictName)));
        }
    }
}

