/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import vswe.stevescarts.Helpers.ComponentTypes;
import vswe.stevescarts.Helpers.EntityEasterEgg;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.StevesCarts;

public class ItemCartComponent
extends Item {
    private IIcon[] icons;
    private IIcon unknownIcon;

    public static int size() {
        return ComponentTypes.values().length;
    }

    public ItemCartComponent() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(StevesCarts.tabsSC2Components);
    }

    private String getName(int dmg) {
        return ComponentTypes.values()[dmg].getName();
    }

    public String getName(ItemStack par1ItemStack) {
        if (par1ItemStack == null || par1ItemStack.func_77960_j() < 0 || par1ItemStack.func_77960_j() >= ItemCartComponent.size() || this.getName(par1ItemStack.func_77960_j()) == null) {
            return "Unknown SC2 Component";
        }
        return this.getName(par1ItemStack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        if (dmg < 0 || dmg >= this.icons.length || this.icons[dmg] == null) {
            return this.unknownIcon;
        }
        return this.icons[dmg];
    }

    private String getRawName(int i) {
        return this.getName(i).replace(":", "").replace(" ", "_").toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[ItemCartComponent.size()];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.getName(i) == null) continue;
            this.icons[i] = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + this.getRawName(i) + "_icon");
        }
        this.unknownIcon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "unknown_icon");
    }

    public String func_77667_c(ItemStack item) {
        if (item == null || item.func_77960_j() < 0 || item.func_77960_j() >= ItemCartComponent.size() || this.getName(item.func_77960_j()) == null) {
            return this.func_77658_a();
        }
        return "item.SC2:" + this.getRawName(item.func_77960_j());
    }

    public String func_77658_a() {
        return "item.SC2:unknowncomponent";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack == null || par1ItemStack.func_77960_j() < 0 || par1ItemStack.func_77960_j() >= ItemCartComponent.size() || this.getName(par1ItemStack.func_77960_j()) == null) {
            if (par1ItemStack != null && par1ItemStack.func_77973_b() instanceof ItemCartComponent) {
                par3List.add("Component id " + par1ItemStack.func_77960_j());
            } else {
                par3List.add("Unknown component id");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < ItemCartComponent.size(); ++i) {
            ItemStack iStack = new ItemStack(par1, 1, i);
            if (!this.isValid(iStack)) continue;
            par3List.add(iStack);
        }
    }

    public boolean isValid(ItemStack item) {
        if (item == null || !(item.func_77973_b() instanceof ItemCartComponent) || this.getName(item.func_77960_j()) == null) {
            return false;
        }
        if (item.func_77960_j() >= 50 && item.func_77960_j() < 58) {
            return StevesCarts.isChristmas;
        }
        if (item.func_77960_j() >= 66 && item.func_77960_j() < 72) {
            return StevesCarts.isEaster;
        }
        return item.func_77960_j() < 72 || item.func_77960_j() >= 80;
    }

    public static ItemStack getWood(int type, boolean isLog) {
        return ItemCartComponent.getWood(type, isLog, 1);
    }

    public static ItemStack getWood(int type, boolean isLog, int count) {
        return new ItemStack((Item)ModItems.component, count, 72 + type * 2 + (isLog ? 0 : 1));
    }

    public static boolean isWoodLog(ItemStack item) {
        if (item != null && item.func_77960_j() >= 72 && item.func_77960_j() < 80) {
            return (item.func_77960_j() - 72) % 2 == 0;
        }
        return false;
    }

    public static boolean isWoodTwig(ItemStack item) {
        if (item != null && item.func_77960_j() >= 72 && item.func_77960_j() < 80) {
            return (item.func_77960_j() - 72) % 2 == 1;
        }
        return false;
    }

    private boolean isEdibleEgg(ItemStack item) {
        return item != null && item.func_77960_j() >= 66 && item.func_77960_j() < 70;
    }

    private boolean isThrowableEgg(ItemStack item) {
        return item != null && item.func_77960_j() == 70;
    }

    public ItemStack func_77654_b(ItemStack item, World world, EntityPlayer player) {
        if (this.isEdibleEgg(item)) {
            if (item.func_77960_j() == 66) {
                world.func_72876_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.1f, false);
            } else if (item.func_77960_j() == 67) {
                player.func_70015_d(5);
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 600, 0));
                }
            } else if (item.func_77960_j() == 68) {
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 50, 2));
                }
            } else if (item.func_77960_j() == 69) {
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 300, 4));
                }
            } else if (item.func_77960_j() == 70) {
                // empty if block
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            player.func_71024_bL().func_75122_a(2, 0.0f);
            return item;
        }
        return super.func_77654_b(item, world, player);
    }

    public int func_77626_a(ItemStack item) {
        return this.isEdibleEgg(item) ? 32 : super.func_77626_a(item);
    }

    public EnumAction func_77661_b(ItemStack item) {
        return this.isEdibleEgg(item) ? EnumAction.eat : super.func_77661_b(item);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (this.isEdibleEgg(item)) {
            player.func_71008_a(item, this.func_77626_a(item));
            return item;
        }
        if (this.isThrowableEgg(item)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityEasterEgg(world, (EntityLivingBase)player));
            }
            return item;
        }
        return super.func_77659_a(item, world, player);
    }
}

