/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.network;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.network.packet.CustomPacket;
import ganymedes01.headcrumbs.network.packet.TextureRequestPacket;
import ganymedes01.headcrumbs.network.packet.TextureSendPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public final class PacketHandler {
    private static Codec CODEC;
    private static final EnumMap<Side, FMLEmbeddedChannel> CHANNELS;

    public static void init() {
        if (!CHANNELS.isEmpty()) {
            return;
        }
        CODEC = new Codec();
        for (PacketType packet : PacketType.values()) {
            CODEC.addDiscriminator(packet.ordinal(), packet.cls);
        }
        CHANNELS.putAll(NetworkRegistry.INSTANCE.newChannel("headcrumbs", new ChannelHandler[]{CODEC, new HandlerServer()}));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLEmbeddedChannel channel = CHANNELS.get(Side.CLIENT);
            String codecName = channel.findChannelHandlerNameForType(Codec.class);
            channel.pipeline().addAfter(codecName, "ClientHandler", (ChannelHandler)new HandlerClient());
        }
    }

    public static void register(int id, Class<? extends CustomPacket> packetType) {
        CODEC.addDiscriminator(id, packetType);
    }

    public static FMLEmbeddedChannel getClientChannel() {
        return CHANNELS.get(Side.CLIENT);
    }

    public static FMLEmbeddedChannel getServerChannel() {
        return CHANNELS.get(Side.SERVER);
    }

    public static void sendToServer(CustomPacket packet) {
        PacketHandler.getClientChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.getClientChannel().writeAndFlush((Object)packet);
    }

    public static void sendToPlayer(CustomPacket packet, EntityPlayer player) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToAllAround(CustomPacket packet, NetworkRegistry.TargetPoint point) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToDimension(CustomPacket packet, int dimension) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToAll(CustomPacket packet) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static Packet toMcPacket(CustomPacket packet) {
        return CHANNELS.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    static {
        CHANNELS = Maps.newEnumMap(Side.class);
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<CustomPacket> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CustomPacket packet) throws Exception {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.handleServerSide(player.field_70170_p, (EntityPlayer)player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<CustomPacket> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CustomPacket packet) throws Exception {
            Minecraft mc = Minecraft.func_71410_x();
            packet.handleClientSide((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<CustomPacket> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, CustomPacket packet, ByteBuf target) throws Exception {
            packet.writeData(target);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, CustomPacket packet) {
            packet.readData(source);
        }
    }

    public static enum PacketType {
        TEXTURE_REQUEST(TextureRequestPacket.class),
        TEXTURE_SEND(TextureSendPacket.class);

        final Class<? extends CustomPacket> cls;

        private PacketType(Class<? extends CustomPacket> cls) {
            this.cls = cls;
        }
    }
}

