/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.launchertray;

import com.google.common.collect.ArrayListMultimap;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MinecraftTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.server.MinecraftServer") && !transformedName.equals("net.minecraft.client.Minecraft")) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        ArrayListMultimap replacements = ArrayListMultimap.create();
        boolean oneDone = false;
        block0: for (MethodNode method2 : classNode.methods) {
            ListIterator it = method2.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)it.next();
                if (!(instruction instanceof MethodInsnNode)) continue;
                MethodInsnNode realInstruction = (MethodInsnNode)instruction;
                if (!realInstruction.name.equals("handleServerStarted") && !realInstruction.name.equals("onInitializationComplete")) continue;
                AbstractInsnNode insertLoc = (AbstractInsnNode)it.next();
                replacements.put((Object)method2, (Object)new ImmutablePair((Object)insertLoc, (Object)new MethodInsnNode(184, "net/creeperhost/launchertray/OurFunctions", "done", "()V", false)));
                if (oneDone) break block0;
                oneDone = true;
            }
        }
        replacements.asMap().forEach((method, stuff) -> stuff.forEach(replacement -> method.instructions.insertBefore((AbstractInsnNode)replacement.getLeft(), (AbstractInsnNode)replacement.getRight())));
        SafeClassWriter cw = new SafeClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            LaunchClassLoader classLoader = Launch.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, (ClassLoader)classLoader);
                d = Class.forName(type2.replace('/', '.'), false, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }
}

