/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import stevesaddons.api.IHiddenInventory;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuContainerScrap;
import vswe.stevesfactory.components.ComponentMenuCrafting;
import vswe.stevesfactory.components.CraftingSetting;
import vswe.stevesfactory.components.FuzzyMode;
import vswe.stevesfactory.components.IItemBufferElement;
import vswe.stevesfactory.components.IItemBufferSubElement;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.LiquidBufferElement;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotStackInventoryHolder;
import vswe.stevesfactory.components.StackTankHolder;

public class CraftingBufferFluidElement
implements IItemBufferElement,
IItemBufferSubElement {
    private static final ItemStack DUMMY_ITEM = new ItemStack(Item.func_150899_d((int)1), 0, 0);
    private CommandExecutor executor;
    private ComponentMenuCrafting craftingMenu;
    private ComponentMenuContainerScrap scrapMenu;
    private IRecipe recipe;
    private ItemStack result;
    private boolean isCrafting;
    private boolean justRemoved;
    private int overflowBuffer;
    private List<ItemStack> containerItems;
    private static final double SPEED_MULTIPLIER = (double)0.05f;
    private static final Random rand = new Random();
    private List<IInventory> inventories = new ArrayList<IInventory>();

    public CraftingBufferFluidElement(CommandExecutor executor, ComponentMenuCrafting craftingMenu, ComponentMenuContainerScrap scrapMenu) {
        this.executor = executor;
        this.craftingMenu = craftingMenu;
        this.scrapMenu = scrapMenu;
        this.recipe = craftingMenu.getDummy().getRecipe();
        this.result = this.recipe == null ? null : this.recipe.func_77572_b((InventoryCrafting)craftingMenu.getDummy());
        this.containerItems = new ArrayList<ItemStack>();
    }

    public void prepareSubElements() {
        this.isCrafting = true;
        this.justRemoved = false;
    }

    public IItemBufferSubElement getSubElement() {
        if (this.isCrafting && this.result != null) {
            this.isCrafting = false;
            return this;
        }
        return null;
    }

    public void removeSubElement() {
    }

    public void releaseSubElements() {
        if (this.result != null) {
            if (this.overflowBuffer > 0) {
                ItemStack stack = this.result.func_77946_l();
                stack.field_77994_a = this.overflowBuffer;
                this.disposeOfExtraItem(stack);
                this.overflowBuffer = 0;
            }
            for (ItemStack containerItem : this.containerItems) {
                this.disposeOfExtraItem(containerItem);
            }
            this.containerItems.clear();
        }
    }

    private void disposeOfExtraItem(ItemStack itemStack) {
        TileEntityManager manager = this.craftingMenu.getParent().getManager();
        List inventories = CommandExecutor.getContainers((TileEntityManager)manager, (ComponentMenu)this.scrapMenu, (ConnectionBlockType)ConnectionBlockType.INVENTORY);
        for (SlotInventoryHolder inventoryHolder : inventories) {
            if (inventoryHolder.getTile() instanceof IHiddenInventory) {
                IHiddenInventory hidden = (IHiddenInventory)inventoryHolder.getTile();
                int moveCount = Math.min(hidden.getInsertable(itemStack), itemStack.field_77994_a);
                if (moveCount <= 0) continue;
                ItemStack toInsert = itemStack.func_77946_l();
                toInsert.field_77994_a = moveCount;
                hidden.insertItemStack(toInsert);
                itemStack.field_77994_a -= moveCount;
                if (itemStack.field_77994_a != 0) continue;
                return;
            }
            IInventory inventory = inventoryHolder.getInventory();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack;
                if (!inventory.func_94041_b(i, itemStack) || (stack = inventory.func_70301_a(i)) != null && (!stack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) || !itemStack.func_77985_e())) continue;
                int itemCountInSlot = stack == null ? 0 : stack.field_77994_a;
                int stackSize = Math.min(itemStack.field_77994_a, Math.min(inventory.func_70297_j_(), itemStack.func_77976_d()) - itemCountInSlot);
                if (stackSize <= 0) continue;
                if (stack == null) {
                    stack = itemStack.func_77946_l();
                    stack.field_77994_a = 0;
                    inventory.func_70299_a(i, stack);
                }
                stack.field_77994_a += stackSize;
                itemStack.field_77994_a -= stackSize;
                inventory.func_70296_d();
                if (itemStack.field_77994_a != 0) continue;
                return;
            }
        }
        double x = (double)manager.field_145851_c + rand.nextDouble() * 0.8 + 0.1;
        double y = (double)manager.field_145851_c + rand.nextDouble() * 0.3 + 1.1;
        double z = (double)manager.field_145851_c + rand.nextDouble() * 0.8 + 0.1;
        EntityItem item = new EntityItem(manager.func_145831_w(), x, y, z, itemStack);
        item.field_70159_w = rand.nextGaussian() * (double)0.05f;
        item.field_70181_x = (rand.nextGaussian() + 4.0) * (double)0.05f;
        item.field_70179_y = rand.nextGaussian() * (double)0.05f;
        manager.func_145831_w().func_72838_d((Entity)item);
    }

    public int retrieveItemCount(int moveCount) {
        return moveCount;
    }

    public void decreaseStackSize(int moveCount) {
    }

    public void remove() {
    }

    public void onUpdate() {
        for (IInventory inventory : this.inventories) {
            if (inventory == null) continue;
            inventory.func_70296_d();
        }
        this.inventories.clear();
    }

    public int getSizeLeft() {
        if (!this.justRemoved) {
            return this.overflowBuffer > 0 ? this.overflowBuffer : (this.findItems(false) ? this.result.field_77994_a : 0);
        }
        this.justRemoved = false;
        return 0;
    }

    public void reduceAmount(int amount) {
        this.justRemoved = true;
        if (this.overflowBuffer > 0) {
            this.overflowBuffer -= amount;
        } else {
            this.findItems(true);
            this.overflowBuffer = this.result.field_77994_a - amount;
        }
        this.isCrafting = true;
    }

    public ItemStack getItemStack() {
        if (this.useAdvancedDetection()) {
            this.findItems(false);
        }
        return this.result;
    }

    private boolean useAdvancedDetection() {
        return this.craftingMenu.getResultItem().getFuzzyMode() != FuzzyMode.PRECISE;
    }

    private boolean findItems(boolean remove) {
        ArrayList<CraftingSetting> settings = new ArrayList<CraftingSetting>();
        for (Setting setting : this.craftingMenu.getSettings()) {
            settings.add((CraftingSetting)setting);
        }
        HashMap<Integer, ItemStack> foundItems = new HashMap<Integer, ItemStack>();
        HashSet<ItemStack> usedStacks = new HashSet<ItemStack>();
        for (ItemBufferElement itemBufferElement : this.executor.itemBuffer) {
            int count = itemBufferElement.retrieveItemCount(9);
            Iterator iterator = itemBufferElement.getSubElements().iterator();
            while (iterator.hasNext()) {
                IItemBufferSubElement itemBufferSubElement = (IItemBufferSubElement)iterator.next();
                ItemStack itemstack = itemBufferSubElement.getItemStack();
                if (usedStacks.contains(itemstack)) continue;
                int subCount = Math.min(count, itemBufferSubElement.getSizeLeft());
                for (int i = 0; i < 9; ++i) {
                    CraftingSetting setting = (CraftingSetting)settings.get(i);
                    if (foundItems.get(i) != null) continue;
                    if (!setting.isValid()) {
                        foundItems.put(i, DUMMY_ITEM);
                        continue;
                    }
                    if (subCount <= 0 || !setting.isEqualForCommandExecutor(itemstack)) continue;
                    foundItems.put(i, itemstack.func_77946_l());
                    if (this.craftingMenu.getDummy().isItemValidForRecipe(this.recipe, (ItemSetting)this.craftingMenu.getResultItem(), foundItems, this.useAdvancedDetection())) {
                        usedStacks.add(itemstack);
                        --subCount;
                        --count;
                        if (!remove) continue;
                        if (itemstack.func_77973_b().hasContainerItem(itemstack)) {
                            this.containerItems.add(itemstack.func_77973_b().getContainerItem(itemstack));
                        }
                        itemBufferElement.decreaseStackSize(1);
                        itemBufferSubElement.reduceAmount(1);
                        if (itemBufferSubElement.getSizeLeft() == 0) {
                            itemBufferSubElement.remove();
                            iterator.remove();
                        }
                        this.inventories.add(((SlotStackInventoryHolder)itemBufferSubElement).getInventory());
                        continue;
                    }
                    foundItems.remove(i);
                }
            }
        }
        if (foundItems.size() < 9) {
            ArrayList<FluidElement> fluids = new ArrayList<FluidElement>();
            for (int i = 0; i < 9; ++i) {
                CraftingSetting setting = (CraftingSetting)settings.get(i);
                if (foundItems.get(i) != null || !CraftingBufferFluidElement.isBucket(setting)) continue;
                boolean newFluid = true;
                for (FluidElement fluidElement : fluids) {
                    if (!fluidElement.bucket.func_77969_a(setting.getItem())) continue;
                    fluidElement.amountToFind += fluidElement.fluid.amount;
                    fluidElement.slots.add(i);
                    newFluid = false;
                }
                if (!newFluid) continue;
                fluids.add(new FluidElement(setting.getItem().func_77946_l(), i));
            }
            if (fluids.size() > 0) {
                for (LiquidBufferElement liquidBufferElement : this.executor.liquidBuffer) {
                    if (fluids.isEmpty()) break;
                    Iterator itr = liquidBufferElement.getHolders().iterator();
                    while (itr.hasNext()) {
                        StackTankHolder tank = (StackTankHolder)itr.next();
                        Iterator fluidItr = fluids.iterator();
                        while (fluidItr.hasNext()) {
                            FluidElement fluidElement = (FluidElement)fluidItr.next();
                            int maxAmount = liquidBufferElement.retrieveItemCount(fluidElement.amountToFind);
                            if (!tank.getFluidStack().isFluidEqual(fluidElement.fluid)) continue;
                            maxAmount = Math.min(maxAmount, tank.getSizeLeft());
                            fluidElement.amountToFind -= maxAmount;
                            if (remove) {
                                tank.reduceAmount(maxAmount);
                                FluidStack toRemove = fluidElement.fluid;
                                toRemove.amount = maxAmount;
                                tank.getTank().drain(tank.getSide(), maxAmount, true);
                            }
                            if (fluidElement.amountToFind != 0) continue;
                            fluidItr.remove();
                            for (int i : fluidElement.slots) {
                                foundItems.put(i, fluidElement.bucket);
                            }
                        }
                        if (tank.getSizeLeft() != 0) continue;
                        itr.remove();
                    }
                }
            }
        }
        if (foundItems.size() == 9) {
            this.result = this.craftingMenu.getDummy().getResult(foundItems);
            this.result = this.result != null ? this.result.func_77946_l() : null;
            return true;
        }
        return false;
    }

    private static boolean isBucket(CraftingSetting setting) {
        return FluidContainerRegistry.isBucket((ItemStack)setting.getItem());
    }

    private static class FluidElement {
        public FluidStack fluid;
        public ItemStack bucket;
        public int amountToFind;
        List<Integer> slots = new ArrayList<Integer>();

        private FluidElement(ItemStack bucket, int i) {
            this.bucket = bucket;
            this.fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
            this.amountToFind = this.fluid.amount;
            this.slots.add(i);
        }
    }
}

