/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class TimerTileEntity
extends GenericTileEntity {
    public static final String CMD_SETDELAY = "setDelay";
    private boolean prevIn = false;
    private int delay = 1;
    private int timer = 0;
    private boolean redstoneOut = false;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void checkStateServer() {
        boolean newout;
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn((int)meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        this.func_70296_d();
        if (pulse) {
            this.timer = this.delay;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.delay;
            newout = true;
        } else {
            newout = false;
        }
        if (newout != this.redstoneOut) {
            this.redstoneOut = newout;
            this.notifyBlockUpdate();
        }
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        return BlockTools.setRedstoneSignalOut((int)meta, (boolean)this.redstoneOut);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut = tagCompound.func_74767_n("rs");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.delay = tagCompound.func_74762_e("delay");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("rs", this.redstoneOut);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("delay", this.delay);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            this.setDelay(args.get("delay").getInteger());
            return true;
        }
        return false;
    }
}

