/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.entity.SyncedObject;
import mcjty.lib.entity.SyncedValue;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.monitor.GuiLiquidMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class LiquidMonitorBlockTileEntity
extends GenericTileEntity {
    private int monitorX = -1;
    private int monitorY = -1;
    private int monitorZ = -1;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;
    private int alarmLevel = 0;
    public static final String CMD_GETADJACENTBLOCKS = "getAdj";
    public static final String CLIENTCMD_ADJACENTBLOCKSREADY = "adjReady";
    private int counter = 20;
    private SyncedValue<Integer> fluidlevel = new SyncedValue((Object)0);
    private SyncedValue<Boolean> inAlarm = new SyncedValue((Object)false);

    public LiquidMonitorBlockTileEntity() {
        this.registerSyncedObject((SyncedObject)this.fluidlevel);
        this.registerSyncedObject((SyncedObject)this.inAlarm);
    }

    public RFMonitorMode getAlarmMode() {
        return this.alarmMode;
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarm(RFMonitorMode mode, int level) {
        this.alarmMode = mode;
        this.alarmLevel = level;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMonitorX() {
        return this.monitorX;
    }

    public int getMonitorY() {
        return this.monitorY;
    }

    public int getMonitorZ() {
        return this.monitorZ;
    }

    public boolean isValid() {
        return this.monitorY >= 0;
    }

    public void setInvalid() {
        this.monitorX = -1;
        this.monitorY = -1;
        this.monitorZ = -1;
        super.setInvalid();
    }

    public void setMonitor(Coordinate c) {
        this.monitorX = c.getX();
        this.monitorY = c.getY();
        this.monitorZ = c.getZ();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getFluidLevel() {
        Integer value = (Integer)this.fluidlevel.getValue();
        if (value == null) {
            return 0;
        }
        return value;
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = (Boolean)this.inAlarm.getValue();
        return BlockTools.setRedstoneSignal((int)meta, (boolean)(value == null ? false : value));
    }

    public List<Coordinate> findAdjacentBlocks() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ArrayList<Coordinate> adjacentBlocks = new ArrayList<Coordinate>();
        for (int dy = -1; dy <= 1; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_72800_K()) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                int zz = z + dz;
                for (int dx = -1; dx <= 1; ++dx) {
                    TileEntity tileEntity;
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0 || !((tileEntity = this.field_145850_b.func_147438_o(xx, yy, zz)) instanceof IFluidHandler)) continue;
                    adjacentBlocks.add(new Coordinate(xx, yy, zz));
                }
            }
        }
        return adjacentBlocks;
    }

    protected void checkStateServer() {
        Boolean v;
        boolean alarmValue;
        if (!this.isValid()) {
            this.counter = 1;
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.monitorX, this.monitorY, this.monitorZ);
        if (!(tileEntity instanceof IFluidHandler)) {
            this.setInvalid();
            return;
        }
        IFluidHandler handler = (IFluidHandler)tileEntity;
        FluidTankInfo[] tankInfo = handler.getTankInfo(ForgeDirection.DOWN);
        long stored = 0L;
        long maxContents = 0L;
        if (tankInfo != null && tankInfo.length > 0) {
            if (tankInfo[0].fluid != null) {
                stored = tankInfo[0].fluid.amount;
            }
            maxContents = tankInfo[0].capacity;
        }
        int ratio = 0;
        boolean alarm = false;
        if (maxContents > 0L) {
            ratio = (int)(1L + stored * 5L / maxContents);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            switch (this.alarmMode) {
                case MODE_OFF: {
                    alarm = false;
                    break;
                }
                case MODE_LESS: {
                    alarm = stored * 100L / maxContents < (long)this.alarmLevel;
                    break;
                }
                case MODE_MORE: {
                    alarm = stored * 100L / maxContents > (long)this.alarmLevel;
                }
            }
        }
        boolean bl = alarmValue = (v = (Boolean)this.inAlarm.getValue()) == null ? false : v;
        if (this.getFluidLevel() != ratio || alarm != alarmValue) {
            this.fluidlevel.setValue((Object)ratio);
            if (alarmValue != alarm) {
                this.inAlarm.setValue((Object)alarm);
            }
            this.notifyBlockUpdate();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.monitorX = tagCompound.func_74762_e("monitorX");
        this.monitorY = tagCompound.func_74762_e("monitorY");
        this.monitorZ = tagCompound.func_74762_e("monitorZ");
        this.inAlarm.setValue((Object)tagCompound.func_74767_n("inAlarm"));
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.fluidlevel.setValue((Object)tagCompound.func_74762_e("fluidlevel"));
        this.alarmMode = RFMonitorMode.getModeFromIndex(tagCompound.func_74771_c("alarmMode"));
        this.alarmLevel = tagCompound.func_74771_c("alarmLevel");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("monitorX", this.monitorX);
        tagCompound.func_74768_a("monitorY", this.monitorY);
        tagCompound.func_74768_a("monitorZ", this.monitorZ);
        Boolean value = (Boolean)this.inAlarm.getValue();
        tagCompound.func_74757_a("inAlarm", value == null ? false : value);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("fluidlevel", this.getFluidLevel());
        tagCompound.func_74774_a("alarmMode", (byte)this.alarmMode.getIndex());
        tagCompound.func_74774_a("alarmLevel", (byte)this.alarmLevel);
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETADJACENTBLOCKS.equals(command)) {
            return this.findAdjacentBlocks();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_ADJACENTBLOCKSREADY.equals(command)) {
            GuiLiquidMonitor.fromServer_clientAdjacentBlocks = new ArrayList<Coordinate>(list);
            return true;
        }
        return false;
    }
}

