/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class ShieldBlock
extends GenericRFToolsBlock
implements Infusable,
IRedstoneConnectable {
    private final int max;

    public ShieldBlock(String blockName, Class<? extends ShieldTEBase> clazz, int max) {
        super(Material.field_151573_f, clazz, true);
        this.func_149663_c(blockName);
        this.func_149647_a(RFTools.tabRfTools);
        this.max = max;
    }

    public int getGuiID() {
        return RFTools.GUI_SHIELD;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ShieldTEBase shieldTileEntity = (ShieldTEBase)tileEntity;
        ShieldContainer shieldContainer = new ShieldContainer(entityPlayer, shieldTileEntity);
        return new GuiShield(shieldTileEntity, shieldContainer);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        list.add(EnumChatFormatting.GREEN + "Supports " + this.max + " blocks");
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This machine forms a shield out of adjacent");
            list.add(EnumChatFormatting.WHITE + "template blocks. It can filter based on type of");
            list.add(EnumChatFormatting.WHITE + "mob and do various things (damage, solid, ...)");
            list.add(EnumChatFormatting.WHITE + "Use the Smart Wrench to add sections to the shield");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(EnumChatFormatting.YELLOW + "increased damage.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new ShieldContainer(entityPlayer, (ShieldTEBase)tileEntity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
        this.setOwner(world, x, y, z, entityLivingBase);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.composeDecomposeShield(world, x, y, z, true);
        }
    }

    protected boolean wrenchUse(World world, int x, int y, int z, EntityPlayer player) {
        this.composeDecomposeShield(world, x, y, z, false);
        return true;
    }

    protected boolean wrenchSneakSelect(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            GlobalCoordinate currentBlock = SmartWrenchItem.getCurrentBlock(player.func_70694_bm());
            if (currentBlock == null) {
                SmartWrenchItem.setCurrentBlock(player.func_70694_bm(), new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g));
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock(player.func_70694_bm(), null);
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    private void composeDecomposeShield(World world, int x, int y, int z, boolean ctrl) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof ShieldTEBase) {
            ((ShieldTEBase)te).composeDecomposeShield(ctrl);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        ShieldTEBase shieldTileEntity;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ShieldTEBase && !world.field_72995_K && (shieldTileEntity = (ShieldTEBase)te).isShieldComposed()) {
            shieldTileEntity.decomposeShield();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineShieldProjector");
    }
}

