/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.DelayQueue;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IItemSpaceControl;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.guis.module.inhand.CraftingModuleInHand;
import logisticspipes.network.guis.module.inpipe.CraftingModuleSlot;
import logisticspipes.network.packets.block.CraftingPipeNextAdvancedSatellitePacket;
import logisticspipes.network.packets.block.CraftingPipePrevAdvancedSatellitePacket;
import logisticspipes.network.packets.cpipe.CPipeNextSatellite;
import logisticspipes.network.packets.cpipe.CPipePrevSatellite;
import logisticspipes.network.packets.cpipe.CPipeSatelliteId;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImport;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.network.packets.cpipe.CraftingAdvancedSatelliteId;
import logisticspipes.network.packets.cpipe.CraftingPipeOpenConnectedGuiPacket;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.pipe.CraftingPipePriorityDownPacket;
import logisticspipes.network.packets.pipe.CraftingPipePriorityUpPacket;
import logisticspipes.network.packets.pipe.CraftingPipeUpdatePacket;
import logisticspipes.network.packets.pipe.CraftingPriority;
import logisticspipes.network.packets.pipe.FluidCraftingAdvancedSatelliteId;
import logisticspipes.network.packets.pipe.FluidCraftingAmount;
import logisticspipes.network.packets.pipe.FluidCraftingPipeAdvancedSatelliteNextPacket;
import logisticspipes.network.packets.pipe.FluidCraftingPipeAdvancedSatellitePrevPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeFluidSatellite;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.proxy.interfaces.IFuzzyRecipeProvider;
import logisticspipes.request.DictCraftingTemplate;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleCrafter
extends LogisticsGuiModule
implements ICraftItems,
IHUDModuleHandler,
IModuleWatchReciver {
    private PipeItemsCraftingLogistics _pipe;
    private IRequestItems _invRequester;
    public int satelliteId = 0;
    public int[] advancedSatelliteIdArray = new int[9];
    public DictResource[] fuzzyCraftingFlagArray = new DictResource[9];
    public DictResource outputFuzzyFlags = new DictResource(null, null);
    public int priority = 0;
    protected ItemIdentifierInventory _dummyInventory = new ItemIdentifierInventory(11, "Requested items", 127);
    protected ItemIdentifierInventory _liquidInventory = new ItemIdentifierInventory(3, "Fluid items", 1, true);
    protected ItemIdentifierInventory _cleanupInventory = new ItemIdentifierInventory(12, "Cleanup Filer Items", 1);
    protected int[] amount = new int[3];
    public int[] liquidSatelliteIdArray = new int[3];
    public int liquidSatelliteId = 0;
    public boolean[] craftingSigns = new boolean[6];
    public boolean waitingForCraft = false;
    private WeakReference<TileEntity> lastAccessedCrafter = new WeakReference<Object>(null);
    public boolean cleanupModeIsExclude = true;
    protected final DelayQueue<DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>> _lostItems = new DelayQueue();
    protected final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    protected SinkReply _sinkReply;
    private boolean cachedAreAllOrderesToBuffer;
    private List<AdjacentTile> _cachedCrafters = null;

    public ModuleCrafter() {
        for (int i = 0; i < this.fuzzyCraftingFlagArray.length; ++i) {
            this.fuzzyCraftingFlagArray[i] = new DictResource(null, null);
        }
    }

    public ModuleCrafter(PipeItemsCraftingLogistics parent) {
        this._pipe = parent;
        this._service = parent;
        this._invRequester = parent;
        this._world = parent;
        this.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
        for (int i = 0; i < this.fuzzyCraftingFlagArray.length; ++i) {
            this.fuzzyCraftingFlagArray[i] = new DictResource(null, null);
        }
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        super.registerHandler(world, service);
        this._invRequester = (IRequestItems)((Object)service);
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        return new SinkReply(this._sinkReply, this.spaceFor(item, includeInTransit), this.areAllOrderesToBuffer() ? SinkReply.BufferMode.DESTINATION_BUFFERED : SinkReply.BufferMode.NONE);
    }

    protected int spaceFor(ItemIdentifier item, boolean includeInTransit) {
        Pair<String, ItemIdentifier> key = new Pair<String, ItemIdentifier>("spaceFor", item);
        Object cache = this._service.getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Inventory, key);
        if (cache != null) {
            int count = (Integer)cache;
            if (includeInTransit) {
                count -= this._service.countOnRoute(item);
            }
            return count;
        }
        int count = 0;
        WorldUtil wUtil = new WorldUtil(this.getWorld(), this._service.getX(), this._service.getY(), this._service.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory)) continue;
            IInventory base = (IInventory)tile.tile;
            if (base instanceof ISidedInventory) {
                base = new SidedInventoryMinecraftAdapter((ISidedInventory)base, tile.orientation.getOpposite(), false);
            }
            ForgeDirection dir = tile.orientation;
            if (this.getUpgradeManager().hasSneakyUpgrade()) {
                dir = this.getUpgradeManager().getSneakyOrientation();
            }
            IInventoryUtil inv = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(base, dir);
            count += inv.roomForItem(item, 9999);
        }
        this._service.getCacheHolder().setCache(CacheHolder.CacheTypes.Inventory, key, count);
        if (includeInTransit) {
            count -= this._service.countOnRoute(item);
        }
        return count;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    public void onAllowedRemoval() {
    }

    @Override
    public void tick() {
        this.enabledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        int rerequested = 0;
        while (lostItem != null && rerequested < 100) {
            SinkReply reply;
            Pair pair = (Pair)lostItem.get();
            if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING) && ((reply = LogisticsManager.canSink(this.getRouter(), null, true, ((ItemIdentifierStack)pair.getValue1()).getItem(), null, true, true)) == null || reply.maxNumberOfItems < 1)) {
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 9000 + (int)(Math.random() * 2000.0)));
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestTree.requestPartial((ItemIdentifierStack)pair.getValue1(), (CoreRoutedPipe)this._service, (IAdditionalTargetInformation)pair.getValue2());
            ++rerequested;
            if (received < ((ItemIdentifierStack)pair.getValue1()).getStackSize()) {
                ((ItemIdentifierStack)pair.getValue1()).setStackSize(((ItemIdentifierStack)pair.getValue1()).getStackSize() - received);
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 4500 + (int)(Math.random() * 1000.0)));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._lostItems.add(new DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>(new Pair<ItemIdentifierStack, IAdditionalTargetInformation>(item, info), 5000L));
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public Set<ItemIdentifier> getSpecificInterests() {
        List<ItemIdentifierStack> result = this.getCraftedItems();
        if (result == null) {
            return null;
        }
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (ItemIdentifierStack craftable : result) {
            l1.add(craftable.getItem());
        }
        return l1;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleCrafter");
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this._service.getItemOrderManager().hasExtras() || tree.hasBeenQueried(this._service.getItemOrderManager())) {
            return;
        }
        IResource requestedItem = tree.getRequestType();
        if (!this.canCraft(requestedItem)) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(requestedItem) && !filter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (LogisticsItemOrder extra : this._service.getItemOrderManager()) {
            if (extra.getType() != IOrderInfoProvider.ResourceType.EXTRA || !extra.getResource().getItem().equals(requestedItem)) continue;
            remaining += extra.getResource().stack.getStackSize();
        }
        if ((remaining -= root.getAllPromissesFor(this, this.getCraftedItem().getItem())) < 1) {
            return;
        }
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            DictResource dict = new DictResource(this.getCraftedItem(), null).loadFromBitSet(this.outputFuzzyFlags.getBitSet());
            LogisticsExtraDictPromise promise = new LogisticsExtraDictPromise(dict, Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(promise);
        } else {
            LogisticsExtraPromise promise = new LogisticsExtraPromise(this.getCraftedItem().getItem(), Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(promise);
        }
        tree.setQueried(this._service.getItemOrderManager());
    }

    @Override
    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (promise instanceof LogisticsExtraDictPromise) {
            this._service.getItemOrderManager().removeExtras(((LogisticsExtraDictPromise)promise).getResource());
        }
        if (promise instanceof LogisticsExtraPromise) {
            this._service.getItemOrderManager().removeExtras(new DictResource(new ItemIdentifierStack(promise.item, promise.numberOfItems), null));
        }
        if (promise instanceof LogisticsDictPromise) {
            this._service.spawnParticle(Particles.WhiteParticle, 2);
            return this._service.getItemOrderManager().addOrder(((LogisticsDictPromise)promise).getResource(), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        this._service.spawnParticle(Particles.WhiteParticle, 2);
        return this._service.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter) {
    }

    @Override
    public IRouter getRouter() {
        return this._service.getRouter();
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._invRequester.itemCouldNotBeSend(item, info);
    }

    @Override
    public int getID() {
        return this._service.getRouter().getSimpleID();
    }

    @Override
    public int compareTo(IRequestItems value2) {
        return 0;
    }

    @Override
    public void registerExtras(IPromise promise) {
        if (promise instanceof LogisticsDictPromise) {
            this._service.getItemOrderManager().addExtra(((LogisticsDictPromise)promise).getResource());
            return;
        }
        ItemIdentifierStack stack = new ItemIdentifierStack(promise.getItemType(), promise.getAmount());
        this._service.getItemOrderManager().addExtra(new DictResource(stack, null));
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        int i;
        List<ItemIdentifierStack> stack = this.getCraftedItems();
        if (stack == null) {
            return null;
        }
        IReqCraftingTemplate template = null;
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            if (toCraft instanceof DictResource) {
                for (ItemIdentifierStack craftable : stack) {
                    DictResource dict = new DictResource(craftable, null);
                    dict.loadFromBitSet(this.outputFuzzyFlags.getBitSet());
                    if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL) || !dict.matches(((DictResource)toCraft).getItem(), IResource.MatchSettings.NORMAL) || !dict.getBitSet().equals(((DictResource)toCraft).getBitSet())) continue;
                    template = new DictCraftingTemplate(dict, this, this.priority);
                    break;
                }
            }
        } else {
            for (ItemIdentifierStack craftable : stack) {
                if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL)) continue;
                template = new ItemCraftingTemplate(craftable, this, this.priority);
                break;
            }
        }
        if (template == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            target[i2] = this;
        }
        boolean hasSatellite = this.isSatelliteConnected();
        if (!hasSatellite) {
            return null;
        }
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r;
            if (this.satelliteId != 0 && (r = this.getSatelliteRouter(-1)) != null) {
                CoreRoutedPipe sat = r.getPipe();
                for (i = 6; i < 9; ++i) {
                    target[i] = sat;
                }
            }
        } else {
            for (int i3 = 0; i3 < 9; ++i3) {
                IRouter r;
                if (this.advancedSatelliteIdArray[i3] == 0 || (r = this.getSatelliteRouter(i3)) == null) continue;
                target[i3] = r.getPipe();
            }
        }
        for (int i4 = 0; i4 < 9; ++i4) {
            ItemIdentifierStack resourceStack = this.getMaterials(i4);
            if (resourceStack == null || resourceStack.getStackSize() == 0) continue;
            IResource req = null;
            if (this.getUpgradeManager().isFuzzyUpgrade() && this.fuzzyCraftingFlagArray[i4].getBitSet().nextSetBit(0) != -1) {
                DictResource dict = new DictResource(resourceStack, target[i4]);
                req = dict;
                dict.loadFromBitSet(this.fuzzyCraftingFlagArray[i4].getBitSet());
            } else {
                req = new ItemResource(resourceStack, target[i4]);
            }
            template.addRequirement(req, new CraftingChassieInformation(i4, this.getPositionInt()));
        }
        int liquidCrafter = this.getUpgradeManager().getFluidCrafter();
        IRequestFluid[] liquidTarget = new IRequestFluid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r;
            if (this.liquidSatelliteId != 0 && (r = this.getFluidSatelliteRouter(-1)) != null) {
                IRequestFluid sat = (IRequestFluid)((Object)r.getPipe());
                for (int i5 = 0; i5 < liquidCrafter; ++i5) {
                    liquidTarget[i5] = sat;
                }
            }
        } else {
            for (i = 0; i < liquidCrafter; ++i) {
                IRouter r;
                if (this.liquidSatelliteIdArray[i] == 0 || (r = this.getFluidSatelliteRouter(i)) == null) continue;
                liquidTarget[i] = (IRequestFluid)((Object)r.getPipe());
            }
        }
        for (i = 0; i < liquidCrafter; ++i) {
            FluidIdentifier liquid = this.getFluidMaterial(i);
            int amount = this.getFluidAmount()[i];
            if (liquid == null || amount <= 0 || liquidTarget[i] == null) continue;
            template.addRequirement(new FluidResource(liquid, amount, liquidTarget[i]), null);
        }
        if (this.getUpgradeManager().hasByproductExtractor() && this.getByproductItem() != null) {
            template.addByproduct(this.getByproductItem());
        }
        return template;
    }

    protected ISlotUpgradeManager getUpgradeManager() {
        if (this._service == null) {
            return null;
        }
        return this._service.getUpgradeManager(this.slot, this.positionInt);
    }

    public boolean isSatelliteConnected() {
        List<ExitRoute> routes = this.getRouter().getIRoutersByCost();
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteId == 0) {
                return true;
            }
            for (PipeItemsSatelliteLogistics satellite : PipeItemsSatelliteLogistics.AllSatellites) {
                PipeItemsSatelliteLogistics satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                IRouter satRouter = satPipe.getRouter();
                for (ExitRoute route : routes) {
                    if (route.destination != satRouter) continue;
                    return true;
                }
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                boolean foundOne = false;
                if (this.advancedSatelliteIdArray[i] == 0) continue;
                block3: for (PipeItemsSatelliteLogistics satellite : PipeItemsSatelliteLogistics.AllSatellites) {
                    PipeItemsSatelliteLogistics satPipe;
                    if (satellite.satelliteId != this.advancedSatelliteIdArray[i] || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                    IRouter satRouter = satPipe.getRouter();
                    for (ExitRoute route : routes) {
                        if (route.destination != satRouter) continue;
                        foundOne = true;
                        continue block3;
                    }
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        if (this.getCraftedItem() == null) {
            return false;
        }
        if (toCraft instanceof ItemResource || toCraft instanceof DictResource) {
            return toCraft.matches(this.getCraftedItem().getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    public List<ItemIdentifierStack> getCraftedItems() {
        ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>(1);
        if (this.getCraftedItem() != null) {
            list.add(this.getCraftedItem());
        }
        return list;
    }

    public ItemIdentifierStack getCraftedItem() {
        return this._dummyInventory.getIDStackInSlot(9);
    }

    @Override
    public int getTodo() {
        return this._service.getItemOrderManager().totalAmountCountInAllOrders();
    }

    protected int getNextConnectSatelliteId(boolean prev, int x) {
        int closestIdFound;
        int n = closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        if (this._service == null) {
            return prev ? Math.max(0, this.satelliteId - 1) : this.satelliteId + 1;
        }
        for (PipeItemsSatelliteLogistics satellite : PipeItemsSatelliteLogistics.AllSatellites) {
            PipeItemsSatelliteLogistics satPipe = satellite;
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || satPipe.isFluidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            List<ExitRoute> routes = this.getRouter().getDistanceTo(satRouter);
            if (routes == null || routes.isEmpty()) continue;
            boolean filterFree = false;
            for (ExitRoute route : routes) {
                if (!route.filters.isEmpty()) continue;
                filterFree = true;
                break;
            }
            if (!filterFree) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.satelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.satelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.advancedSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.advancedSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.satelliteId;
            }
            return this.advancedSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    protected int getNextConnectFluidSatelliteId(boolean prev, int x) {
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (PipeFluidSatellite satellite : PipeFluidSatellite.AllSatellites) {
            PipeFluidSatellite satPipe = satellite;
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || !((CoreUnroutedPipe)satPipe).isFluidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            List<ExitRoute> routes = this.getRouter().getDistanceTo(satRouter);
            if (routes == null || routes.isEmpty()) continue;
            boolean filterFree = false;
            for (ExitRoute route : routes) {
                if (!route.filters.isEmpty()) continue;
                filterFree = true;
                break;
            }
            if (!filterFree) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.liquidSatelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.liquidSatelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.liquidSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.liquidSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.liquidSatelliteId;
            }
            return this.liquidSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    public void setNextSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeNextSatellite.class).setModulePos(this);
            MainProxy.sendPacketToServer(packet);
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(false, -1);
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteId.class).setPipeId(this.satelliteId).setModulePos(this);
            MainProxy.sendPacketToPlayer(packet, player);
        }
    }

    public void setSatelliteId(int satelliteId, int x) {
        if (x == -1) {
            this.satelliteId = satelliteId;
        } else {
            this.advancedSatelliteIdArray[x] = satelliteId;
        }
    }

    public void setPrevSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipePrevSatellite.class).setModulePos(this);
            MainProxy.sendPacketToServer(packet);
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(true, -1);
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteId.class).setPipeId(this.satelliteId).setModulePos(this);
            MainProxy.sendPacketToPlayer(packet, player);
        }
    }

    public IRouter getSatelliteRouter(int x) {
        if (x == -1) {
            for (PipeItemsSatelliteLogistics satellite : PipeItemsSatelliteLogistics.AllSatellites) {
                PipeItemsSatelliteLogistics satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (PipeItemsSatelliteLogistics satellite : PipeItemsSatelliteLogistics.AllSatellites) {
                PipeItemsSatelliteLogistics satPipe;
                if (satellite.satelliteId != this.advancedSatelliteIdArray[x] || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        int i2;
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this._liquidInventory.readFromNBT(nbttagcompound, "FluidInv");
        this._cleanupInventory.readFromNBT(nbttagcompound, "CleanupInv");
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.priority = nbttagcompound.func_74762_e("priority");
        for (i2 = 0; i2 < 9; ++i2) {
            this.advancedSatelliteIdArray[i2] = nbttagcompound.func_74762_e("advancedSatelliteId" + i2);
        }
        if (nbttagcompound.func_74764_b("fuzzyCraftingFlag0")) {
            for (i2 = 0; i2 < 9; ++i2) {
                byte flags = nbttagcompound.func_74771_c("fuzzyCraftingFlag" + i2);
                DictResource dict = this.fuzzyCraftingFlagArray[i2];
                if ((flags & 1) != 0) {
                    dict.use_od = true;
                }
                if ((flags & 2) != 0) {
                    dict.ignore_dmg = true;
                }
                if ((flags & 4) != 0) {
                    dict.ignore_nbt = true;
                }
                if ((flags & 8) == 0) continue;
                dict.use_category = true;
            }
        }
        if (nbttagcompound.func_74764_b("fuzzyFlags")) {
            NBTTagList lst = nbttagcompound.func_150295_c("fuzzyFlags", 10);
            for (int i3 = 0; i3 < 9; ++i3) {
                NBTTagCompound comp = lst.func_150305_b(i3);
                this.fuzzyCraftingFlagArray[i3].ignore_dmg = comp.func_74767_n("ignore_dmg");
                this.fuzzyCraftingFlagArray[i3].ignore_nbt = comp.func_74767_n("ignore_nbt");
                this.fuzzyCraftingFlagArray[i3].use_od = comp.func_74767_n("use_od");
                this.fuzzyCraftingFlagArray[i3].use_category = comp.func_74767_n("use_category");
            }
        }
        if (nbttagcompound.func_74764_b("outputFuzzyFlags")) {
            NBTTagCompound comp = nbttagcompound.func_74775_l("outputFuzzyFlags");
            this.outputFuzzyFlags.ignore_dmg = comp.func_74767_n("ignore_dmg");
            this.outputFuzzyFlags.ignore_nbt = comp.func_74767_n("ignore_nbt");
            this.outputFuzzyFlags.use_od = comp.func_74767_n("use_od");
            this.outputFuzzyFlags.use_category = comp.func_74767_n("use_category");
        }
        for (i = 0; i < 6; ++i) {
            this.craftingSigns[i] = nbttagcompound.func_74767_n("craftingSigns" + i);
        }
        if (nbttagcompound.func_74764_b("FluidAmount")) {
            this.amount = nbttagcompound.func_74759_k("FluidAmount");
        }
        if (this.amount.length < 3) {
            this.amount = new int[3];
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        this.liquidSatelliteId = nbttagcompound.func_74762_e("liquidSatelliteId");
        this.cleanupModeIsExclude = nbttagcompound.func_74767_n("cleanupModeIsExclude");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        int i;
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        this._liquidInventory.writeToNBT(nbttagcompound, "FluidInv");
        this._cleanupInventory.writeToNBT(nbttagcompound, "CleanupInv");
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        nbttagcompound.func_74768_a("priority", this.priority);
        for (int i2 = 0; i2 < 9; ++i2) {
            nbttagcompound.func_74768_a("advancedSatelliteId" + i2, this.advancedSatelliteIdArray[i2]);
        }
        NBTTagList lst = new NBTTagList();
        for (int i3 = 0; i3 < 9; ++i3) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74757_a("ignore_dmg", this.fuzzyCraftingFlagArray[i3].ignore_dmg);
            comp.func_74757_a("ignore_nbt", this.fuzzyCraftingFlagArray[i3].ignore_nbt);
            comp.func_74757_a("use_od", this.fuzzyCraftingFlagArray[i3].use_od);
            comp.func_74757_a("use_category", this.fuzzyCraftingFlagArray[i3].use_category);
            lst.func_74742_a((NBTBase)comp);
        }
        nbttagcompound.func_74782_a("fuzzyFlags", (NBTBase)lst);
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74757_a("ignore_dmg", this.outputFuzzyFlags.ignore_dmg);
        comp.func_74757_a("ignore_nbt", this.outputFuzzyFlags.ignore_nbt);
        comp.func_74757_a("use_od", this.outputFuzzyFlags.use_od);
        comp.func_74757_a("use_category", this.outputFuzzyFlags.use_category);
        nbttagcompound.func_74782_a("outputFuzzyFlags", (NBTBase)comp);
        for (i = 0; i < 6; ++i) {
            nbttagcompound.func_74757_a("craftingSigns" + i, this.craftingSigns[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbttagcompound.func_74768_a("liquidSatelliteIdArray" + i, this.liquidSatelliteIdArray[i]);
        }
        nbttagcompound.func_74783_a("FluidAmount", this.amount);
        nbttagcompound.func_74768_a("liquidSatelliteId", this.liquidSatelliteId);
        nbttagcompound.func_74757_a("cleanupModeIsExclude", this.cleanupModeIsExclude);
    }

    public ModernPacket getCPipePacket() {
        return PacketHandler.getPacket(CraftingPipeUpdatePacket.class).setAmount(this.amount).setLiquidSatelliteIdArray(this.liquidSatelliteIdArray).setLiquidSatelliteId(this.liquidSatelliteId).setSatelliteId(this.satelliteId).setAdvancedSatelliteIdArray(this.advancedSatelliteIdArray).setPriority(this.priority).setModulePos(this);
    }

    public void handleCraftingUpdatePacket(CraftingPipeUpdatePacket packet) {
        this.amount = packet.getAmount();
        this.liquidSatelliteIdArray = packet.getLiquidSatelliteIdArray();
        this.liquidSatelliteId = packet.getLiquidSatelliteId();
        this.satelliteId = packet.getSatelliteId();
        this.advancedSatelliteIdArray = packet.getAdvancedSatelliteIdArray();
        this.priority = packet.getPriority();
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleSlot.class).setAdvancedSat(this.getUpgradeManager().isAdvancedSatelliteCrafter()).setLiquidCrafter(this.getUpgradeManager().getFluidCrafter()).setAmount(this.amount).setHasByproductExtractor(this.getUpgradeManager().hasByproductExtractor()).setFuzzy(this.getUpgradeManager().isFuzzyUpgrade()).setCleanupSize(this.getUpgradeManager().getCrafterCleanup()).setCleanupExclude(this.cleanupModeIsExclude);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleInHand.class).setAmount(this.amount).setCleanupExclude(this.cleanupModeIsExclude);
    }

    public ItemIdentifierInventory getDummyInventory() {
        return this._dummyInventory;
    }

    public ItemIdentifierInventory getFluidInventory() {
        return this._liquidInventory;
    }

    public IInventory getCleanupInventory() {
        return this._cleanupInventory;
    }

    public void setDummyInventorySlot(int slot, ItemStack itemstack) {
        this._dummyInventory.func_70299_a(slot, itemstack);
    }

    public void importFromCraftingTable(EntityPlayer player) {
        if (MainProxy.isClient(this.getWorld())) {
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImport.class).setModulePos(this);
            MainProxy.sendPacketToServer(packet);
        } else {
            WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
            block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
                for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                    if (!provider.importRecipe(tile.tile, this._dummyInventory)) continue;
                    if (!(provider instanceof IFuzzyRecipeProvider)) continue block0;
                    ((IFuzzyRecipeProvider)provider).importFuzzyFlags(tile.tile, this._dummyInventory, this.fuzzyCraftingFlagArray, this.outputFuzzyFlags);
                    continue block0;
                }
            }
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImportBack.class).setInventory(this._dummyInventory).setModulePos(this);
            if (player != null) {
                MainProxy.sendPacketToPlayer(packet, player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.getWorld()), packet);
        }
    }

    protected World getWorld() {
        return this._world.getWorld();
    }

    public void priorityUp(EntityPlayer player) {
        ++this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipePriorityUpPacket.class).setModulePos(this));
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingPriority.class).setInteger(this.priority).setModulePos(this), player);
        }
    }

    public void priorityDown(EntityPlayer player) {
        --this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipePriorityDownPacket.class).setModulePos(this));
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingPriority.class).setInteger(this.priority).setModulePos(this), player);
        }
    }

    public void setPriority(int amount) {
        this.priority = amount;
    }

    public ItemIdentifierStack getByproductItem() {
        return this._dummyInventory.getIDStackInSlot(10);
    }

    public ItemIdentifierStack getMaterials(int slotnr) {
        return this._dummyInventory.getIDStackInSlot(slotnr);
    }

    public FluidIdentifier getFluidMaterial(int slotnr) {
        ItemIdentifierStack stack = this._liquidInventory.getIDStackInSlot(slotnr);
        if (stack == null) {
            return null;
        }
        return FluidIdentifier.get(stack.getItem());
    }

    public void setNextSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipeNextAdvancedSatellitePacket.class).setInteger(i).setModulePos(this));
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.advancedSatelliteIdArray[i]).setModulePos(this), player);
        }
    }

    public void setPrevSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipePrevAdvancedSatellitePacket.class).setInteger(i).setModulePos(this));
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.advancedSatelliteIdArray[i]).setModulePos(this), player);
        }
    }

    public void changeFluidAmount(int change, int slot, EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger(change).setModulePos(this));
        } else {
            int n = slot;
            this.amount[n] = this.amount[n] + change;
            if (this.amount[slot] <= 0) {
                this.amount[slot] = 0;
            }
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger(this.amount[slot]).setModulePos(this), player);
        }
    }

    public void setPrevFluidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FluidCraftingPipeAdvancedSatellitePrevPacket.class).setInteger(i).setModulePos(this));
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectFluidSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.liquidSatelliteId).setModulePos(this), player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectFluidSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.liquidSatelliteIdArray[i]).setModulePos(this), player);
        }
    }

    public void setNextFluidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FluidCraftingPipeAdvancedSatelliteNextPacket.class).setInteger(i).setModulePos(this));
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectFluidSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.liquidSatelliteId).setModulePos(this), player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectFluidSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAdvancedSatelliteId.class).setInteger2(i).setInteger(this.liquidSatelliteIdArray[i]).setModulePos(this), player);
        }
    }

    public void setFluidAmount(int[] amount) {
        if (MainProxy.isClient(this.getWorld())) {
            this.amount = amount;
        }
    }

    public void defineFluidAmount(int integer, int slot) {
        if (MainProxy.isClient(this.getWorld())) {
            this.amount[slot] = integer;
        }
    }

    public int[] getFluidAmount() {
        return this.amount;
    }

    public void setFluidSatelliteId(int integer, int slot) {
        if (slot == -1) {
            this.liquidSatelliteId = integer;
        } else {
            this.liquidSatelliteIdArray[slot] = integer;
        }
    }

    public IRouter getFluidSatelliteRouter(int x) {
        if (x == -1) {
            for (PipeFluidSatellite satellite : PipeFluidSatellite.AllSatellites) {
                PipeFluidSatellite satPipe;
                if (satellite.satelliteId != this.liquidSatelliteId || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (PipeFluidSatellite satellite : PipeFluidSatellite.AllSatellites) {
                PipeFluidSatellite satPipe;
                if (satellite.satelliteId != this.liquidSatelliteIdArray[x] || (satPipe = satellite) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    public void openAttachedGui(EntityPlayer player) {
        int i;
        if (MainProxy.isClient(player.field_70170_p)) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71053_j();
            } else if (player instanceof EntityPlayerSP) {
                ((EntityPlayerSP)player).func_71053_j();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipeOpenConnectedGuiPacket.class).setModulePos(this));
            return;
        }
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            Block block;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                found = tile.tile instanceof IInventory;
            }
            if (!found || (block = this.getWorld().func_147439_a(tile.tile.field_145851_c, tile.tile.field_145848_d, tile.tile.field_145849_e)) == null || !block.func_149727_a(this.getWorld(), tile.tile.field_145851_c, tile.tile.field_145848_d, tile.tile.field_145849_e, player, 0, 0.0f, 0.0f, 0.0f)) continue;
            break;
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    public void enabledUpdateEntity() {
        List<AdjacentTile> crafters;
        if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            if (this._service.isNthTick(6)) {
                this.cacheAreAllOrderesToBuffer();
            }
            if (this._service.getItemOrderManager().isFirstOrderWatched()) {
                TileEntity tile = (TileEntity)this.lastAccessedCrafter.get();
                if (tile != null) {
                    this._service.getItemOrderManager().setMachineProgress(SimpleServiceLocator.machineProgressProvider.getProgressForTile(tile));
                } else {
                    this._service.getItemOrderManager().setMachineProgress((byte)0);
                }
            }
        } else {
            this.cachedAreAllOrderesToBuffer = false;
        }
        if (!this._service.isNthTick(6)) {
            return;
        }
        this.waitingForCraft = false;
        if (!this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            if (this.getUpgradeManager().getCrafterCleanup() > 0) {
                crafters = this.locateCrafters();
                ItemStack extracted = null;
                AdjacentTile tile = null;
                Iterator<AdjacentTile> it = crafters.iterator();
                while (it.hasNext() && ((extracted = this.extractFiltered(tile = it.next(), this._cleanupInventory, this.cleanupModeIsExclude, this.getUpgradeManager().getCrafterCleanup() * 3)) == null || extracted.field_77994_a <= 0)) {
                }
                if (extracted != null && extracted.field_77994_a > 0) {
                    this._service.queueRoutedItem(SimpleServiceLocator.routedItemHelper.createNewTravelItem(extracted), ForgeDirection.UP);
                    this._service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
                }
            }
            return;
        }
        this.waitingForCraft = true;
        crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                this._service.getItemOrderManager().sendFailed();
            }
            return;
        }
        List<ItemIdentifierStack> wanteditem = this.getCraftedItems();
        if (wanteditem == null || wanteditem.isEmpty()) {
            return;
        }
        this._service.spawnParticle(Particles.VioletParticle, 2);
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        block1: while (itemsleft > 0 && stacksleft > 0 && this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            LogisticsItemOrder nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            int maxtosend = Math.min(itemsleft, nextOrder.getResource().stack.getStackSize());
            maxtosend = Math.min(nextOrder.getResource().getItem().getMaxStackSize(), maxtosend);
            ItemStack extracted = null;
            AdjacentTile tile = null;
            Iterator<AdjacentTile> it = crafters.iterator();
            while (it.hasNext() && ((extracted = this.extract(tile = it.next(), nextOrder.getResource(), maxtosend)) == null || extracted.field_77994_a <= 0)) {
            }
            if (extracted == null || extracted.field_77994_a == 0) {
                this._service.getItemOrderManager().deferSend();
                break;
            }
            this._service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            this.lastAccessedCrafter = new WeakReference<TileEntity>(tile.tile);
            ItemIdentifier extractedID = ItemIdentifier.get(extracted);
            while (extracted.field_77994_a > 0) {
                if (!this.doesExtractionMatch(nextOrder, extractedID)) {
                    LogisticsItemOrder startOrder = nextOrder;
                    if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                        do {
                            this._service.getItemOrderManager().deferSend();
                        } while (!this.doesExtractionMatch(nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA), extractedID) && startOrder != nextOrder);
                    }
                    if (startOrder == nextOrder) {
                        int numtosend = Math.min(extracted.field_77994_a, extractedID.getMaxStackSize());
                        if (numtosend == 0) continue block1;
                        --stacksleft;
                        itemsleft -= numtosend;
                        ItemStack stackToSend = extracted.func_77979_a(numtosend);
                        this._service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, null);
                        continue;
                    }
                }
                int numtosend = Math.min(extracted.field_77994_a, extractedID.getMaxStackSize());
                if ((numtosend = Math.min(numtosend, nextOrder.getResource().stack.getStackSize())) == 0) continue block1;
                --stacksleft;
                itemsleft -= numtosend;
                ItemStack stackToSend = extracted.func_77979_a(numtosend);
                if (nextOrder.getDestination() != null) {
                    SinkReply reply = LogisticsManager.canSink(nextOrder.getDestination().getRouter(), null, true, ItemIdentifier.get(stackToSend), null, true, false);
                    boolean defersend = false;
                    if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) {
                        defersend = true;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend);
                    item.setDestination(nextOrder.getDestination().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.setAdditionalTargetInformation(nextOrder.getInformation());
                    this._service.queueRoutedItem(item, tile.orientation);
                    this._service.getItemOrderManager().sendSuccessfull(stackToSend.field_77994_a, defersend, item);
                } else {
                    this._service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, nextOrder.getInformation());
                    this._service.getItemOrderManager().sendSuccessfull(stackToSend.field_77994_a, false, null);
                }
                if (!this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) continue;
                nextOrder = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            }
        }
    }

    private boolean doesExtractionMatch(LogisticsItemOrder nextOrder, ItemIdentifier extractedID) {
        return nextOrder.getResource().getItem().equals(extractedID) || this.getUpgradeManager().isFuzzyUpgrade() && nextOrder.getResource().getBitSet().nextSetBit(0) != -1 && nextOrder.getResource().matches(extractedID, IResource.MatchSettings.NORMAL);
    }

    public boolean areAllOrderesToBuffer() {
        return this.cachedAreAllOrderesToBuffer;
    }

    public void cacheAreAllOrderesToBuffer() {
        boolean result = true;
        for (LogisticsItemOrder order : this._service.getItemOrderManager()) {
            if (order.getDestination() instanceof IItemSpaceControl) {
                SinkReply reply = LogisticsManager.canSink(order.getDestination().getRouter(), null, true, order.getResource().getItem(), null, true, false);
                if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) continue;
                result = false;
                break;
            }
            result = false;
            break;
        }
        this.cachedAreAllOrderesToBuffer = result;
    }

    private ItemStack extract(AdjacentTile tile, IResource item, int amount) {
        if (tile.tile instanceof LogisticsCraftingTableTileEntity) {
            return this.extractFromLogisticsCraftingTable((LogisticsCraftingTableTileEntity)tile.tile, item, amount, tile.orientation);
        }
        if (tile.tile instanceof ISidedInventory) {
            SidedInventoryMinecraftAdapter sidedadapter = new SidedInventoryMinecraftAdapter((ISidedInventory)tile.tile, ForgeDirection.UNKNOWN, true);
            return this.extractFromIInventory(sidedadapter, item, amount, tile.orientation);
        }
        if (tile.tile instanceof IInventory) {
            return this.extractFromIInventory((IInventory)tile.tile, item, amount, tile.orientation);
        }
        return null;
    }

    private ItemStack extractFiltered(AdjacentTile tile, ItemIdentifierInventory inv, boolean isExcluded, int filterInvLimit) {
        if (tile.tile instanceof ISidedInventory) {
            SidedInventoryMinecraftAdapter sidedadapter = new SidedInventoryMinecraftAdapter((ISidedInventory)tile.tile, ForgeDirection.UNKNOWN, true);
            return this.extractFromIInventoryFiltered(sidedadapter, inv, isExcluded, filterInvLimit, tile.orientation);
        }
        if (tile.tile instanceof IInventory) {
            return this.extractFromIInventoryFiltered((IInventory)tile.tile, inv, isExcluded, filterInvLimit, tile.orientation);
        }
        return null;
    }

    private ItemStack extractFromIInventory(IInventory inv, IResource wanteditem, int count, ForgeDirection dir) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, dir);
        ItemIdentifier itemToExtract = null;
        if (wanteditem instanceof ItemResource) {
            itemToExtract = ((ItemResource)wanteditem).getItem();
        } else if (wanteditem instanceof DictResource) {
            int max = Integer.MIN_VALUE;
            ItemIdentifier toExtract = null;
            for (Map.Entry<ItemIdentifier, Integer> content : invUtil.getItemsAndCount().entrySet()) {
                if (!wanteditem.matches(content.getKey(), IResource.MatchSettings.NORMAL) || content.getValue() <= max) continue;
                max = content.getValue();
                toExtract = content.getKey();
            }
            if (toExtract == null) {
                return null;
            }
            itemToExtract = toExtract;
        }
        int available = invUtil.itemCount(itemToExtract);
        if (available == 0) {
            return null;
        }
        if (!this._service.useEnergy(this.neededEnergy() * Math.min(count, available))) {
            return null;
        }
        return invUtil.getMultipleItems(itemToExtract, Math.min(count, available));
    }

    private ItemStack extractFromIInventoryFiltered(IInventory inv, ItemIdentifierInventory filter, boolean isExcluded, int filterInvLimit, ForgeDirection dir) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, dir);
        ItemIdentifier wanteditem = null;
        for (ItemIdentifier item : invUtil.getItemsAndCount().keySet()) {
            ItemIdentifierStack identStack;
            int i;
            boolean found;
            if (isExcluded) {
                found = false;
                for (i = 0; i < filter.func_70302_i_() && i < filterInvLimit; ++i) {
                    identStack = filter.getIDStackInSlot(i);
                    if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                wanteditem = item;
                continue;
            }
            found = false;
            for (i = 0; i < filter.func_70302_i_() && i < filterInvLimit; ++i) {
                identStack = filter.getIDStackInSlot(i);
                if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            wanteditem = item;
        }
        if (wanteditem == null) {
            return null;
        }
        int available = invUtil.itemCount(wanteditem);
        if (available == 0) {
            return null;
        }
        if (!this._service.useEnergy(this.neededEnergy() * Math.min(64, available))) {
            return null;
        }
        return invUtil.getMultipleItems(wanteditem, Math.min(64, available));
    }

    private ItemStack extractFromLogisticsCraftingTable(LogisticsCraftingTableTileEntity tile, IResource wanteditem, int count, ForgeDirection dir) {
        ItemStack stack;
        ItemStack extracted = this.extractFromIInventory(tile, wanteditem, count, dir);
        if (extracted != null) {
            return extracted;
        }
        ItemStack retstack = null;
        while (count > 0 && (stack = tile.getOutput(wanteditem, this._service)) != null && stack.field_77994_a != 0 && !(retstack != null ? !retstack.func_77969_a(stack) || !ItemStack.func_77970_a(retstack, (ItemStack)stack) : !wanteditem.matches(ItemIdentifier.get(stack), wanteditem instanceof ItemResource ? IResource.MatchSettings.WITHOUT_NBT : IResource.MatchSettings.NORMAL)) && this._service.useEnergy(this.neededEnergy() * stack.field_77994_a)) {
            if (retstack == null) {
                retstack = stack;
            } else {
                retstack.field_77994_a += stack.field_77994_a;
            }
            count -= stack.field_77994_a;
            if (!this.getUpgradeManager().isFuzzyUpgrade()) continue;
            break;
        }
        return retstack;
    }

    protected int neededEnergy() {
        return 10;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int stacksToExtract() {
        return 1;
    }

    public List<AdjacentTile> locateCrafters() {
        if (this._cachedCrafters != null) {
            return this._cachedCrafters;
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        LinkedList<AdjacentTile> crafters = new LinkedList<AdjacentTile>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory)) continue;
            crafters.add(tile);
        }
        this._cachedCrafters = crafters;
        return this._cachedCrafters;
    }

    public void clearCraftersCache() {
        this._cachedCrafters = null;
    }

    @Override
    public void clearCache() {
        this.clearCraftersCache();
    }

    public void importCleanup() {
        int i;
        for (i = 0; i < 10; ++i) {
            this._cleanupInventory.func_70299_a(i, this._dummyInventory.func_70301_a(i));
        }
        for (i = 10; i < this._cleanupInventory.func_70302_i_(); ++i) {
            this._cleanupInventory.func_70299_a(i, null);
        }
        this._cleanupInventory.compact_first(10);
        this._cleanupInventory.recheckStackLimit();
        this.cleanupModeIsExclude = false;
    }

    public void toogleCleaupMode() {
        this.cleanupModeIsExclude = !this.cleanupModeIsExclude;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return null;
    }

    public static class CraftingChassieInformation
    extends PipeLogisticsChassi.ChassiTargetInformation {
        private final int craftingSlot;

        public CraftingChassieInformation(int craftingSlot, int moduleSlot) {
            super(moduleSlot);
            this.craftingSlot = craftingSlot;
        }

        public int getCraftingSlot() {
            return this.craftingSlot;
        }
    }
}

