/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IClientState;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IPipeUpgradeManager;
import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.interfaces.ISecurityProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.ISpawnParticles;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.IWatchingHandler;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.ItemPipeSignCreator;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IAdjacentWorldAccess;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.PipeTransportLayer;
import logisticspipes.logisticspipes.RouteLayer;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.pipe.PipeController;
import logisticspipes.network.packets.pipe.ParticleFX;
import logisticspipes.network.packets.pipe.PipeSignTypes;
import logisticspipes.network.packets.pipe.RequestSignPacket;
import logisticspipes.network.packets.pipe.StatUpdate;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.PowerSupplierHandler;
import logisticspipes.pipes.basic.debug.DebugLogController;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCDirectCall;
import logisticspipes.proxy.computers.interfaces.CCSecurtiyCheck;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterQueuedTask;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.security.PermissionException;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

@CCType(name="LogisticsPipes:Normal")
public abstract class CoreRoutedPipe
extends CoreUnroutedPipe
implements IClientState,
IRequestItems,
IAdjacentWorldAccess,
ITrackStatistics,
IWorldProvider,
IWatchingHandler,
IPipeServiceProvider,
IQueueCCEvent,
ILPPositionProvider {
    protected boolean stillNeedReplace = true;
    private boolean recheckConnections = false;
    protected IRouter router;
    protected String routerId;
    protected Object routerIdLock = new Object();
    private static int pipecount = 0;
    protected int _delayOffset = 0;
    public boolean _textureBufferPowered;
    protected boolean _initialInit = true;
    private boolean enabled = true;
    private boolean preventRemove = false;
    private boolean destroyByPlayer = false;
    private PowerSupplierHandler powerHandler = new PowerSupplierHandler(this);
    public long delayTo = 0L;
    public int repeatFor = 0;
    protected RouteLayer _routeLayer;
    protected TransportLayer _transportLayer;
    protected final PriorityBlockingQueue<ItemRoutingInformation> _inTransitToMe = new PriorityBlockingQueue<ItemRoutingInformation>(10, new ItemRoutingInformation.DelayComparator());
    protected UpgradeManager upgradeManager = new UpgradeManager(this);
    protected LogisticsItemOrderManager _orderItemManager = null;
    private List<IOrderInfoProvider> clientSideOrderManager = new ArrayList<IOrderInfoProvider>();
    public int stat_session_sent;
    public int stat_session_recieved;
    public int stat_session_relayed;
    public long stat_lifetime_sent;
    public long stat_lifetime_recieved;
    public long stat_lifetime_relayed;
    public int server_routing_table_size = 0;
    protected final LinkedList<Triplet<IRoutedItem, ForgeDirection, ItemSendMode>> _sendQueue = new LinkedList();
    protected final Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> queuedDataForUnroutedItems = Collections.synchronizedMap(new TreeMap());
    public final PlayerCollectionList watchers = new PlayerCollectionList();
    protected List<IInventory> _cachedAdjacentInventories;
    protected ForgeDirection pointedDirection = ForgeDirection.UNKNOWN;
    protected int throttleTime = 20;
    private int throttleTimeLeft = 20 + new Random().nextInt(Configs.LOGISTICS_DETECTION_FREQUENCY);
    private int[] queuedParticles = new int[Particles.values().length];
    private boolean hasQueuedParticles = false;
    protected IPipeSign[] signItem = new IPipeSign[6];
    private boolean isOpaqueClientSide = false;
    private CacheHolder cacheHolder;
    public boolean globalIgnoreConnectionDisconnection = false;

    public CoreRoutedPipe(Item item) {
        this(new PipeTransportLogistics(true), item);
    }

    public CoreRoutedPipe(PipeTransportLogistics transport, Item item) {
        super(transport, item);
        this._delayOffset = ++pipecount % Configs.LOGISTICS_DETECTION_FREQUENCY;
    }

    public RouteLayer getRouteLayer() {
        if (this._routeLayer == null) {
            this._routeLayer = new RouteLayer(this.getRouter(), this.getTransportLayer(), this);
        }
        return this._routeLayer;
    }

    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new PipeTransportLayer(this, this, this.getRouter());
        }
        return this._transportLayer;
    }

    @Override
    public ISlotUpgradeManager getUpgradeManager(LogisticsModule.ModulePositionType slot, int positionInt) {
        return this.upgradeManager;
    }

    @Override
    public IPipeUpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public UpgradeManager getOriginalUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public void queueRoutedItem(IRoutedItem routedItem, ForgeDirection from) {
        if (from == null) {
            throw new NullPointerException();
        }
        this._sendQueue.addLast(new Triplet<IRoutedItem, ForgeDirection, ItemSendMode>(routedItem, from, ItemSendMode.Normal));
        this.sendQueueChanged(false);
    }

    public void queueRoutedItem(IRoutedItem routedItem, ForgeDirection from, ItemSendMode mode) {
        if (from == null) {
            throw new NullPointerException();
        }
        this._sendQueue.addLast(new Triplet<IRoutedItem, ForgeDirection, ItemSendMode>(routedItem, from, mode));
        this.sendQueueChanged(false);
    }

    public int sendQueueChanged(boolean force) {
        return 0;
    }

    private void sendRoutedItem(IRoutedItem routedItem, ForgeDirection from) {
        CoreRoutedPipe pipe;
        if (from == null) {
            throw new NullPointerException();
        }
        this.transport.injectItem(routedItem, from.getOpposite());
        IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(routedItem.getDestination(), false);
        if (r != null && (pipe = r.getCachedPipe()) != null) {
            pipe.notifyOfSend(routedItem.getInfo());
        }
        this.spawnParticle(Particles.OrangeParticle, 2);
        ++this.stat_lifetime_sent;
        ++this.stat_session_sent;
        this.updateStats();
    }

    private void notifyOfSend(ItemRoutingInformation routedItem) {
        this._inTransitToMe.add(routedItem);
    }

    public void notifyOfReroute(ItemRoutingInformation routedItem) {
        this._inTransitToMe.remove(routedItem);
    }

    public void refreshItem(ItemRoutingInformation routedItem) {
        if (this._inTransitToMe.contains(routedItem)) {
            this._inTransitToMe.remove(routedItem);
            this._inTransitToMe.add(routedItem);
        }
    }

    public abstract ItemSendMode getItemSendMode();

    public boolean sharesInterestWith(CoreRoutedPipe other) {
        List<IInventory> others = other.getConnectedRawInventories();
        if (others == null || others.size() == 0) {
            return false;
        }
        for (IInventory i : this.getConnectedRawInventories()) {
            if (!others.contains(i)) continue;
            return true;
        }
        return false;
    }

    protected List<IInventory> getConnectedRawInventories() {
        if (this._cachedAdjacentInventories != null) {
            return this._cachedAdjacentInventories;
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        LinkedList<IInventory> adjacent = new LinkedList<IInventory>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory)) continue;
            adjacent.add(InventoryHelper.getInventory((IInventory)tile.tile));
        }
        this._cachedAdjacentInventories = adjacent;
        return this._cachedAdjacentInventories;
    }

    public void firstInitialiseTick() {
        this.getRouter();
        if (MainProxy.isClient(this.getWorld())) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSignPacket.class).setTilePos(this.container));
        }
    }

    public void enabledUpdateEntity() {
        this.powerHandler.update();
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) continue;
            this.signItem[i].updateServerSide();
        }
    }

    public void ignoreDisableUpdateEntity() {
    }

    @Override
    public final void updateEntity() {
        this.debug.tick();
        this.spawnParticleTick();
        if (this.stillNeedReplace) {
            this.stillNeedReplace = false;
            this.getWorld().func_147444_c(this.getX(), this.getY(), this.getZ(), this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ()));
            this.firstInitialiseTick();
            return;
        }
        if (this.repeatFor > 0 && this.delayTo < System.currentTimeMillis()) {
            this.delayTo = System.currentTimeMillis() + 200L;
            --this.repeatFor;
            this.getWorld().func_147471_g(this.getX(), this.getY(), this.getZ());
        }
        while (this._inTransitToMe.peek() != null && this._inTransitToMe.peek().getTickToTimeOut() <= 0L) {
            ItemRoutingInformation p = this._inTransitToMe.poll();
            if (LPConstants.DEBUG) {
                LogisticsPipes.log.info("Timed Out: " + p.getItem().getFriendlyName() + " (" + p.hashCode() + ")");
            }
            this.debug.log("Timed Out: " + p.getItem().getFriendlyName() + " (" + p.hashCode() + ")");
        }
        this.getRouter().update(this.getWorld().func_82737_E() % (long)Configs.LOGISTICS_DETECTION_FREQUENCY == (long)this._delayOffset || this._initialInit || this.recheckConnections, this);
        this.recheckConnections = false;
        this.getOriginalUpgradeManager().securityTick();
        super.updateEntity();
        if (this.isNthTick(200)) {
            this.getCacheHolder().trigger(null);
        }
        if (--this.throttleTimeLeft <= 0) {
            this.throttledUpdateEntity();
            this.throttleTimeLeft = this.throttleTime;
        }
        this.ignoreDisableUpdateEntity();
        this._initialInit = false;
        if (!this._sendQueue.isEmpty()) {
            if (this.getItemSendMode() == ItemSendMode.Normal) {
                Triplet<IRoutedItem, ForgeDirection, ItemSendMode> itemToSend = this._sendQueue.getFirst();
                this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                this._sendQueue.removeFirst();
                for (int i = 0; i < 16 && !this._sendQueue.isEmpty() && this._sendQueue.getFirst().getValue3() == ItemSendMode.Fast; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    itemToSend = this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
                this.sendQueueChanged(false);
            } else if (this.getItemSendMode() == ItemSendMode.Fast) {
                for (int i = 0; i < 16; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    Triplet<IRoutedItem, ForgeDirection, ItemSendMode> itemToSend = this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
                this.sendQueueChanged(false);
            } else {
                if (this.getItemSendMode() == null) {
                    throw new UnsupportedOperationException("getItemSendMode() can't return null. " + this.getClass().getName());
                }
                throw new UnsupportedOperationException("getItemSendMode() returned unhandled value. " + this.getItemSendMode().name() + " in " + this.getClass().getName());
            }
        }
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        this.checkTexturePowered();
        if (!this.isEnabled()) {
            return;
        }
        this.enabledUpdateEntity();
        if (this.getLogisticsModule() == null) {
            return;
        }
        this.getLogisticsModule().tick();
    }

    protected void onAllowedRemoval() {
    }

    public void throttledUpdateEntity() {
    }

    protected void delayThrottle() {
        if (this.throttleTimeLeft < 7) {
            this.throttleTimeLeft = 7;
        }
    }

    @Override
    public boolean isNthTick(int n) {
        return (this.getWorld().func_82737_E() + (long)this._delayOffset) % (long)n == 0L;
    }

    private void doDebugStuff(EntityPlayer entityplayer) {
        IRouter r = this.getRouter();
        if (!(r instanceof ServerRouter)) {
            return;
        }
        System.out.println("***");
        System.out.println("---------Interests---------------");
        for (Map.Entry<ItemIdentifier, Set<IRouter>> i : ServerRouter.getInterestedInSpecifics().entrySet()) {
            System.out.print(i.getKey().getFriendlyName() + ":");
            for (IRouter j : i.getValue()) {
                System.out.print(j.getSimpleID() + ",");
            }
            System.out.println();
        }
        System.out.print("ALL ITEMS:");
        for (IRouter j : ServerRouter.getInterestedInGeneral()) {
            System.out.print(j.getSimpleID() + ",");
        }
        System.out.println();
        ServerRouter sr = (ServerRouter)r;
        System.out.println(r.toString());
        System.out.println("---------CONNECTED TO---------------");
        for (CoreRoutedPipe adj : sr._adjacent.keySet()) {
            System.out.println(adj.getRouter().getSimpleID());
        }
        System.out.println();
        System.out.println("========DISTANCE TABLE==============");
        for (ExitRoute n : r.getIRoutersByCost()) {
            System.out.println(n.destination.getSimpleID() + " @ " + n.distanceToDestination + " -> " + n.connectionDetails + "(" + n.destination.getId() + ")");
        }
        System.out.println();
        System.out.println("*******EXIT ROUTE TABLE*************");
        List<List<ExitRoute>> table = r.getRouteTable();
        for (int i = 0; i < table.size(); ++i) {
            if (table.get(i) == null || table.get(i).size() <= 0) continue;
            System.out.println(i + " -> " + table.get((int)i).get((int)0).destination.getSimpleID());
            for (ExitRoute route : table.get(i)) {
                System.out.println("\t\t via " + route.exitOrientation + "(" + route.distanceToDestination + " distance)");
            }
        }
        System.out.println();
        System.out.println("++++++++++CONNECTIONS+++++++++++++++");
        System.out.println(Arrays.toString(ForgeDirection.VALID_DIRECTIONS));
        System.out.println(Arrays.toString(sr.sideDisconnected));
        System.out.println(Arrays.toString(this.container.pipeConnectionsBuffer));
        System.out.println();
        System.out.println("~~~~~~~~~~~~~~~POWER~~~~~~~~~~~~~~~~");
        System.out.println(r.getPowerProvider());
        System.out.println();
        System.out.println("~~~~~~~~~~~SUBSYSTEMPOWER~~~~~~~~~~~");
        System.out.println(r.getSubSystemPowerProvider());
        System.out.println();
        if (this._orderItemManager != null) {
            System.out.println("################ORDERDUMP#################");
            this._orderItemManager.dump();
        }
        System.out.println("################END#################");
        this.refreshConnectionAndRender(true);
        System.out.print("");
        sr.CreateRouteTable(Integer.MAX_VALUE);
    }

    @Override
    public final void onBlockRemoval() {
        try {
            this.onAllowedRemoval();
            super.onBlockRemoval();
            pipecount = Math.max(pipecount - 1, 0);
            if (this.transport != null && this.transport instanceof PipeTransportLogistics) {
                this.transport.dropBuffer();
            }
            this.getOriginalUpgradeManager().dropUpgrades();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.router != null) {
            this.router.destroy();
            this.router = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.router != null) {
            this.router.clearPipeCache();
            this.router.clearInterests();
        }
    }

    public void checkTexturePowered() {
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return;
        }
        if (!this.isNthTick(10)) {
            return;
        }
        if (this.stillNeedReplace || this._initialInit || this.router == null) {
            return;
        }
        boolean flag = this.canUseEnergy(1);
        if (flag != this._textureBufferPowered) {
            this._textureBufferPowered = flag;
            this.refreshRender(false);
            this.spawnParticle(Particles.RedParticle, 3);
        }
    }

    @Override
    public int getTextureIndex() {
        return this.getCenterTexture().newTexture;
    }

    public abstract Textures.TextureType getCenterTexture();

    public Textures.TextureType getTextureType(ForgeDirection connection) {
        if (this.stillNeedReplace || this._initialInit) {
            return this.getCenterTexture();
        }
        if (connection == ForgeDirection.UNKNOWN) {
            return this.getCenterTexture();
        }
        if (this.router != null && this.getRouter().isRoutedExit(connection)) {
            return this.getRoutedTexture(connection);
        }
        Textures.TextureType texture = this.getNonRoutedTexture(connection);
        if (this.getUpgradeManager().hasRFPowerSupplierUpgrade() || this.getUpgradeManager().getIC2PowerLevel() > 0) {
            if (texture.fileName.equals(Textures.LOGISTICSPIPE_NOTROUTED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_NOTROUTED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_LIQUID_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_LIQUID_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_POWERED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_POWERED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_NOTROUTED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_DIRECTION_POWERED_TEXTURE;
            } else {
                System.out.println("Unknown texture to power, :" + texture.fileName);
                System.out.println(this.getClass());
                System.out.println(connection);
            }
        }
        return texture;
    }

    public Textures.TextureType getRoutedTexture(ForgeDirection connection) {
        if (this.getRouter().isSubPoweredExit(connection)) {
            return Textures.LOGISTICSPIPE_SUBPOWER_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_ROUTED_TEXTURE;
    }

    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (this.isPowerProvider(connection)) {
            return Textures.LOGISTICSPIPE_POWERED_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_NOTROUTED_TEXTURE;
    }

    @Override
    public void spawnParticle(Particles particle, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX) {
            return;
        }
        int n = particle.ordinal();
        this.queuedParticles[n] = this.queuedParticles[n] + amount;
        this.hasQueuedParticles = true;
    }

    private void spawnParticleTick() {
        if (!this.hasQueuedParticles) {
            return;
        }
        if (MainProxy.isServer(this.getWorld())) {
            ArrayList<ISpawnParticles.ParticleCount> tosend = new ArrayList<ISpawnParticles.ParticleCount>(this.queuedParticles.length);
            for (int i = 0; i < this.queuedParticles.length; ++i) {
                if (this.queuedParticles[i] <= 0) continue;
                tosend.add(new ISpawnParticles.ParticleCount(Particles.values()[i], this.queuedParticles[i]));
            }
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.getWorld()), PacketHandler.getPacket(ParticleFX.class).setParticles(tosend).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        } else if (Minecraft.func_71375_t()) {
            for (int i = 0; i < this.queuedParticles.length; ++i) {
                if (this.queuedParticles[i] <= 0) continue;
                PipeFXRenderHandler.spawnGenericParticle(Particles.values()[i], this.getX(), this.getY(), this.getZ(), this.queuedParticles[i]);
            }
        }
        for (int i = 0; i < this.queuedParticles.length; ++i) {
            this.queuedParticles[i] = 0;
        }
        this.hasQueuedParticles = false;
    }

    protected boolean isPowerProvider(ForgeDirection ori) {
        TileEntity tilePipe = this.container.getTile(ori);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof ILogisticsPowerProvider || tilePipe instanceof ISubSystemPowerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            if (this.routerId == null || this.routerId.isEmpty()) {
                this.routerId = this.router != null ? this.router.getId().toString() : UUID.randomUUID().toString();
            }
        }
        nbttagcompound.func_74778_a("routerId", this.routerId);
        nbttagcompound.func_74772_a("stat_lifetime_sent", this.stat_lifetime_sent);
        nbttagcompound.func_74772_a("stat_lifetime_recieved", this.stat_lifetime_recieved);
        nbttagcompound.func_74772_a("stat_lifetime_relayed", this.stat_lifetime_relayed);
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().writeToNBT(nbttagcompound);
        }
        NBTTagCompound upgradeNBT = new NBTTagCompound();
        this.upgradeManager.writeToNBT(upgradeNBT);
        nbttagcompound.func_74782_a("upgradeManager", (NBTBase)upgradeNBT);
        NBTTagCompound powerNBT = new NBTTagCompound();
        this.powerHandler.writeToNBT(powerNBT);
        if (!powerNBT.func_82582_d()) {
            nbttagcompound.func_74782_a("powerHandler", (NBTBase)powerNBT);
        }
        NBTTagList sendqueue = new NBTTagList();
        for (Triplet triplet : this._sendQueue) {
            NBTTagCompound tagentry = new NBTTagCompound();
            NBTTagCompound tagentityitem = new NBTTagCompound();
            ((IRoutedItem)triplet.getValue1()).writeToNBT(tagentityitem);
            tagentry.func_74782_a("entityitem", (NBTBase)tagentityitem);
            tagentry.func_74774_a("from", (byte)((ForgeDirection)triplet.getValue2()).ordinal());
            tagentry.func_74774_a("mode", (byte)((ItemSendMode)((Object)triplet.getValue3())).ordinal());
            sendqueue.func_74742_a((NBTBase)tagentry);
        }
        nbttagcompound.func_74782_a("sendqueue", (NBTBase)sendqueue);
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] != null) {
                nbttagcompound.func_74757_a("PipeSign_" + i, true);
                int n = -1;
                List<Class<? extends IPipeSign>> typeClasses = ItemPipeSignCreator.signTypes;
                for (int j = 0; j < typeClasses.size(); ++j) {
                    if (typeClasses.get(j) != this.signItem[i].getClass()) continue;
                    n = j;
                    break;
                }
                nbttagcompound.func_74768_a("PipeSign_" + i + "_type", n);
                NBTTagCompound tag = new NBTTagCompound();
                this.signItem[i].writeToNBT(tag);
                nbttagcompound.func_74782_a("PipeSign_" + i + "_tags", (NBTBase)tag);
                continue;
            }
            nbttagcompound.func_74757_a("PipeSign_" + i, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            this.routerId = nbttagcompound.func_74779_i("routerId");
        }
        this.stat_lifetime_sent = nbttagcompound.func_74763_f("stat_lifetime_sent");
        this.stat_lifetime_recieved = nbttagcompound.func_74763_f("stat_lifetime_recieved");
        this.stat_lifetime_relayed = nbttagcompound.func_74763_f("stat_lifetime_relayed");
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().readFromNBT(nbttagcompound);
        }
        this.upgradeManager.readFromNBT(nbttagcompound.func_74775_l("upgradeManager"));
        this.powerHandler.readFromNBT(nbttagcompound.func_74775_l("powerHandler"));
        this._sendQueue.clear();
        NBTTagList sendqueue = nbttagcompound.func_150295_c("sendqueue", (int)nbttagcompound.func_74732_a());
        for (i = 0; i < sendqueue.func_74745_c(); ++i) {
            NBTTagCompound tagentry = sendqueue.func_150305_b(i);
            NBTTagCompound tagentityitem = tagentry.func_74775_l("entityitem");
            LPTravelingItem.LPTravelingItemServer item = new LPTravelingItem.LPTravelingItemServer(tagentityitem);
            ForgeDirection from = ForgeDirection.values()[tagentry.func_74771_c("from")];
            ItemSendMode mode = ItemSendMode.values()[tagentry.func_74771_c("mode")];
            this._sendQueue.add(new Triplet<LPTravelingItem.LPTravelingItemServer, ForgeDirection, ItemSendMode>(item, from, mode));
        }
        for (i = 0; i < 6; ++i) {
            if (!nbttagcompound.func_74767_n("PipeSign_" + i)) continue;
            int type = nbttagcompound.func_74762_e("PipeSign_" + i + "_type");
            Class<? extends IPipeSign> typeClass = ItemPipeSignCreator.signTypes.get(type);
            try {
                this.signItem[i] = typeClass.newInstance();
                this.signItem[i].init(this, ForgeDirection.getOrientation((int)i));
                this.signItem[i].readFromNBT(nbttagcompound.func_74775_l("PipeSign_" + i + "_tags"));
                continue;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getRouter() {
        if (this.stillNeedReplace) {
            System.out.format("Hey, don't get routers for pipes that aren't ready (%d, %d, %d, '%s')", this.getX(), this.getY(), this.getZ(), this.getWorld().func_72912_H().func_76065_j());
            new Throwable().printStackTrace();
        }
        if (this.router == null) {
            Object object = this.routerIdLock;
            synchronized (object) {
                UUID routerIntId = null;
                if (this.routerId != null && !this.routerId.isEmpty()) {
                    routerIntId = UUID.fromString(this.routerId);
                }
                this.router = SimpleServiceLocator.routerManager.getOrCreateRouter(routerIntId, MainProxy.getDimensionForWorld(this.getWorld()), this.getX(), this.getY(), this.getZ(), false);
            }
        }
        return this.router;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.clearCache();
        if (!this.stillNeedReplace && MainProxy.isServer(this.getWorld())) {
            this.onNeighborBlockChange_Logistics();
        }
    }

    public void onNeighborBlockChange_Logistics() {
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
    }

    @CCCommand(description="Returns the Internal LogisticsModule for this pipe")
    public abstract LogisticsModule getLogisticsModule();

    @Override
    public final boolean blockActivated(EntityPlayer entityplayer) {
        LogisticsSecurityTileEntity station;
        SecuritySettings settings = null;
        if (MainProxy.isServer(entityplayer.field_70170_p) && (station = SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID())) != null) {
            settings = station.getSecuritySettingsForPlayer(entityplayer, true);
        }
        if (MainProxy.isPipeControllerEquipped(entityplayer)) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                if (settings == null || settings.openNetworkMonitor) {
                    NewGuiHandler.getGui(PipeController.class).setTilePos(this.container).open(entityplayer);
                } else {
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            return true;
        }
        if (this.handleClick(entityplayer, settings)) {
            return true;
        }
        if (entityplayer.func_71045_bC() == null) {
            if (!entityplayer.func_70093_af()) {
                return false;
            }
            if (LPConstants.DEBUG) {
                this.doDebugStuff(entityplayer);
            }
            return true;
        }
        if (entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsRemoteOrderer) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                if (settings == null || settings.openRequest) {
                    entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.getWorld(), this.getX(), this.getY(), this.getZ());
                } else {
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            return true;
        }
        if (SimpleServiceLocator.toolWrenchHandler.isWrenchEquipped(entityplayer) && SimpleServiceLocator.toolWrenchHandler.canWrench(entityplayer, this.getX(), this.getY(), this.getZ())) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                if (settings == null || settings.openGui) {
                    if (this.getLogisticsModule() != null && this.getLogisticsModule() instanceof LogisticsGuiModule) {
                        ((LogisticsGuiModule)this.getLogisticsModule()).getPipeGuiProviderForModule().setTilePos(this.container).open(entityplayer);
                    } else {
                        this.onWrenchClicked(entityplayer);
                    }
                } else {
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.toolWrenchHandler.wrenchUsed(entityplayer, this.getX(), this.getY(), this.getZ());
            return true;
        }
        if (!entityplayer.func_70093_af() && this.getOriginalUpgradeManager().tryIserting(this.getWorld(), entityplayer)) {
            return true;
        }
        return super.blockActivated(entityplayer);
    }

    protected boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        return false;
    }

    protected void clearCache() {
        this._cachedAdjacentInventories = null;
    }

    public void refreshRender(boolean spawnPart) {
        this.container.scheduleRenderUpdate();
        if (spawnPart) {
            this.spawnParticle(Particles.GreenParticle, 3);
        }
    }

    public void refreshConnectionAndRender(boolean spawnPart) {
        this.clearCache();
        this.container.scheduleNeighborChange();
        if (spawnPart) {
            this.spawnParticle(Particles.GreenParticle, 3);
        }
    }

    @Override
    public LinkedList<AdjacentTile> getConnectedEntities() {
        WorldUtil world = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        LinkedList<AdjacentTile> adjacent = world.getAdjacentTileEntities(true);
        Iterator iterator = adjacent.iterator();
        while (iterator.hasNext()) {
            AdjacentTile tile = (AdjacentTile)iterator.next();
            if (MainProxy.checkPipesConnections(this.container, tile.tile, tile.orientation)) continue;
            iterator.remove();
        }
        return adjacent;
    }

    @Override
    public int getRandomInt(int maxSize) {
        return this.getWorld().field_73012_v.nextInt(maxSize);
    }

    @Override
    public void recievedItem(int count) {
        this.stat_session_recieved += count;
        this.stat_lifetime_recieved += (long)count;
        this.updateStats();
    }

    @Override
    public void relayedItem(int count) {
        this.stat_session_relayed += count;
        this.stat_lifetime_relayed += (long)count;
        this.updateStats();
    }

    @Override
    public World getWorld() {
        return this.container.getWorld();
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 0) {
            this.watchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(StatUpdate.class).setPipe(this), player);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        if (mode == 0) {
            this.watchers.remove(player);
        }
    }

    public void updateStats() {
        if (this.watchers.size() > 0) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(StatUpdate.class).setPipe(this), this.watchers);
        }
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (this instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)((Object)this)).itemLost(item, info);
        }
    }

    public boolean isLockedExit(ForgeDirection orientation) {
        return false;
    }

    public boolean logisitcsIsPipeConnected(TileEntity tile, ForgeDirection dir) {
        return false;
    }

    public boolean disconnectPipe(TileEntity tile, ForgeDirection dir) {
        return false;
    }

    @Override
    public final boolean canPipeConnect(TileEntity tile, ForgeDirection dir) {
        return this.canPipeConnect(tile, dir, false);
    }

    @Override
    public final boolean canPipeConnect(TileEntity tile, ForgeDirection dir, boolean ignoreSystemDisconnection) {
        ForgeDirection side = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile);
        if (this.isSideBlocked(side, ignoreSystemDisconnection)) {
            return false;
        }
        return (super.canPipeConnect(tile, dir) || this.logisitcsIsPipeConnected(tile, dir)) && !this.disconnectPipe(tile, dir);
    }

    @Override
    public final boolean isSideBlocked(ForgeDirection side, boolean ignoreSystemDisconnection) {
        if (this.getUpgradeManager().isSideDisconnected(side)) {
            return true;
        }
        if (this.container != null && side != ForgeDirection.UNKNOWN && this.container.tilePart.hasBlockingPluggable(side)) {
            return true;
        }
        return !this.stillNeedReplace && this.getRouter().isSideDisconneceted(side) && !ignoreSystemDisconnection && !this.globalIgnoreConnectionDisconnection;
    }

    public void connectionUpdate() {
        if (this.container != null && !this.stillNeedReplace) {
            this.container.scheduleNeighborChange();
            this.getWorld().func_147444_c(this.getX(), this.getY(), this.getZ(), this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ()));
        }
    }

    public UUID getSecurityID() {
        return this.getOriginalUpgradeManager().getSecurityID();
    }

    public void insetSecurityID(UUID id) {
        this.getOriginalUpgradeManager().insetSecurityID(id);
    }

    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> getRoutedPowerProviders() {
        if (MainProxy.isClient(this.getWorld())) {
            return null;
        }
        if (this.stillNeedReplace) {
            return null;
        }
        return this.getRouter().getPowerProvider();
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null, true);
    }

    public boolean useEnergy(int amount, boolean sparkles) {
        return this.useEnergy(amount, null, sparkles);
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    @Override
    public boolean canUseEnergy(int amount, List<Object> providersToIgnore) {
        if (MainProxy.isClient(this.getWorld())) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        List<Pair<ILogisticsPowerProvider, List<IFilter>>> list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        block0: for (Pair<ILogisticsPowerProvider, List<IFilter>> provider : list) {
            for (IFilter filter : provider.getValue2()) {
                if (!filter.blockPower()) continue;
                continue block0;
            }
            if (!provider.getValue1().canUseEnergy(amount, providersToIgnore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useEnergy(int amount, List<Object> providersToIgnore) {
        return this.useEnergy(amount, providersToIgnore, false);
    }

    private boolean useEnergy(int amount, List<Object> providersToIgnore, boolean sparkles) {
        if (MainProxy.isClient(this.getWorld())) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore == null) {
            providersToIgnore = new ArrayList<Object>();
        }
        if (providersToIgnore.contains(this)) {
            return false;
        }
        providersToIgnore.add(this);
        List<Pair<ILogisticsPowerProvider, List<IFilter>>> list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        block0: for (Pair<ILogisticsPowerProvider, List<IFilter>> provider : list) {
            for (IFilter filter : provider.getValue2()) {
                if (!filter.blockPower()) continue;
                continue block0;
            }
            if (!provider.getValue1().canUseEnergy(amount, providersToIgnore) || !provider.getValue1().useEnergy(amount, providersToIgnore)) continue;
            if (sparkles) {
                int particlecount = amount;
                if (particlecount > 10) {
                    particlecount = 10;
                }
                this.spawnParticle(Particles.GoldParticle, particlecount);
            }
            return true;
        }
        return false;
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        if (this.container instanceof LogisticsTileGenericPipe) {
            this.container.queueEvent(event, arguments);
        }
    }

    public boolean stillNeedReplace() {
        return this.stillNeedReplace;
    }

    public boolean initialInit() {
        return this._initialInit;
    }

    @Override
    public int compareTo(IRequestItems other) {
        return this.getID() - other.getID();
    }

    @Override
    public int getID() {
        return this.getRouter().getSimpleID();
    }

    public Set<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    public boolean hasGenericInterests() {
        return false;
    }

    public ISecurityProvider getSecurityProvider() {
        return SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID());
    }

    public boolean canBeDestroyedByPlayer(EntityPlayer entityPlayer) {
        LogisticsSecurityTileEntity station = SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID());
        if (station != null) {
            return station.getSecuritySettingsForPlayer((EntityPlayer)entityPlayer, (boolean)true).removePipes;
        }
        return true;
    }

    @Override
    public boolean canBeDestroyed() {
        ISecurityProvider sec = this.getSecurityProvider();
        return sec == null || sec.canAutomatedDestroy();
    }

    public void setDestroyByPlayer() {
        this.destroyByPlayer = true;
    }

    @Override
    public boolean destroyByPlayer() {
        return this.destroyByPlayer;
    }

    @Override
    public boolean preventRemove() {
        return this.preventRemove;
    }

    @CCSecurtiyCheck
    public void checkCCAccess() throws PermissionException {
        ISecurityProvider sec = this.getSecurityProvider();
        if (sec != null) {
            int id = -1;
            if (this.container instanceof LogisticsTileGenericPipe) {
                id = this.container.getLastCCID();
            }
            if (!sec.getAllowCC(id)) {
                throw new PermissionException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUnroutedItemInformation(ItemIdentifierStack item, ItemRoutingInformation information) {
        if (item != null) {
            Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> map = this.queuedDataForUnroutedItems;
            synchronized (map) {
                Queue<Pair<Integer, ItemRoutingInformation>> queue = this.queuedDataForUnroutedItems.get(item.getItem());
                if (queue == null) {
                    queue = new LinkedList<Pair<Integer, ItemRoutingInformation>>();
                    this.queuedDataForUnroutedItems.put(item.getItem(), queue);
                }
                queue.add(new Pair<Integer, ItemRoutingInformation>(item.getStackSize(), information));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemRoutingInformation getQueuedForItemStack(ItemIdentifierStack item) {
        Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> map = this.queuedDataForUnroutedItems;
        synchronized (map) {
            Queue<Pair<Integer, ItemRoutingInformation>> queue = this.queuedDataForUnroutedItems.get(item.getItem());
            if (queue == null || queue.isEmpty()) {
                return null;
            }
            Pair<Integer, ItemRoutingInformation> pair = queue.peek();
            int wantItem = pair.getValue1();
            if (wantItem <= item.getStackSize()) {
                if (queue.remove() != pair) {
                    LogisticsPipes.log.fatal("Item queue mismatch");
                    return null;
                }
                if (queue.isEmpty()) {
                    this.queuedDataForUnroutedItems.remove(item.getItem());
                }
                item.setStackSize(wantItem);
                return pair.getValue2();
            }
        }
        return null;
    }

    public double getLoadFactor() {
        return 0.0;
    }

    public void notifyOfItemArival(ItemRoutingInformation information) {
        FluidStack liquid;
        ItemIdentifierStack stack;
        this._inTransitToMe.remove(information);
        if (this instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)((Object)this)).itemArrived(information.getItem(), information.targetInfo);
        }
        if (this instanceof IRequireReliableFluidTransport && (stack = information.getItem()).getItem().isFluidContainer() && (liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(stack)) != null) {
            ((IRequireReliableFluidTransport)((Object)this)).liquidArrived(FluidIdentifier.get(liquid), liquid.amount);
        }
    }

    @Override
    public int countOnRoute(ItemIdentifier it) {
        int count = 0;
        for (ItemRoutingInformation next : this._inTransitToMe) {
            if (!next.getItem().getItem().equals(it)) continue;
            count += next.getItem().getStackSize();
        }
        return count;
    }

    @Override
    public final int getIconIndex(ForgeDirection connection) {
        Textures.TextureType texture = this.getTextureType(connection);
        if (this._textureBufferPowered) {
            return texture.powered;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return texture.normal;
        }
        return texture.unpowered;
    }

    public void addCrashReport(CrashReportCategory crashReportCategory) {
        this.addRouterCrashReport(crashReportCategory);
        crashReportCategory.func_71507_a("stillNeedReplace", (Object)this.stillNeedReplace);
    }

    protected void addRouterCrashReport(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_71507_a("Router", (Object)this.getRouter().toString());
    }

    @CCCommand(description="Returns the Router UUID as an integer; all pipes have a unique ID (runtime stable)")
    public int getRouterId() {
        return this.getRouter().getSimpleID();
    }

    @CCCommand(description="Returns the Router UUID; all pipes have a unique ID (lifetime stable)")
    public String getRouterUUID() {
        return this.getRouter().getId().toString();
    }

    @CCCommand(description="Returns the Router UUID for the givvin router Id")
    public String getRouterUUID(Double id) {
        IRouter router = SimpleServiceLocator.routerManager.getRouter((int)id.doubleValue());
        if (router == null) {
            return null;
        }
        return router.getId().toString();
    }

    @CCCommand(description="Sets the TurtleConnect flag for this Turtle on this LogisticsPipe")
    @CCDirectCall
    public void setTurtleConnect(Boolean flag) {
        if (this.container instanceof LogisticsTileGenericPipe) {
            this.container.setTurtleConnect(flag);
        }
    }

    @CCCommand(description="Returns the TurtleConnect flag for this Turtle on this LogisticsPipe")
    @CCDirectCall
    public boolean getTurtleConnect() {
        if (this.container instanceof LogisticsTileGenericPipe) {
            return this.container.getTurtleConnect();
        }
        return false;
    }

    @CCCommand(description="Returns true if the computer is allowed to interact with the connected pipe.", needPermission=false)
    public boolean canAccess() {
        ISecurityProvider sec = this.getSecurityProvider();
        if (sec != null) {
            int id = -1;
            if (this.container instanceof LogisticsTileGenericPipe) {
                id = this.container.getLastCCID();
            }
            return sec.getAllowCC(id);
        }
        return true;
    }

    @CCCommand(description="Sends a message to the givven computerId over the LP network. Event: LP_MESSAGE")
    @CCDirectCall
    public void sendMessage(final Double computerId, final Object message) {
        int sourceId = -1;
        if (this.container instanceof LogisticsTileGenericPipe) {
            sourceId = SimpleServiceLocator.ccProxy.getLastCCID(this.container);
        }
        final int fSourceId = sourceId;
        BitSet set = new BitSet(ServerRouter.getBiggestSimpleID());
        for (ExitRoute exit : this.getRouter().getIRoutersByCost()) {
            if (exit.destination == null || set.get(exit.destination.getSimpleID())) continue;
            exit.destination.queueTask(10, new IRouterQueuedTask(){

                @Override
                public void call(CoreRoutedPipe pipe, IRouter router) {
                    pipe.handleMesssage((int)computerId.doubleValue(), message, fSourceId);
                }
            });
            set.set(exit.destination.getSimpleID());
        }
    }

    @CCCommand(description="Sends a broadcast message to all Computer connected to this LP network. Event: LP_BROADCAST")
    @CCDirectCall
    public void sendBroadcast(final String message) {
        int sourceId = -1;
        if (this.container instanceof LogisticsTileGenericPipe) {
            sourceId = SimpleServiceLocator.ccProxy.getLastCCID(this.container);
        }
        final int fSourceId = sourceId;
        BitSet set = new BitSet(ServerRouter.getBiggestSimpleID());
        for (ExitRoute exit : this.getRouter().getIRoutersByCost()) {
            if (exit.destination == null || set.get(exit.destination.getSimpleID())) continue;
            exit.destination.queueTask(10, new IRouterQueuedTask(){

                @Override
                public void call(CoreRoutedPipe pipe, IRouter router) {
                    pipe.handleBroadcast(message, fSourceId);
                }
            });
            set.set(exit.destination.getSimpleID());
        }
    }

    @CCCommand(description="Returns the access to the pipe of the givven router UUID")
    @ModDependentMethod(modId="ComputerCraft@1.7")
    @CCDirectCall
    public Object getPipeForUUID(String sUuid) throws PermissionException {
        if (!this.getUpgradeManager().hasCCRemoteControlUpgrade()) {
            throw new PermissionException();
        }
        UUID uuid = UUID.fromString(sUuid);
        int id = SimpleServiceLocator.routerManager.getIDforUUID(uuid);
        IRouter router = SimpleServiceLocator.routerManager.getRouter(id);
        if (router == null) {
            return null;
        }
        CoreRoutedPipe pipe = router.getPipe();
        return pipe;
    }

    @CCCommand(description="Returns the global LP object which is used to access general LP methods.", needPermission=false)
    @CCDirectCall
    public Object getLP() throws PermissionException {
        return LogisticsPipes.getComputerLP();
    }

    @CCCommand(description="Returns true if the pipe has an internal module")
    public boolean hasLogisticsModule() {
        return this.getLogisticsModule() != null;
    }

    private void handleMesssage(int computerId, Object message, int sourceId) {
        if (this.container instanceof LogisticsTileGenericPipe) {
            this.container.handleMesssage(computerId, message, sourceId);
        }
    }

    private void handleBroadcast(String message, int sourceId) {
        this.queueEvent("LP_BROADCAST", new Object[]{sourceId, message});
    }

    public void onWrenchClicked(EntityPlayer entityplayer) {
    }

    final void destroy() {
    }

    public void handleRFPowerArival(float toSend) {
        this.powerHandler.addRFPower(toSend);
    }

    public void handleIC2PowerArival(float toSend) {
        this.powerHandler.addIC2Power(toSend);
    }

    @Override
    public IInventoryUtil getPointedInventory(boolean forExtraction) {
        return this.getSneakyInventory(this.getPointedOrientation().getOpposite(), forExtraction);
    }

    @Override
    public IInventoryUtil getPointedInventory(ExtractionMode mode, boolean forExtraction) {
        IInventory inv = this.getRealInventory();
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, this.getPointedOrientation().getOpposite(), forExtraction);
        }
        switch (mode) {
            case LeaveFirst: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), false, false, 1, 0);
            }
            case LeaveLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), false, false, 0, 1);
            }
            case LeaveFirstAndLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), false, false, 1, 1);
            }
            case Leave1PerStack: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), true, false, 0, 0);
            }
            case Leave1PerType: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), false, true, 0, 0);
            }
        }
        return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(inv, this.getPointedOrientation().getOpposite(), false, false, 0, 0);
    }

    @Override
    public IInventoryUtil getSneakyInventory(boolean forExtraction, LogisticsModule.ModulePositionType slot, int positionInt) {
        ISlotUpgradeManager manager = this.getUpgradeManager(slot, positionInt);
        ForgeDirection insertion = this.getPointedOrientation().getOpposite();
        if (manager.hasSneakyUpgrade()) {
            insertion = manager.getSneakyOrientation();
        }
        return this.getSneakyInventory(insertion, forExtraction);
    }

    @Override
    public IInventoryUtil getSneakyInventory(ForgeDirection _sneakyOrientation, boolean forExtraction) {
        IInventory inv = this.getRealInventory();
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, _sneakyOrientation, forExtraction);
        }
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, _sneakyOrientation);
    }

    @Override
    public IInventoryUtil getUnsidedInventory() {
        IInventory inv = this.getRealInventory();
        if (inv == null) {
            return null;
        }
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
    }

    @Override
    public IInventory getRealInventory() {
        TileEntity tile = this.getPointedTileEntity();
        if (tile == null) {
            return null;
        }
        if (!(tile instanceof IInventory)) {
            return null;
        }
        return InventoryHelper.getInventory((IInventory)tile);
    }

    private TileEntity getPointedTileEntity() {
        if (this.pointedDirection == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.getContainer().getTile(this.pointedDirection);
    }

    @Override
    public ForgeDirection inventoryOrientation() {
        return this.getPointedOrientation();
    }

    public int getSourceint() {
        return this.getRouter().getSimpleID();
    }

    public Triplet<Integer, SinkReply, List<IFilter>> hasDestination(ItemIdentifier stack, boolean allowDefault, List<Integer> routerIDsToExclude) {
        return SimpleServiceLocator.logisticsManager.hasDestination(stack, allowDefault, this.getRouter().getSimpleID(), routerIDsToExclude);
    }

    @Override
    public IRoutedItem sendStack(ItemStack stack, Pair<Integer, SinkReply> reply, ItemSendMode mode) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
        itemToSend.setDestination(reply.getValue1());
        if (reply.getValue2().isPassive) {
            if (reply.getValue2().isDefault) {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Default);
            } else {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
            }
        }
        itemToSend.setAdditionalTargetInformation(reply.getValue2().addInfo);
        this.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
        return itemToSend;
    }

    @Override
    public IRoutedItem sendStack(ItemStack stack, int destination, ItemSendMode mode, IAdditionalTargetInformation info) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        itemToSend.setAdditionalTargetInformation(info);
        this.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
        return itemToSend;
    }

    public ForgeDirection getPointedOrientation() {
        return this.pointedDirection;
    }

    @Override
    public LogisticsItemOrderManager getItemOrderManager() {
        this._orderItemManager = this._orderItemManager != null ? this._orderItemManager : new LogisticsItemOrderManager(this);
        return this._orderItemManager;
    }

    public LogisticsOrderManager<?, ?> getOrderManager() {
        return this.getItemOrderManager();
    }

    public void addPipeSign(ForgeDirection dir, IPipeSign type, EntityPlayer player) {
        if (dir.ordinal() < 6) {
            if (this.signItem[dir.ordinal()] == null) {
                this.signItem[dir.ordinal()] = type;
                this.signItem[dir.ordinal()].init(this, dir);
            }
            if (this.container != null) {
                this.sendSignData(player);
            }
        }
    }

    public void sendSignData(EntityPlayer player) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        block0: for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) {
                types.add(-1);
                continue;
            }
            List<Class<? extends IPipeSign>> typeClasses = ItemPipeSignCreator.signTypes;
            for (int j = 0; j < typeClasses.size(); ++j) {
                if (typeClasses.get(j) != this.signItem[i].getClass()) continue;
                types.add(j);
                continue block0;
            }
        }
        ModernPacket packet = PacketHandler.getPacket(PipeSignTypes.class).setTypes(types).setTilePos(this.container);
        MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.getWorld()), packet);
        MainProxy.sendPacketToPlayer(packet, player);
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null || (packet = this.signItem[i].getPacket()) == null) continue;
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.getWorld()), packet);
            MainProxy.sendPacketToPlayer(packet, player);
        }
        this.refreshRender(false);
    }

    public void removePipeSign(ForgeDirection dir, EntityPlayer player) {
        if (dir.ordinal() < 6) {
            this.signItem[dir.ordinal()] = null;
        }
        this.sendSignData(player);
    }

    public boolean hasPipeSign(ForgeDirection dir) {
        if (dir.ordinal() < 6) {
            return this.signItem[dir.ordinal()] != null;
        }
        return false;
    }

    public void activatePipeSign(ForgeDirection dir, EntityPlayer player) {
        if (dir.ordinal() < 6 && this.signItem[dir.ordinal()] != null) {
            this.signItem[dir.ordinal()].activate(player);
        }
    }

    public List<Pair<ForgeDirection, IPipeSign>> getPipeSigns() {
        ArrayList<Pair<ForgeDirection, IPipeSign>> list = new ArrayList<Pair<ForgeDirection, IPipeSign>>();
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) continue;
            list.add(new Pair<ForgeDirection, IPipeSign>(ForgeDirection.getOrientation((int)i), this.signItem[i]));
        }
        return list;
    }

    public void handleSignPacket(List<Integer> types) {
        if (!MainProxy.isClient(this.getWorld())) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int integer = types.get(i);
            if (integer >= 0) {
                Class<? extends IPipeSign> type = ItemPipeSignCreator.signTypes.get(integer);
                if (this.signItem[i] != null && this.signItem[i].getClass() == type) continue;
                try {
                    this.signItem[i] = type.newInstance();
                    this.signItem[i].init(this, ForgeDirection.getOrientation((int)i));
                    continue;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signItem[i] = null;
        }
    }

    public IPipeSign getPipeSign(ForgeDirection dir) {
        if (dir.ordinal() < 6) {
            return this.signItem[dir.ordinal()];
        }
        return null;
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeBoolean(this.isOpaque());
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.isOpaqueClientSide = data.readBoolean();
    }

    @Override
    public boolean isOpaque() {
        if (MainProxy.isClient(this.getWorld())) {
            return Configs.OPAQUE || this.isOpaqueClientSide;
        }
        return Configs.OPAQUE || this.getUpgradeManager().isOpaque();
    }

    @Override
    public void addStatusInformation(List<StatusEntry> status) {
        StatusEntry subEntry;
        StatusEntry entry = new StatusEntry();
        entry.name = "Send Queue";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (Triplet triplet : this._sendQueue) {
            subEntry = new StatusEntry();
            subEntry.name = triplet.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
        entry = new StatusEntry();
        entry.name = "In Transit To Me";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (ItemRoutingInformation itemRoutingInformation : this._inTransitToMe) {
            subEntry = new StatusEntry();
            subEntry.name = itemRoutingInformation.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    @Override
    public DebugLogController getDebug() {
        return this.debug;
    }

    @Override
    public void setPreventRemove(boolean flag) {
        this.preventRemove = flag;
    }

    @Override
    public boolean isRoutedPipe() {
        return true;
    }

    @Override
    public double getDistanceTo(int destinationint, ForgeDirection ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<LPPosition> visited) {
        if (!this.stillNeedReplace) {
            if (this.getRouterId() == destinationint) {
                return 0.0;
            }
            ExitRoute route = this.getRouter().getExitFor(destinationint, isActive, ident);
            if (route != null && route.exitOrientation != ignore) {
                if (route.distanceToDestination + traveled >= max) {
                    return 2.147483647E9;
                }
                return route.distanceToDestination;
            }
        }
        return 2.147483647E9;
    }

    public void triggerConnectionCheck() {
        this.recheckConnections = true;
    }

    @Override
    public CacheHolder getCacheHolder() {
        if (this.cacheHolder == null) {
            this.cacheHolder = this.container instanceof ILPTEInformation && ((ILPTEInformation)((Object)this.container)).getObject() != null ? ((ILPTEInformation)((Object)this.container)).getObject().getCacheHolder() : new CacheHolder();
        }
        return this.cacheHolder;
    }

    public List<IOrderInfoProvider> getClientSideOrderManager() {
        return this.clientSideOrderManager;
    }

    public static enum ItemSendMode {
        Normal,
        Fast;

    }
}

