/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.robotics.RobotStationPluggable;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotGotoStation;
import buildcraft.robotics.ai.AIRobotStraightMoveTo;
import buildcraft.transport.TileGenericPipe;
import cofh.api.energy.IEnergyStorage;
import java.util.HashSet;
import java.util.Set;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.buildcraft.robots.LPRobotConnectionControl;
import logisticspipes.proxy.buildcraft.robots.ai.ItemInsertionAIRobot;
import logisticspipes.proxy.buildcraft.robots.boards.LogisticsRoutingBoardRobotNBT;
import logisticspipes.routing.ExitRoute;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.transactor.ITransactor;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsRoutingBoardRobot
extends RedstoneBoardRobot {
    private boolean acceptsItems = true;
    private boolean init = false;
    private Set<LPTravelingItem.LPTravelingItemServer> items = new HashSet<LPTravelingItem.LPTravelingItemServer>();
    private LPPosition targetStationPos;
    private ForgeDirection targetStationSide = ForgeDirection.UNKNOWN;
    private int ticksWithContent = 0;
    private LPRobotConnectionControl.RobotConnection connectionDetails = new LPRobotConnectionControl.RobotConnection();
    private Pair<Double, LogisticsRoutingBoardRobot> currentTarget = null;

    public LogisticsRoutingBoardRobot(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public RedstoneBoardRobotNBT getNBTHandler() {
        return LogisticsRoutingBoardRobotNBT.instance;
    }

    public void start() {
        super.start();
        this.index();
    }

    private void index() {
        if (this.init) {
            return;
        }
        DockingStation dock = this.robot.getLinkedStation();
        if (dock == null) {
            return;
        }
        LPPosition pos = new LPPosition(dock.x(), dock.y(), dock.z());
        LPRobotConnectionControl.instance.addRobot(this.robot.field_70170_p, pos, dock.side());
        this.init = true;
    }

    public void update() {
        this.lpUpdate();
    }

    public void lpUpdate() {
        IEnergyStorage bat;
        int need;
        this.index();
        if (this.robot.containsItems()) {
            ++this.ticksWithContent;
            if (this.ticksWithContent > 40) {
                this.startTransport();
                this.ticksWithContent = 0;
            }
        } else {
            this.ticksWithContent = 0;
            this.acceptsItems = true;
            if (this.currentTarget != null) {
                this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
                this.currentTarget = null;
                this.refreshRoutingTable();
            } else if (this.robot.getDockingStation() == null) {
                this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
            }
        }
        if ((need = (bat = this.robot.getBattery()).getMaxEnergyStored() - bat.getEnergyStored()) <= 1000) {
            return;
        }
        need = bat.receiveEnergy(need, true);
        TileEntity tile = this.getLinkedStationPosition().getTileEntity(this.robot.field_70170_p);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).isRoutingPipe()) {
            CoreRoutedPipe pipe = ((LogisticsTileGenericPipe)tile).getRoutingPipe();
            boolean energyUsed = false;
            int count = 0;
            while (!energyUsed) {
                if (pipe.useEnergy((int)((double)need * 1.5 * 2.0))) {
                    energyUsed = true;
                }
                if (count++ <= 5) continue;
            }
            if (energyUsed) {
                bat.receiveEnergy(need, false);
            }
        }
    }

    public void delegateAIEnded(AIRobot ai) {
        super.delegateAIEnded(ai);
        if (ai instanceof AIRobotGotoBlock) {
            if (!ai.success()) {
                this.dropAndClear();
                this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
            } else {
                this.startDelegateAI((AIRobot)new AIRobotStraightMoveTo(this.robot, (float)this.targetStationPos.getXD() + 0.5f + (float)this.targetStationSide.offsetX * 0.5f, (float)this.targetStationPos.getYD() + 0.5f + (float)this.targetStationSide.offsetY * 0.5f, (float)this.targetStationPos.getZD() + 0.5f + (float)this.targetStationSide.offsetZ * 0.5f));
            }
        } else if (ai instanceof AIRobotStraightMoveTo) {
            if (!ai.success()) {
                this.dropAndClear();
                this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
            } else {
                this.insertIntoPipe();
            }
        } else if (ai instanceof ItemInsertionAIRobot) {
            for (int i = 0; i < this.robot.func_70302_i_(); ++i) {
                this.robot.func_70299_a(i, null);
            }
            if (!ai.success()) {
                this.dropAndClear();
            } else {
                this.items.clear();
            }
            this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
            this.targetStationPos = null;
        }
    }

    private void insertIntoPipe() {
        TileEntity tile = this.targetStationPos.getTileEntity(this.robot.field_70170_p);
        if (tile instanceof LogisticsTileGenericPipe) {
            this.startDelegateAI(new ItemInsertionAIRobot(this.robot, (LogisticsTileGenericPipe)tile, this, this.targetStationSide.getOpposite()));
        } else {
            this.dropAndClear();
            this.startDelegateAI((AIRobot)new AIRobotGotoStation(this.robot, this.robot.getLinkedStation()));
            this.targetStationPos = null;
        }
    }

    private Pair<Double, LogisticsRoutingBoardRobot> findTarget() {
        Pair<Double, LogisticsRoutingBoardRobot> result = null;
        LPPosition robotPos = new LPPosition((Entity)this.robot);
        for (Pair<LPPosition, ForgeDirection> canidatePos : this.connectionDetails.localConnectedRobots) {
            EntityRobotBase connectedRobot;
            DockingStation connectedStation;
            PipePluggable connectedPluggable;
            LogisticsTileGenericPipe connectedPipe;
            TileEntity connectedPipeTile;
            if (this.robot.getLinkedStation() == null || canidatePos.getValue1().equals(new LPPosition(this.robot.getLinkedStation().x(), this.robot.getLinkedStation().y(), this.robot.getLinkedStation().z()))) continue;
            double distance = canidatePos.getValue1().copy().center().moveForward(canidatePos.getValue2(), 0.5).distanceTo(robotPos);
            if (result != null && !((Double)result.getValue1() > distance) || !((connectedPipeTile = canidatePos.getValue1().getTileEntity(this.robot.field_70170_p)) instanceof LogisticsTileGenericPipe) || !(connectedPipe = (LogisticsTileGenericPipe)connectedPipeTile).isRoutingPipe() || !((connectedPluggable = ((TileGenericPipe)connectedPipe.tilePart.getOriginal()).getPipePluggable(canidatePos.getValue2())) instanceof RobotStationPluggable) || !(connectedStation = ((RobotStationPluggable)connectedPluggable).getStation()).isTaken() || (connectedRobot = connectedStation.robotTaking()) == null || !(connectedRobot.getBoard() instanceof LogisticsRoutingBoardRobot) || connectedRobot.field_70128_L || connectedRobot.getZoneToWork() != null && !connectedRobot.getZoneToWork().contains(robotPos.getXD(), robotPos.getYD(), robotPos.getZD()) || !((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).isAcceptsItems() || ((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).getCurrentTarget() != null && ((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).getCurrentTarget().getValue2() != this.robot.getBoard()) continue;
            LPPosition connectedRobotPos = new LPPosition((Entity)connectedRobot);
            if (canidatePos.getValue1().copy().center().moveForward(canidatePos.getValue2(), 0.5).distanceTo(connectedRobotPos) > 0.05) continue;
            Double mindis = Double.NaN;
            for (LPTravelingItem.LPTravelingItemServer item : this.items) {
                ExitRoute route;
                item.checkIDFromUUID();
                if (item.getInfo().destinationint < 0 || (route = connectedPipe.getRoutingPipe().getRouter().getExitFor(item.getInfo().destinationint, item.getInfo()._transportMode == IRoutedItem.TransportMode.Active, item.getItemIdentifierStack().getItem())) == null) continue;
                if (mindis.isNaN()) {
                    mindis = route.distanceToDestination;
                }
                mindis = Math.min(mindis, route.distanceToDestination);
            }
            if (mindis.isNaN()) continue;
            double distanceToItem = distance * 3.0 + 21.0 + mindis;
            if (result != null && !((Double)result.getValue1() > distanceToItem)) continue;
            result = new Pair<Double, LogisticsRoutingBoardRobot>(distanceToItem, (LogisticsRoutingBoardRobot)connectedRobot.getBoard());
        }
        return result;
    }

    private void startTransport() {
        if (this.currentTarget == null) {
            this.currentTarget = this.findTarget();
        }
        if (this.currentTarget != null) {
            DockingStation station1 = this.robot.getDockingStation();
            DockingStation station2 = this.currentTarget.getValue2().robot.getDockingStation();
            if (station1 == null) {
                station1 = this.robot.getLinkedStation();
            }
            if (station2 == null) {
                station2 = this.currentTarget.getValue2().robot.getLinkedStation();
            }
            this.startTransport(this.currentTarget.getValue2(), station2);
            this.currentTarget.getValue2().startTransport(this, station1);
        } else {
            this.dropAndClear();
        }
    }

    private void dropAndClear() {
        for (LPTravelingItem.LPTravelingItemServer item : this.items) {
            item.itemWasLost();
            this.robot.field_70170_p.func_72838_d((Entity)item.getItemIdentifierStack().makeEntityItem(this.robot.field_70170_p, this.robot.field_70165_t, this.robot.field_70163_u, this.robot.field_70161_v));
        }
        this.items.clear();
        for (int i = 0; i < this.robot.func_70302_i_(); ++i) {
            this.robot.func_70299_a(i, null);
        }
    }

    private void startTransport(LogisticsRoutingBoardRobot target, DockingStation station) {
        this.acceptsItems = false;
        this.targetStationPos = new LPPosition(station.x(), station.y(), station.z());
        this.targetStationSide = station.side();
        this.startDelegateAI((AIRobot)new AIRobotGotoBlock(this.robot, station.x() + station.side().offsetX, station.y() + station.side().offsetY, station.z() + station.side().offsetZ));
    }

    public LPTravelingItem.LPTravelingItemServer handleItem(LPTravelingItem.LPTravelingItemServer arrivingItem) {
        if (this.robot.field_70128_L) {
            return arrivingItem;
        }
        ITransactor trans = InventoryHelper.getTransactorFor(this.robot, ForgeDirection.UNKNOWN);
        ItemStack inserted = trans.add(arrivingItem.getItemIdentifierStack().makeNormalStack(), ForgeDirection.UNKNOWN, false);
        if (inserted.field_77994_a != arrivingItem.getItemIdentifierStack().getStackSize()) {
            this.acceptsItems = false;
            this.startTransport();
            return arrivingItem;
        }
        inserted = trans.add(arrivingItem.getItemIdentifierStack().makeNormalStack(), ForgeDirection.UNKNOWN, true);
        if (inserted.field_77994_a != arrivingItem.getItemIdentifierStack().getStackSize()) {
            throw new UnsupportedOperationException("" + trans);
        }
        this.items.add(arrivingItem);
        if (this.currentTarget == null) {
            this.currentTarget = this.findTarget();
            this.refreshRoutingTable();
        }
        this.ticksWithContent = 0;
        return null;
    }

    private void refreshRoutingTable() {
        TileEntity tile = this.getLinkedStationPosition().getTileEntity(this.robot.field_70170_p);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).isRoutingPipe()) {
            CoreRoutedPipe pipe = ((LogisticsTileGenericPipe)tile).getRoutingPipe();
            pipe.getRouter().update(true, pipe);
        }
    }

    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74768_a("LP_Item_Size", this.items.size());
        int count = 0;
        for (LPTravelingItem.LPTravelingItemServer stack : this.items) {
            NBTTagCompound nbt_Sub = new NBTTagCompound();
            stack.writeToNBT(nbt_Sub);
            nbt.func_74782_a("LP_Item_" + count++, (NBTBase)nbt_Sub);
        }
        if (this.targetStationPos != null) {
            this.targetStationPos.writeToNBT("targetStationPos_", nbt);
        }
        nbt.func_74774_a("targetStationSide", (byte)this.targetStationSide.ordinal());
    }

    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.items.clear();
        for (int i = 0; i < nbt.func_74762_e("LP_Item_Size"); ++i) {
            if (!nbt.func_74764_b("LP_Item_" + i)) continue;
            this.items.add(new LPTravelingItem.LPTravelingItemServer(nbt.func_74775_l("LP_Item_" + i)));
        }
        this.targetStationPos = LPPosition.readFromNBT("targetStationPos_", nbt);
        this.targetStationSide = ForgeDirection.getOrientation((int)nbt.func_74771_c("targetStationSide"));
    }

    public LPPosition getLinkedStationPosition() {
        return new LPPosition(this.robot.getLinkedStation().x(), this.robot.getLinkedStation().y(), this.robot.getLinkedStation().z());
    }

    public boolean isAcceptsItems() {
        return this.acceptsItems;
    }

    public Set<LPTravelingItem.LPTravelingItemServer> getItems() {
        return this.items;
    }

    public LPRobotConnectionControl.RobotConnection getConnectionDetails() {
        return this.connectionDetails;
    }

    public Pair<Double, LogisticsRoutingBoardRobot> getCurrentTarget() {
        return this.currentTarget;
    }
}

