/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialconnection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.interfaces.routing.ISpecialTileConnection;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TesseractConnection
implements ISpecialTileConnection {
    @Override
    public boolean init() {
        return SimpleServiceLocator.thermalExpansionProxy.isTE();
    }

    @Override
    public boolean isType(TileEntity tile) {
        return SimpleServiceLocator.thermalExpansionProxy.isTesseract(tile);
    }

    public List<TileEntity> getConnections(TileEntity tile) {
        boolean onlyOnePipe = false;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            LPPosition p = new LPPosition(tile);
            p.moveForward(direction);
            TileEntity canidate = p.getTileEntity(tile.func_145831_w());
            if (!(canidate instanceof LogisticsTileGenericPipe) || !MainProxy.checkPipesConnections(tile, canidate, direction)) continue;
            if (onlyOnePipe) {
                onlyOnePipe = false;
                break;
            }
            onlyOnePipe = true;
        }
        if (!onlyOnePipe) {
            return new ArrayList<TileEntity>(0);
        }
        List<TileEntity> connections = SimpleServiceLocator.thermalExpansionProxy.getConnectedTesseracts(tile);
        connections.remove(tile);
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (TileEntity connected : connections) {
            LogisticsTileGenericPipe pipe = null;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                LPPosition p = new LPPosition(connected);
                p.moveForward(direction);
                TileEntity canidate = p.getTileEntity(connected.func_145831_w());
                if (!(canidate instanceof LogisticsTileGenericPipe) || !MainProxy.checkPipesConnections(connected, canidate, direction)) continue;
                if (pipe != null) {
                    pipe = null;
                    break;
                }
                pipe = (LogisticsTileGenericPipe)canidate;
            }
            if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) continue;
            list.add(pipe);
        }
        if (list.size() == 1) {
            return list;
        }
        return new ArrayList<TileEntity>(0);
    }

    @Override
    public boolean needsInformationTransition() {
        return true;
    }

    @Override
    public void transmit(TileEntity tile, IRoutedItem data) {
        Collection list = this.getConnections(tile);
        if (list.size() < 1) {
            return;
        }
        TileEntity pipe = (TileEntity)list.get(0);
        if (pipe instanceof LogisticsTileGenericPipe) {
            ((CoreRoutedPipe)((LogisticsTileGenericPipe)pipe).pipe).queueUnroutedItemInformation(data.getItemIdentifierStack().clone(), data.getInfo());
        } else {
            new RuntimeException("Only LP pipes can be next to Tesseracts to queue item information").printStackTrace();
        }
    }
}

