/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.types.classifier;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.UUID;
import openmods.reflection.TypeUtils;
import openperipheral.adapter.types.EnumeratedRange;
import openperipheral.adapter.types.ListType;
import openperipheral.adapter.types.MapType;
import openperipheral.adapter.types.NamedTupleType;
import openperipheral.adapter.types.SetType;
import openperipheral.adapter.types.SingleArgType;
import openperipheral.adapter.types.TypeHelper;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.adapter.ITypeClassifier;
import openperipheral.converter.StructHandlerProvider;

public class DefaultTypeClassifier
implements ITypeClassifier.IGenericClassifier {
    @Override
    public IScriptType classify(ITypeClassifier classifier, Type type) {
        TypeToken typeToken = TypeToken.of((Type)type);
        Class cls = TypeUtils.toObjectType((Class)typeToken.getRawType());
        if (cls == String.class) {
            return SingleArgType.STRING;
        }
        if (cls == UUID.class) {
            return SingleArgType.STRING;
        }
        if (cls == Boolean.class) {
            return SingleArgType.BOOLEAN;
        }
        if (cls == Void.class) {
            return SingleArgType.VOID;
        }
        if (Number.class.isAssignableFrom(cls)) {
            return SingleArgType.NUMBER;
        }
        if (cls.isEnum()) {
            return TypeHelper.bounded(SingleArgType.STRING, EnumeratedRange.create(cls.getEnumConstants()));
        }
        if (StructHandlerProvider.instance.isStruct(cls)) {
            return DefaultTypeClassifier.classifyStruct(classifier, cls);
        }
        if (typeToken.isArray()) {
            return DefaultTypeClassifier.classifyArrayType(classifier, typeToken);
        }
        if (TypeUtils.MAP_TOKEN.isAssignableFrom(typeToken)) {
            return DefaultTypeClassifier.classifyMapType(classifier, typeToken);
        }
        if (TypeUtils.SET_TOKEN.isAssignableFrom(typeToken)) {
            return DefaultTypeClassifier.classifySetType(classifier, typeToken);
        }
        if (TypeUtils.COLLECTION_TOKEN.isAssignableFrom(typeToken)) {
            return DefaultTypeClassifier.classifyCollectionType(classifier, typeToken);
        }
        return null;
    }

    private static IScriptType createListType(ITypeClassifier classifier, TypeToken<?> type) {
        return type.getRawType() != Object.class ? new ListType(classifier.classifyType(type.getType())) : SingleArgType.TABLE;
    }

    private static IScriptType createSetType(ITypeClassifier classifier, TypeToken<?> type) {
        return type.getRawType() != Object.class ? new SetType(classifier.classifyType(type.getType())) : SingleArgType.TABLE;
    }

    private static IScriptType classifyArrayType(ITypeClassifier classifier, TypeToken<?> typeToken) {
        TypeToken componentType = typeToken.getComponentType();
        return DefaultTypeClassifier.createListType(classifier, componentType);
    }

    private static IScriptType classifyCollectionType(ITypeClassifier classifier, TypeToken<?> typeToken) {
        TypeToken componentType = typeToken.resolveType((Type)TypeUtils.COLLECTION_VALUE_PARAM);
        return DefaultTypeClassifier.createListType(classifier, componentType);
    }

    private static IScriptType classifySetType(ITypeClassifier classifier, TypeToken<?> typeToken) {
        TypeToken componentType = typeToken.resolveType((Type)TypeUtils.SET_VALUE_PARAM);
        return DefaultTypeClassifier.createSetType(classifier, componentType);
    }

    private static IScriptType classifyMapType(ITypeClassifier classifier, TypeToken<?> typeToken) {
        TypeToken keyType = typeToken.resolveType((Type)TypeUtils.MAP_KEY_PARAM);
        TypeToken valueType = typeToken.resolveType((Type)TypeUtils.MAP_VALUE_PARAM);
        if (keyType.getRawType() == Object.class || valueType.getRawType() == Object.class) {
            return SingleArgType.TABLE;
        }
        IScriptType qualifiedKeyType = classifier.classifyType(keyType.getType());
        IScriptType qualifiedValueType = classifier.classifyType(valueType.getType());
        return new MapType(qualifiedKeyType, qualifiedValueType);
    }

    private static IScriptType classifyStruct(ITypeClassifier classifier, Class<?> cls) {
        StructHandlerProvider.IStructHandler handler = StructHandlerProvider.instance.getHandler(cls);
        ArrayList fields = Lists.newArrayList();
        for (StructHandlerProvider.IFieldHandler f : handler.fields()) {
            IScriptType type = classifier.classifyType(f.type());
            fields.add(new NamedTupleType.NamedTupleField(f.name(), type, f.isOptional()));
        }
        return new NamedTupleType(fields);
    }
}

