/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.client.render;

import cpw.mods.fml.common.FMLLog;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CustomTechneModel
extends ModelBase
implements IModelCustom {
    public static final List<String> cubeTypes = Arrays.asList("d9e621f7-957f-4b77-b1ae-20dcd0da7751", "de81aa14-bd60-4228-8d8d-5238bcd3caaa");
    private String fileName;
    private Map<String, byte[]> zipContents = new HashMap<String, byte[]>();
    private Map<String, ModelRenderer> parts = new LinkedHashMap<String, ModelRenderer>();
    private String texture = null;
    private Dimension textureDims = null;
    private DynamicTexture dynamicTexture;
    private boolean textureNameSet = false;

    public CustomTechneModel(ResourceLocation resource) throws ModelFormatException {
        this.fileName = resource.toString();
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            this.loadTechneModel(res.func_110527_b());
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", (Throwable)e);
        }
    }

    private void loadTechneModel(InputStream stream) throws ModelFormatException {
        try {
            NodeList textureDim;
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(stream);
            while ((entry = zipInput.getNextEntry()) != null) {
                byte[] data = new byte[(int)entry.getSize()];
                int i = 0;
                while (zipInput.available() > 0 && i < data.length) {
                    data[i++] = (byte)zipInput.read();
                }
                this.zipContents.put(entry.getName(), data);
            }
            byte[] modelXml = this.zipContents.get("model.xml");
            if (modelXml == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains no model.xml file");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(modelXml));
            NodeList nodeListTechne = document.getElementsByTagName("Techne");
            if (nodeListTechne.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Techne tag");
            }
            NodeList nodeListModel = document.getElementsByTagName("Model");
            if (nodeListModel.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Model tag");
            }
            NamedNodeMap modelAttributes = nodeListModel.item(0).getAttributes();
            if (modelAttributes == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains a Model tag with no attributes");
            }
            Node modelTexture = modelAttributes.getNamedItem("texture");
            if (modelTexture != null) {
                this.texture = modelTexture.getTextContent();
            }
            if ((textureDim = document.getElementsByTagName("TextureSize")).getLength() > 0) {
                try {
                    String[] tmp = textureDim.item(0).getTextContent().split(",");
                    if (tmp.length == 2) {
                        this.textureDims = new Dimension(Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]));
                    }
                }
                catch (NumberFormatException e) {
                    throw new ModelFormatException("Model " + this.fileName + " contains a TextureSize tag with invalid data");
                }
            }
            NodeList shapes = document.getElementsByTagName("Shape");
            for (int i = 0; i < shapes.getLength(); ++i) {
                Node shape = shapes.item(i);
                NamedNodeMap shapeAttributes = shape.getAttributes();
                if (shapeAttributes == null) {
                    throw new ModelFormatException("Shape #" + (i + 1) + " in " + this.fileName + " has no attributes");
                }
                Node name = shapeAttributes.getNamedItem("name");
                String shapeName = null;
                if (name != null) {
                    shapeName = name.getNodeValue();
                }
                if (shapeName == null) {
                    shapeName = "Shape #" + (i + 1);
                }
                String shapeType = null;
                Node type = shapeAttributes.getNamedItem("type");
                if (type != null) {
                    shapeType = type.getNodeValue();
                }
                if (shapeType != null && !cubeTypes.contains(shapeType)) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " is not a cube, ignoring"), (Object[])new Object[0]);
                    continue;
                }
                try {
                    boolean mirrored = false;
                    String[] offset = new String[3];
                    String[] position = new String[3];
                    String[] rotation = new String[3];
                    String[] size = new String[3];
                    String[] textureOffset = new String[2];
                    NodeList shapeChildren = shape.getChildNodes();
                    for (int j = 0; j < shapeChildren.getLength(); ++j) {
                        Node shapeChild = shapeChildren.item(j);
                        String shapeChildName = shapeChild.getNodeName();
                        String shapeChildValue = shapeChild.getTextContent();
                        if (shapeChildValue == null) continue;
                        shapeChildValue = shapeChildValue.trim();
                        if (shapeChildName.equals("IsMirrored")) {
                            mirrored = !shapeChildValue.equals("False");
                            continue;
                        }
                        if (shapeChildName.equals("Offset")) {
                            offset = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Position")) {
                            position = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Rotation")) {
                            rotation = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Size")) {
                            size = shapeChildValue.split(",");
                            continue;
                        }
                        if (!shapeChildName.equals("TextureOffset")) continue;
                        textureOffset = shapeChildValue.split(",");
                    }
                    ModelRenderer cube = new ModelRenderer((ModelBase)this, Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
                    cube.field_78809_i = mirrored;
                    cube.func_78789_a(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
                    cube.func_78793_a(Float.parseFloat(position[0]), Float.parseFloat(position[1]) - 23.4f, Float.parseFloat(position[2]));
                    cube.field_78795_f = (float)Math.toRadians(Float.parseFloat(rotation[0]));
                    cube.field_78796_g = (float)Math.toRadians(Float.parseFloat(rotation[1]));
                    cube.field_78808_h = (float)Math.toRadians(Float.parseFloat(rotation[2]));
                    if (this.textureDims != null) {
                        cube.func_78787_b((int)this.textureDims.getWidth(), (int)this.textureDims.getHeight());
                    }
                    this.parts.put(shapeName, cube);
                    continue;
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " contains malformed integers within its data, ignoring"), (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
        }
        catch (ZipException e) {
            throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
        }
        catch (IOException e) {
            throw new ModelFormatException("Model " + this.fileName + " could not be read", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            throw new ModelFormatException("Model " + this.fileName + " contains invalid XML", (Throwable)e);
        }
    }

    public void bindTexture() {
        if (this.texture != null) {
            if (!this.textureNameSet) {
                try {
                    byte[] textureEntry = this.zipContents.get(this.texture);
                    if (textureEntry == null) {
                        throw new ModelFormatException("Model " + this.fileName + " has no such texture " + this.texture);
                    }
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(textureEntry));
                    this.dynamicTexture = new DynamicTexture(image);
                    ResourceLocation resourceLocation = new ResourceLocation("powerconverters:textures/models/dynamic/" + this.dynamicTexture.func_110552_b());
                    Minecraft.func_71410_x().field_71446_o.func_110579_a(resourceLocation, (ITextureObject)this.dynamicTexture);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
                    this.textureNameSet = true;
                }
                catch (ZipException e) {
                    throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
                }
                catch (IOException e) {
                    throw new ModelFormatException("Texture for model " + this.fileName + " could not be read", (Throwable)e);
                }
            }
            if (this.textureNameSet) {
                GL11.glBindTexture((int)3553, (int)this.dynamicTexture.func_110552_b());
            }
        }
    }

    public String getType() {
        return "tcn";
    }

    public void renderAll() {
        for (String name : this.parts.keySet()) {
            ModelRenderer part = this.parts.get(name);
            part.func_78785_a(1.0f);
        }
    }

    public void renderPart(String partName) {
        ModelRenderer part = this.parts.get(partName);
        if (part != null) {
            part.func_78791_b(1.0f);
        }
    }

    public void renderOnly(String ... groupNames) {
        for (ModelRenderer part : this.parts.values()) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(part.field_78802_n)) continue;
                part.func_78785_a(1.0f);
            }
        }
    }

    public void renderAllExcept(String ... excludedGroupNames) {
        for (ModelRenderer part : this.parts.values()) {
            boolean skipPart = false;
            for (String excludedGroupName : excludedGroupNames) {
                if (!excludedGroupName.equalsIgnoreCase(part.field_78802_n)) continue;
                skipPart = true;
            }
            if (skipPart) continue;
            part.func_78785_a(1.0f);
        }
    }
}

