/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.net;

import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.Recipes;
import covers1624.powerconverters.nei.NEIInfoHandlerConfig;
import covers1624.powerconverters.net.AbstractPacket;
import covers1624.powerconverters.util.IRecipeHandler;
import covers1624.powerconverters.util.LogHelper;
import covers1624.powerconverters.util.RecipeRemover;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RecipeSyncPacket
extends AbstractPacket {
    private NBTTagCompound tagCompound;

    public RecipeSyncPacket() {
    }

    public RecipeSyncPacket(NBTTagCompound tag) {
        this.tagCompound = tag;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tagCompound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (ConfigurationHandler.ignoreRecipesFromServer) {
            LogHelper.trace("Ignoring recipe packet from server.");
            return;
        }
        NBTTagList tagList = this.tagCompound.func_150295_c("Recipes", 10);
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            IRecipe recipe = IRecipeHandler.readIRecipeFromTag(tagList.func_150305_b(i));
            if (recipe == null) continue;
            recipes.add(recipe);
        }
        ArrayList<ItemStack> currentOutputs = new ArrayList<ItemStack>();
        for (IRecipe recipe : Recipes.getCurrentRecipes()) {
            ItemStack stack = recipe.func_77571_b();
            currentOutputs.add(stack);
        }
        RecipeRemover.removeAnyRecipes(currentOutputs);
        for (IRecipe recipe : recipes) {
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            NEIInfoHandlerConfig.addRecipesToNEI();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

