/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.ic2;

import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIndustrialCraftProducer
extends TileEntityEnergyProducer<IEnergyAcceptor>
implements IEnergySource {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private double eu;
    private int _packetCount = 1;

    public TileEntityIndustrialCraftProducer() {
        this(0);
    }

    public TileEntityIndustrialCraftProducer(int voltageIndex) {
        super(PowerSystems.powerSystemIndustrialCraft, voltageIndex, IEnergyAcceptor.class);
    }

    @Override
    public void func_145845_h() {
        if (!this._didFirstAddToNet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
        super.func_145845_h();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_145843_s() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    @Override
    public double produceEnergy(double energy) {
        if (ConfigurationHandler.dissableIC2Producer) {
            return energy;
        }
        double eu = energy / (double)PowerSystems.powerSystemIndustrialCraft.getScaleAmmount();
        double usedEu = Math.min(eu, this.getMaxEnergyOutput() - this.eu);
        this.eu += usedEu;
        return (eu - usedEu) * (double)PowerSystems.powerSystemIndustrialCraft.getScaleAmmount();
    }

    public double getMaxEnergyOutput() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.eu, this.getMaxEnergyOutput());
    }

    public void drawEnergy(double amount) {
        this.eu -= (double)MathHelper.func_76143_f((double)amount);
    }

    public int getSourceTier() {
        return this.getVoltageIndex();
    }
}

