/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemDefinition;
import minetweaker.api.item.IItemStack;

public class IngredientMap<T> {
    private final HashMap<IItemDefinition, List<IngredientMapEntry<T>>> entries = new HashMap();

    public IngredientMapEntry<T> register(IIngredient ingredient, T entry) {
        HashSet<IItemDefinition> items = new HashSet<IItemDefinition>();
        for (IItemStack item : ingredient.getItems()) {
            items.add(item.getDefinition());
        }
        IngredientMapEntry<T> actualEntry = new IngredientMapEntry<T>(ingredient, entry);
        for (IItemDefinition item : items) {
            if (!this.entries.containsKey(item)) {
                this.entries.put(item, new ArrayList());
            }
            this.entries.get(item).add(actualEntry);
        }
        return actualEntry;
    }

    public void unregister(IngredientMapEntry<T> entry) {
        HashSet<IItemDefinition> items = new HashSet<IItemDefinition>();
        for (IItemStack iItemStack : ((IngredientMapEntry)entry).ingredient.getItems()) {
            items.add(iItemStack.getDefinition());
        }
        for (IItemDefinition iItemDefinition : items) {
            if (!this.entries.containsKey(iItemDefinition)) continue;
            this.entries.get(iItemDefinition).remove(entry);
        }
    }

    public T getFirstEntry(IItemStack item) {
        for (IngredientMapEntry<T> entry : this.entries.get(item.getDefinition())) {
            if (!((IngredientMapEntry)entry).ingredient.matches(item)) continue;
            return (T)((IngredientMapEntry)entry).entry;
        }
        return null;
    }

    public List<T> getEntries(IItemStack item) {
        List<IngredientMapEntry<T>> entries = this.entries.get(item.getDefinition());
        if (entries != null) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (IngredientMapEntry<T> entry : entries) {
                if (!((IngredientMapEntry)entry).ingredient.matches(item)) continue;
                results.add(((IngredientMapEntry)entry).entry);
            }
            return results;
        }
        return Collections.EMPTY_LIST;
    }

    public static class IngredientMapEntry<T> {
        private final IIngredient ingredient;
        private final T entry;

        public IngredientMapEntry(IIngredient ingredient, T entry) {
            this.ingredient = ingredient;
            this.entry = entry;
        }
    }
}

